(function($) {
    'use strict';
    
    var team = {};
    eltdf.modules.team = team;
    
    team.eltdfInitTeamFX = eltdfInitTeamFX;
    team.eltdfOnDocumentReady = eltdfOnDocumentReady;
    
    $(document).ready(eltdfOnDocumentReady);
    $(window).on('load', eltdfOnWindowLoad);
    
    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function eltdfOnDocumentReady() {
        eltdfInitTeamFX();
    }

    /*
    All functions to be called on $(window).on('load') should be in this function
    */
    function eltdfOnWindowLoad() {
        eltdfElementorTeam();
    }

    /**
     * Elementor
     */
    function eltdfElementorTeam(){
        $(window).on('elementor/frontend/init', function () {
            elementorFrontend.hooks.addAction( 'frontend/element_ready/eltdf_team.default', function() {
                eltdfInitTeamFX();
            } );
        });
    }
    
    /**
     * Init Team loading animation fx
     */
    function eltdfInitTeamFX() {
        var items = $('.eltdf-team-with-loading-animation');

        if (items.length && !eltdf.htmlEl.hasClass('touchevents')) {
            var coeff = 6;

            items.appear(function() {
                var item = $(this),
                    delay = 100 * (Math.floor(Math.random() * coeff)) + 'ms';

                item
                    .addClass('eltdf-appeared')
                    .css('transition-delay', delay);
            })
        }
    }
})(jQuery);