<?php

if ( ! function_exists( 'sahel_core_include_shortcodes_file' ) ) {
	/**
	 * Loades all shortcodes by going through all folders that are placed directly in shortcodes folder
	 */
	function sahel_core_include_shortcodes_file() {
		if ( sahel_core_theme_installed() && sahel_core_is_theme_registered() ) {
			foreach (glob(SAHEL_CORE_SHORTCODES_PATH . '/*/load.php') as $shortcode) {
				if (sahel_elated_is_customizer_item_enabled($shortcode, 'sahel_performance_disable_shortcode_')) {
					include_once $shortcode;
				}
			}
		}
		
		do_action( 'sahel_core_action_include_shortcodes_file' );
	}
	
	add_action( 'init', 'sahel_core_include_shortcodes_file', 6 ); // permission 6 is set to be before vc_before_init hook that has permission 9
}

if ( ! function_exists( 'sahel_core_load_shortcodes' ) ) {
	function sahel_core_load_shortcodes() {
		include_once SAHEL_CORE_ABS_PATH . '/lib/shortcode-loader.php';
		
		SahelCore\Lib\ShortcodeLoader::getInstance()->load();
	}
	
	add_action( 'init', 'sahel_core_load_shortcodes', 7 ); // permission 7 is set to be before vc_before_init hook that has permission 9 and after sahel_core_include_shortcodes_file hook
}

if ( ! function_exists( 'sahel_core_add_admin_shortcodes_styles' ) ) {
	/**
	 * Function that includes shortcodes core styles for admin
	 */
	function sahel_core_add_admin_shortcodes_styles() {
		
		//include shortcode styles for Visual Composer
		wp_enqueue_style( 'sahel-core-vc-shortcodes', SAHEL_CORE_ASSETS_URL_PATH . '/css/admin/sahel-vc-shortcodes.css' );
	}
	
	add_action( 'sahel_elated_action_admin_scripts_init', 'sahel_core_add_admin_shortcodes_styles' );
}

if ( ! function_exists( 'sahel_core_add_admin_shortcodes_custom_styles' ) ) {
	/**
	 * Function that print custom vc shortcodes style
	 */
	function sahel_core_add_admin_shortcodes_custom_styles() {
		$style                  = apply_filters( 'sahel_core_filter_add_vc_shortcodes_custom_style', $style = '' );
		$shortcodes_icon_styles = array();
		$shortcode_icon_size    = 32;
		$shortcode_position     = 0;
		
		$shortcodes_icon_class_array = apply_filters( 'sahel_core_filter_add_vc_shortcodes_custom_icon_class', $shortcodes_icon_class_array = array() );
		sort( $shortcodes_icon_class_array );
		
		if ( ! empty( $shortcodes_icon_class_array ) ) {
			foreach ( $shortcodes_icon_class_array as $shortcode_icon_class ) {
				$mark = $shortcode_position != 0 ? '-' : '';
				
				$shortcodes_icon_styles[] = '.vc_element-icon.extended-custom-icon' . esc_attr( $shortcode_icon_class ) . ' {
					background-position: ' . $mark . esc_attr( $shortcode_position * $shortcode_icon_size ) . 'px 0;
				}';
				
				$shortcode_position ++;
			}
		}
		
		if ( ! empty( $shortcodes_icon_styles ) ) {
			$style .= implode( ' ', $shortcodes_icon_styles );
		}
		
		if ( ! empty( $style ) ) {
			wp_add_inline_style( 'sahel-core-vc-shortcodes', $style );
		}
	}
	
	add_action( 'sahel_elated_action_admin_scripts_init', 'sahel_core_add_admin_shortcodes_custom_styles' );
}

if ( ! function_exists( 'sahel_core_load_elementor_shortcodes' ) ) {
	/**
	 * Function that loads elementor files inside shortcodes folder
	 */
	function sahel_core_load_elementor_shortcodes() {
		if ( sahel_core_theme_installed() && sahel_core_is_elementor_installed() && sahel_core_is_theme_registered() ) {
			foreach ( glob( SAHEL_CORE_SHORTCODES_PATH . '/*/elementor-*.php' ) as $shortcode_load ) {

				include_once $shortcode_load;
			}
		}
	}

	add_action( 'elementor/widgets/widgets_registered', 'sahel_core_load_elementor_shortcodes' );
}

if ( ! function_exists( 'sahel_core_add_elementor_widget_categories' ) ) {
	/**
	 * Registers category group
	 */
	function sahel_core_add_elementor_widget_categories( $elements_manager ) {

		$elements_manager->add_category(
			'elated',
			[
				'title' => esc_html__( 'Elated', 'sahel-core' ),
				'icon'  => 'fa fa-plug',
			]
		);

	}

	add_action( 'elementor/elements/categories_registered', 'sahel_core_add_elementor_widget_categories' );
}


if( ! function_exists( 'sahel_core_remove_widgets_for_elementor') ) {
	function sahel_core_remove_widgets_for_elementor( $black_list ) {
		$black_list[] = 'SahelElatedClassAuthorInfoWidget';
		$black_list[] = 'SahelElatedClassBlogListWidget';
		$black_list[] = 'SahelElatedClassButtonWidget';
		$black_list[] = 'SahelElatedClassCustomFontWidget';
		$black_list[] = 'SahelElatedClassImageGalleryWidget';
		$black_list[] = 'SahelElatedClassSearchOpener';
		$black_list[] = 'SahelElatedClassSearchPostType';
		$black_list[] = 'SahelElatedClassSeparatorWidget';
		$black_list[] = 'SahelElatedClassSideAreaOpener';
		$black_list[] = 'SahelElatedClassSocialIconWidget';
		$black_list[] = 'SahelElatedClassClassIconsGroupWidget';
		$black_list[] = 'SahelElatedClassStickySidebar';
		$black_list[] = 'SahelElatedClassWoocommerceDropdownCart';

		return $black_list;
	}

	add_filter('elementor/widgets/black_list', 'sahel_core_remove_widgets_for_elementor');
}

if ( ! function_exists( 'sahel_core_return_elementor_templates' ) ) {
	/**
	 * Function that returns all Elementor saved templates
	 */
	function sahel_core_return_elementor_templates() {
		return Elementor\Plugin::instance()->templates_manager->get_source( 'local' )->get_items();
	}
}

if ( ! function_exists( 'sahel_core_generate_elementor_templates_control' ) ) {
	/**
	 * Function that adds Template Elementor Control
	 */
	function sahel_core_generate_elementor_templates_control( $object ) {
		$templates = sahel_core_return_elementor_templates();

		if ( ! empty( $templates ) ) {
			$options = [
				'0' => '— ' . esc_html__( 'Select', 'sahel-core' ) . ' —',
			];

			$types = [];

			foreach ( $templates as $template ) {
				$options[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
				$types[ $template['template_id'] ]   = $template['type'];
			}

			$object->add_control(
				'template_id',
				[
					'label'       => esc_html__( 'Choose Template', 'sahel-core' ),
					'type'        => \Elementor\Controls_Manager::SELECT,
					'default'     => '0',
					'options'     => $options,
					'types'       => $types,
					'label_block' => 'true'
				]
			);
		};
	}
}

//function that maps "Anchor" option for section
if( ! function_exists('sahel_core_map_section_anchor_option') ){
	function sahel_core_map_section_anchor_option( $section, $args ){
		$section->start_controls_section(
			'section_select_anchor',
			[
				'label' => esc_html__( 'Sahel Anchor', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);

		$section->add_control(
			'anchor_id',
			[
				'label' => esc_html__( 'Sahel Anchor ID', 'sahel-core' ),
				'type'  => Elementor\Controls_Manager::TEXT,
			]
		);

		$section->end_controls_section();
	}

	add_action('elementor/element/section/_section_responsive/after_section_end', 'sahel_core_map_section_anchor_option', 10, 2);
}

//function that renders "Anchor" option for section
if( ! function_exists('sahel_core_render_section_anchor_option') ) {
	function sahel_core_render_section_anchor_option( $element )   {
		if( 'section' !== $element->get_name() ) {
			return;
		}

		$params = $element->get_settings_for_display();

		if( ! empty( $params['anchor_id'] ) ){
			$element->add_render_attribute( '_wrapper', 'data-eltdf-anchor', $params['anchor_id'] );
		}
	}

	add_action( 'elementor/frontend/section/before_render', 'sahel_core_render_section_anchor_option');
}

//function that maps "Parallax" option for section
if ( ! function_exists( 'sahel_core_map_section_parallax_option' ) ) {
	function sahel_core_map_section_parallax_option( $section, $args ) {
		$section->start_controls_section(
			'section_select_parallax',
			[
				'label' => esc_html__( 'Sahel Parallax', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);

		$section->add_control(
			'select_enable_parallax',
			[
				'label'        => esc_html__( 'Enable Parallax', 'sahel-core' ),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'no',
				'options'      => [
					'no'     => esc_html__( 'No', 'sahel-core' ),
					'holder' => esc_html__( 'Yes', 'sahel-core' ),
				],
				'prefix_class' => 'eltdf-parallax-row-'
			]
		);

		$section->add_control(
			'select_parallax_image',
			[
				'label'              => esc_html__( 'Parallax Image', 'sahel-core' ),
				'type'               => Elementor\Controls_Manager::MEDIA,
				'condition'          => [
					'select_enable_parallax' => 'holder'
				],
				'frontend_available' => true,
				'selectors' => [
					'{{WRAPPER}}.eltdf-parallax-row-holder' => 'background-image: url("{{URL}}") !important;'
				]
			]
		);

		$section->add_control(
			'select_parallax_speed',
			[
				'label'     => esc_html__( 'Parallax Speed', 'sahel-core' ),
				'type'      => Elementor\Controls_Manager::TEXT,
				'condition' => [
					'select_enable_parallax' => 'holder'
				],
				'default'   => '0'
			]
		);

		$section->add_control(
			'select_parallax_height',
			[
				'label'     => esc_html__( 'Parallax Section Height (px)', 'sahel-core' ),
				'type'      => Elementor\Controls_Manager::TEXT,
				'condition' => [
					'select_enable_parallax' => 'holder'
				],
				'default'   => '0'
			]
		);

		$section->end_controls_section();
	}

	add_action( 'elementor/element/section/_section_responsive/after_section_end', 'sahel_core_map_section_parallax_option', 10, 2 );
}

//frontend function for "Parallax"
if ( ! function_exists( 'sahel_core_render_section_parallax_option' ) ) {
	function sahel_core_render_section_parallax_option( $element ) {
		if ( 'section' !== $element->get_name() ) {
			return;
		}

		$params = $element->get_settings_for_display();

		if ( ! empty( $params['select_parallax_image']['id'] ) ) {
			$parallax_image_src = $params['select_parallax_image']['url'];
			$parallax_speed     = ! empty( $params['select_parallax_speed'] ) ? $params['select_parallax_speed'] : '1';
			$parallax_height    = ! empty( $params['select_parallax_height'] ) ? $params['select_parallax_height'] : 0;

			$element->add_render_attribute( '_wrapper', 'class', 'eltdf-parallax-row-holder' );
			$element->add_render_attribute( '_wrapper', 'data-parallax-bg-speed', $parallax_speed );
			$element->add_render_attribute( '_wrapper', 'data-parallax-bg-image', $parallax_image_src );
			$element->add_render_attribute( '_wrapper', 'data-parallax-bg-height', $parallax_height );
		}
	}

	add_action( 'elementor/frontend/section/before_render', 'sahel_core_render_section_parallax_option' );
}

//function that renders helper hidden input for parallax data attribute section
if ( ! function_exists( 'sahel_core_generate_parallax_helper' ) ) {
	function sahel_core_generate_parallax_helper( $template, $widget ) {
		if ( 'section' === $widget->get_name() ) {
			$template_preceding = "
            <# if( settings.select_enable_parallax == 'holder' ){
		        let parallaxSpeed = settings.select_parallax_speed !== '' ? settings.select_parallax_speed : '0';
	            let parallaxImage = settings.select_parallax_image.url !== '' ? settings.select_parallax_image.url : '0'
	        #>
		        <input type='hidden' class='eltdf-parallax-helper-holder' data-parallax-bg-speed='{{ parallaxSpeed }}' data-parallax-bg-image='{{ parallaxImage }}'/>
		    <# } #>";
			$template           = $template_preceding . " " . $template;
		}

		return $template;
	}

	add_action( 'elementor/section/print_template', 'sahel_core_generate_parallax_helper', 10, 2 );
}

//function that maps "Content Alignment" option for section
if ( ! function_exists( 'sahel_core_map_section_content_alignment_option' ) ) {
	function sahel_core_map_section_content_alignment_option( $section, $args ) {
		$section->start_controls_section(
			'select_section_content_alignment',
			[
				'label' => esc_html__( 'Sahel Content Alignment', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);

		$section->add_control(
			'select_content_alignment',
			[
				'label'        => esc_html__( 'Content Alignment', 'sahel-core' ),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'left',
				'options'      => [
					'left'   => esc_html__( 'Left', 'sahel-core' ),
					'center' => esc_html__( 'Center', 'sahel-core' ),
					'right'  => esc_html__( 'Right', 'sahel-core' )
				],
				'prefix_class' => 'eltdf-content-aligment-'
			]
		);

		$section->end_controls_section();
	}

	add_action( 'elementor/element/section/_section_responsive/after_section_end', 'sahel_core_map_section_content_alignment_option', 10, 2 );
}

//function that maps "Grid" option for section
if ( ! function_exists( 'sahel_core_map_section_grid_option' ) ) {
	function sahel_core_map_section_grid_option( $section, $args ) {
		$section->start_controls_section(
			'select_section_grid_row',
			[
				'label' => esc_html__( 'Sahel Grid', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);

		$section->add_control(
			'select_enable_grid_row',
			[
				'label'        => esc_html__( 'Make this row "In Grid"', 'sahel-core' ),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'no',
				'options'      => [
					'no'      => esc_html__( 'No', 'sahel-core' ),
					'section' => esc_html__( 'Yes', 'sahel-core' ),
				],
				'prefix_class' => 'eltdf-elementor-row-grid-'
			]
		);

		$section->end_controls_section();
	}

	add_action( 'elementor/element/section/_section_responsive/after_section_end', 'sahel_core_map_section_grid_option', 10, 2 );
}

//function that adds maps "Disable Background" option for section
if ( ! function_exists( 'sahel_core_map_section_disable_background' ) ) {
	function sahel_core_map_section_disable_background( $section, $args ) {
		$section->start_controls_section(
			'select_section_disable_background',
			[
				'label' => esc_html__( 'Sahel Disable Background Image', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);

		$section->add_control(
			'select_disable_background',
			[
				'label'        => esc_html__( 'Disable row background', 'sahel-core' ),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'no',
				'options'      => [
					'no'   => esc_html__( 'Never', 'sahel-core' ),
					'1280' => esc_html__( 'Below 1280px', 'sahel-core' ),
					'1024' => esc_html__( 'Below 1024px', 'sahel-core' ),
					'768'  => esc_html__( 'Below 768px', 'sahel-core' ),
					'680'  => esc_html__( 'Below 680px', 'sahel-core' ),
					'480'  => esc_html__( 'Below 480px', 'sahel-core' )
				],
				'prefix_class' => 'eltdf-disabled-bg-image-bellow-'
			]
		);

		$section->end_controls_section();
	}

	add_action( 'elementor/element/section/_section_responsive/after_section_end', 'sahel_core_map_section_disable_background', 10, 2 );
}


if( ! function_exists('sahel_core_elementor_icons_style') ){
	function sahel_core_elementor_icons_style(){

		wp_enqueue_style( 'sahel-core-elementor', SAHEL_CORE_ASSETS_URL_PATH . '/css/admin/sahel-elementor.css');

	}

	add_action( 'elementor/editor/before_enqueue_scripts', 'sahel_core_elementor_icons_style' );
}


if ( ! function_exists( 'sahel_core_get_elementor_shortcodes_path' ) ) {
	function sahel_core_get_elementor_shortcodes_path() {
		$shortcodes       = array();
		$shortcodes_paths = array(
			SAHEL_CORE_SHORTCODES_PATH . '/*' => SAHEL_CORE_URL_PATH,
			SAHEL_CORE_ABS_PATH . '/**/shortcodes/*' => SAHEL_CORE_URL_PATH,
			SAHEL_CORE_CPT_PATH . '/**/shortcodes/*' => SAHEL_CORE_URL_PATH,
//			SAHEL_INSTAGRAM_SHORTCODES_PATH . '/*' => SAHEL_INSTAGRAM_URL_PATH,
//			SAHEL_TWITTER_SHORTCODES_PATH . '/*' => SAHEL_TWITTER_URL_PATH,
			ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/**/shortcodes/*' => ELATED_FRAMEWORK_ROOT . '/'
		);

		foreach ( $shortcodes_paths as $dir_path => $url_path ) {
			foreach ( glob( $dir_path, GLOB_ONLYDIR ) as $shortcode_dir_path ) {
				$shortcode_name     = basename( $shortcode_dir_path );
				$shortcode_url_path = $url_path . substr( $shortcode_dir_path, strpos( $shortcode_dir_path, basename( $url_path ) ) + strlen( basename( $url_path ) ) + 1 );

				$shortcodes[ $shortcode_name ] = array(
					'dir_path' => $shortcode_dir_path,
					'url_path' => $shortcode_url_path
				);
			}
		}

		return $shortcodes;
	}
}
if ( ! function_exists( 'sahel_core_add_elementor_shortcodes_custom_styles' ) ) {
	function sahel_core_add_elementor_shortcodes_custom_styles() {
		$style                  = '';
		$shortcodes_icon_styles = array();

		$shortcodes_icon_class_array = apply_filters( 'sahel_core_filter_add_vc_shortcodes_custom_icon_class', $shortcodes_icon_class_array = array() );
		sort( $shortcodes_icon_class_array );

		$shortcodes_path = sahel_core_get_elementor_shortcodes_path();
		if ( ! empty( $shortcodes_icon_class_array ) ) {
			foreach ( $shortcodes_icon_class_array as $shortcode_icon_class ) {

				$shortcode_name = str_replace( '.icon-wpb-', '', esc_attr( $shortcode_icon_class ) );

				if ( key_exists( $shortcode_name, $shortcodes_path ) && file_exists( $shortcodes_path[ $shortcode_name ]['dir_path'] . '/assets/img/dashboard_icon.png' ) ) {
					$shortcodes_icon_styles[] = '.sahel-elementor-custom-icon.sahel-elementor-' . $shortcode_name . ' {
                        background-image: url( "' . $shortcodes_path[ $shortcode_name ]['url_path'] . '/assets/img/dashboard_icon.png" );
                    }';
				}
			}
		}

		if ( ! empty( $shortcodes_icon_styles ) ) {
			$style = implode( ' ', $shortcodes_icon_styles );
		}
		if ( ! empty( $style ) ) {
			wp_add_inline_style( 'sahel-core-elementor', $style );
		}
	}

	add_action( 'elementor/editor/before_enqueue_scripts', 'sahel_core_add_elementor_shortcodes_custom_styles', 15 );
}

if ( ! function_exists( 'sahel_core_map_section_dynamic_background_color_option' ) ) {
	function sahel_core_map_section_dynamic_background_color_option( $section, $args ) {
		$section->start_controls_section(
			'sahel_section_dynamic_bg',
			[
				'label' => esc_html__( 'Sahel Dynamic Background Color', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);

		$section->add_control(
			'dynamic_bg_color',
			[
				'label'        => esc_html__( 'Dynamic Background Color', 'sahel-core' ),
				'type'         => Elementor\Controls_Manager::COLOR
			]
		);

		$section->end_controls_section();
	}

	add_action( 'elementor/element/section/_section_responsive/after_section_end', 'sahel_core_map_section_dynamic_background_color_option', 10, 2 );
}

if( ! function_exists('sahel_core_render_section_dynamic_bg_color_option') ) {
	function sahel_core_render_section_dynamic_bg_color_option( $element )   {
		if( 'section' !== $element->get_name() ) {
			return;
		}

		$params = $element->get_settings_for_display();

		if( ! empty( $params['dynamic_bg_color'] ) ){
			$element->add_render_attribute( '_wrapper', 'data-dynamic-bgrnd', $params['dynamic_bg_color'] );
		}
	}

	add_action( 'elementor/frontend/section/before_render', 'sahel_core_render_section_dynamic_bg_color_option');
}

//function that renders helper hidden input for dynamic bg color data attribute section
if ( ! function_exists( 'sahel_core_generate_dynamic_bg_helper' ) ) {
	function sahel_core_generate_dynamic_bg_helper( $template, $widget ) {
		if ( 'section' === $widget->get_name() ) {
			$template_preceding = "
            <# if( settings.dynamic_bg_color !== '' ){ #>
		        <input type='hidden' class='eltdf-dynamic-bg-helper-holder' data-dynamic-bgrnd='{{ settings.dynamic_bg_color }}'/>
		    <# } #>";
			$template           = $template_preceding . " " . $template;
		}

		return $template;
	}

	add_action( 'elementor/section/print_template', 'sahel_core_generate_dynamic_bg_helper', 10, 2 );

}

//function that maps "Content Alignment" option for section
if ( ! function_exists( 'sahel_core_map_section_borders_option' ) ) {
	function sahel_core_map_section_borders_option( $section, $args ) {
		$section->start_controls_section(
			'sahel_section_borders',
			[
				'label' => esc_html__( 'Sahel Borders', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);

		$section->add_control(
			'enable_borders',
			[
				'label'        => esc_html__( 'Sahel Borders', 'sahel-core' ),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => '',
				'options'      => [
					'' => esc_html__( 'None', 'sahel-core' ),
					'left-right'   => esc_html__( 'Left and Right', 'sahel-core' ),
					'top-bottom' => esc_html__( 'Top and Bottom', 'sahel-core' ),
					'all-overflow' => esc_html__( 'All with overflow', 'sahel-core' ),
					'all-no-overflow'  => esc_html__( 'All without overflow', 'sahel-core' )
				]
			]
		);

		$section->add_control(
			'eltd_border_color',
			[
				'label'        => esc_html__( 'Border color', 'sahel-core' ),
				'type'         => Elementor\Controls_Manager::COLOR,
				'condition'    => [
					'enable_borders!' => ''
				]
			]
		);

		$section->add_control(
			'left_right_offset',
			[
				'label'        => esc_html__( 'Left and Right Border Offset', 'sahel-core' ),
				'type'         => Elementor\Controls_Manager::TEXT,
				'description'  => esc_html__('Enter left (right) border offset from the edge of row in px or %', 'sahel-core'),
				'condition'    => [
					'enable_borders!' => [
						'',
						'top-bottom'
					]
				]
			]
		);

		$section->end_controls_section();
	}

	add_action( 'elementor/element/section/_section_responsive/after_section_end', 'sahel_core_map_section_borders_option', 10, 2 );
}

if ( ! function_exists( 'sahel_core_render_section_background_before' ) ) {
	function sahel_core_render_section_background_before( $section ) {
		ob_start();
	}
	add_action( 'elementor/frontend/section/before_render', 'sahel_core_render_section_background_before');
}

if ( ! function_exists( 'sahel_core_render_section_background_after' ) ) {
	function sahel_core_render_section_background_after( $section ) {
		$content = ob_get_clean();

		$params = $section->get_settings_for_display();

		extract( $params );

		$eltdf_row_borders = '';
		if ($enable_borders !== '') {
			$border_style = array();
			$border_left_style = array();
			$border_right_style = array();

			if ($eltd_border_color !== '') {
				$border_style[] = 'background-color:'.$eltd_border_color;
				$border_left_style[] = 'background-color:'.$eltd_border_color;
				$border_right_style[] = 'background-color:'.$eltd_border_color;
			}

			if ($left_right_offset !== '') {
				$border_left_style[] = 'left:'.$left_right_offset;
				$border_right_style[] = 'right:'.$left_right_offset;

				if ($enable_borders == 'all-no-overflow') {
					$border_style[] = 'left:'.$left_right_offset;
					$border_style[] = 'right:'.$left_right_offset;
				}
			}

			$eltdf_row_wrapper_start = '';
			$eltdf_row_wrapper_end = '';


			$eltdf_row_borders .= '<div class="eltdf-row-border-top" '.sahel_elated_get_inline_style($border_style).'></div>';
			$eltdf_row_borders .= '<div class="eltdf-row-border-bottom" '.sahel_elated_get_inline_style($border_style).'></div>';
			$eltdf_row_borders .= '<div class="eltdf-row-border-left" '.sahel_elated_get_inline_style($border_left_style).'></div>';
			$eltdf_row_borders .= '<div class="eltdf-row-border-right" '.sahel_elated_get_inline_style($border_right_style).'></div>';

			$border_class = 'eltdf-row-borders-'.$enable_borders;
			$eltdf_row_wrapper_start .= '<div class="eltdf-row-with-borders '.$border_class.'">';
			$eltdf_row_wrapper_start .= $eltdf_row_borders;
			$eltdf_row_wrapper_end .= '</div>';
		}

		if( ! empty( $enable_borders ) && $enable_borders !== '' ){
			$qodef_elementor_section_html = $eltdf_row_wrapper_start;
			$qodef_elementor_section_html .= $content;
			$qodef_elementor_section_html .= $eltdf_row_wrapper_end;

			echo sahel_elated_get_module_part( $qodef_elementor_section_html );
		} else {
			echo sahel_elated_get_module_part( $content );
		}
	}

	add_action( 'elementor/frontend/section/after_render', 'sahel_core_render_section_background_after');
}

if ( ! function_exists( 'sahel_core_render_section_background_option_admin' ) ) {
	function sahel_core_render_section_background_option_admin( $template, $widget ) {
		if ( 'section' === $widget->get_name() ) {

			$border_style = array();
			$border_left_style = array();
			$border_right_style = array();

			$border_style[] = 'background-color: {{settings.eltd_border_color}}';
			$border_left_style[] = 'background-color: {{settings.eltd_border_color}}';
			$border_right_style[] = 'background-color: {{settings.eltd_border_color}}';

			$border_left_style[] = 'left: {{settings.left_right_offset}}';
			$border_right_style[] = 'right: {{settings.left_right_offset}}';

			$border_no_overflow_style = $border_style;
			$border_no_overflow_style[] = 'left: {{settings.left_right_offset}}';
			$border_no_overflow_style[] = 'right: {{settings.left_right_offset}}';

			$qodef_section_borders = '
				<div class="eltdf-row-with-borders eltdf-elementor-editor eltdf-row-borders-{{settings.enable_borders}}">
					<div class="eltdf-row-border-top" '.sahel_elated_get_inline_style($border_style).'></div>
					<div class="eltdf-row-border-bottom" '.sahel_elated_get_inline_style($border_style).'></div>
					<div class="eltdf-row-border-left" '.sahel_elated_get_inline_style($border_left_style).'></div>
					<div class="eltdf-row-border-right" '.sahel_elated_get_inline_style($border_right_style).'></div>
				</div>
			';

			$qodef_section_borders_no_overflow = '
				<div class="eltdf-row-with-borders eltdf-elementor-editor eltdf-row-borders-{{settings.enable_borders}}">
					<div class="eltdf-row-border-top" '.sahel_elated_get_inline_style($border_no_overflow_style).'></div>
					<div class="eltdf-row-border-bottom" '.sahel_elated_get_inline_style($border_no_overflow_style).'></div>
					<div class="eltdf-row-border-left" '.sahel_elated_get_inline_style($border_left_style).'></div>
					<div class="eltdf-row-border-right" '.sahel_elated_get_inline_style($border_right_style).'></div>
				</div>
			';

			$template_text_after = "
            <#
            if( settings.enable_borders !== '' ){
                if( settings.enable_borders !== 'all-no-overflow' ) {
                #>
                    $qodef_section_borders
                <#
                } else {
                #>
                    $qodef_section_borders_no_overflow
                <#
                }
			}#> ";

			$template = $template_text_after . " " . $template;
		}

		return $template;
	}

	add_action( 'elementor/section/print_template', 'sahel_core_render_section_background_option_admin', 10, 2 );
}
