<?php
class ElementorInteractiveLinkShowcase extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_interactive_link_showcase'; 
	}

	public function get_title() {
		return esc_html__( 'Interactive Link Showcase', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-interactive-link-showcase';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'skin',
			[
				'label'     => esc_html__( 'Link Skin', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'light' => esc_html__( 'Light', 'sahel-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'background_color',
			[
				'label'     => esc_html__( 'Background Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'link_target',
			[
				'label'     => esc_html__( 'Link Target', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Same Window', 'sahel-core'), 
					'_blank' => esc_html__( 'New Window', 'sahel-core')
				),
				'default' => '_self'
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'subtitle',
			[
				'label'     => esc_html__( 'Subtitle', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'link',
			[
				'label'     => esc_html__( 'Link', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'image',
			[
				'label'     => esc_html__( 'Image', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Select image from media library', 'sahel-core' )
			]
		);

		$this->add_control(
			'link_items',
			[
				'label'     => esc_html__( 'Link Items', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'sahel-core' )
			]
		);

		$this->add_control(
			'title_font_size',
			[
				'label'     => esc_html__( 'Title Font Size (px)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		
		$params['holder_classes']      = $this->getHolderClasses( $params );
		$params['image_holder_styles'] = $this->getImageHolderStyles( $params );
		$params['link_target']         = ! empty( $params['link_target'] ) ? $params['link_target'] : '_self';
        $params['interactive_title_styles'] = $this->getInteractiveTitleStyles( $params );

		for ($i = 0; $i <= count($params['link_items']); $i++){
			if ( ! empty($params['link_items'][$i]['image'])) {

				$params['link_items'][$i]['image'] = $params['link_items'][$i]['image']['id'];
			}
		}

		echo sahel_core_get_shortcode_module_template_part( 'templates/interactive-link-showcase', 'interactive-link-showcase', '', $params );

	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['skin'] ) ? 'eltdf-ils-skin-' . $params['skin'] : '';
		
		return implode( ' ', $holderClasses );
	}

	private function getImageHolderStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['background_color'] ) ) {
			$styles[] = 'background-color: ' . $params['background_color'];
		}

		return implode( ';', $styles );
	}

    private function getInteractiveTitleStyles( $params ) {
        $styles = array();

        if ( ! empty( $params['title_font_size'] ) ) {
            $styles[] = 'font-size: ' . sahel_elated_filter_px( $params['title_font_size'] ) . 'px';
        }

        if ( ! empty( $params['title_color'] ) ) {
            $styles[] = 'color: ' . $params['title_color'];
        }

        return implode( ';', $styles );
    }

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorInteractiveLinkShowcase() );