(function($) {
	'use strict';
	
	var imageHighlight = {};
	eltdf.modules.imageHighlight = imageHighlight;
	
	imageHighlight.eltdfIHAppear = eltdfIHAppear;
	imageHighlight.eltdfOnDocumentReady = eltdfOnDocumentReady;
	
	$(document).ready(eltdfOnDocumentReady);
	$(window).on('load', eltdfOnWindowLoad);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function eltdfOnDocumentReady() {
		eltdfIHAppear();
	}

	/**
	 All functions to be called on $(document).ready() should be in this function
	 */
	function eltdfOnWindowLoad() {
		eltdfElementorImageHighlight();
	}

	/**
	 * Elementor
	 */
	function eltdfElementorImageHighlight() {
		$(window).on('elementor/frontend/init', function () {
			elementorFrontend.hooks.addAction('frontend/element_ready/eltdf_image_highlight.default', function () {
				eltdfIHAppear();
			});
		});
	}
    
    /**
     * Loading animation
     */
	function eltdfIHAppear() {
        var ihs = $('.eltdf-ih-with-animation');

        (ihs.length && !eltdf.htmlEl.hasClass('touchevents')) && ihs.appear(function(){$(this).addClass('eltdf-appeared')});
	};
	
})(jQuery);