<?php
class ElementorFullScreenSections extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_full_screen_sections'; 
	}

	public function get_title() {
		return esc_html__( 'Full Screen Sections', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-full-screen-sections';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'enable_continuous_vertical',
			[
				'label'     => esc_html__( 'Enable Continuous Scrolling', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Defines whether scrolling down in the last section or should scroll down to the first one and if scrolling up in the first section should scroll up to the last one', 'sahel-core' ),
				'options' => array(
					'no' => esc_html__( 'No', 'sahel-core'),
					'yes' => esc_html__( 'Yes', 'sahel-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'enable_navigation',
			[
				'label'     => esc_html__( 'Enable Navigation Arrows', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'),
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'enable_pagination',
			[
				'label'     => esc_html__( 'Enable Pagination Dots', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'),
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'custom_class',
			[
				'label'     => esc_html__( 'Custom CSS Class', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'sahel-core' )
			]
		);

		$repeater->add_control(
			'background_color',
			[
				'label'     => esc_html__( 'Background Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$repeater->add_control(
			'background_image',
			[
				'label'     => esc_html__( 'Background Image', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'background_position',
			[
				'label'     => esc_html__( 'Background Image Position', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Please insert position in format horizontal vertical position, example - center center', 'sahel-core' ),
//				'condition' => [
//					'background_image !' => ''
//				]
			]
		);

		$repeater->add_control(
			'background_size',
			[
				'label'     => esc_html__( 'Background Image Size', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'cover' => esc_html__( 'Cover', 'sahel-core'),
					'contain' => esc_html__( 'Contain', 'sahel-core'),
					'inherit' => esc_html__( 'Inherit', 'sahel-core')
				),
				'default' => 'cover',
//				'condition' => [
//					'background_image !' => ''
//				]
			]
		);

		$repeater->add_control(
			'text',
			[
				'label'       => esc_html__( 'Text', 'sahel-core' ),
				'type'        => \Elementor\Controls_Manager::WYSIWYG,
			]
		);

		sahel_core_generate_elementor_templates_control( $repeater );

		$repeater->add_control(
			'padding',
			[
				'label'     => esc_html__( 'Content Padding', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Please insert padding in format top right bottom left. You can use px or %', 'sahel-core' )
			]
		);

		$repeater->add_control(
			'vertical_alignment',
			[
				'label'     => esc_html__( 'Content Vertical Alignment', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'),
					'top' => esc_html__( 'Top', 'sahel-core'),
					'middle' => esc_html__( 'Middle', 'sahel-core'),
					'bottom' => esc_html__( 'Bottom', 'sahel-core')
				),
				'default' => ''
			]
		);

		$repeater->add_control(
			'horizontal_alignment',
			[
				'label'     => esc_html__( 'Content Horizontal Alignment', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'),
					'left' => esc_html__( 'Left', 'sahel-core'),
					'center' => esc_html__( 'Center', 'sahel-core'),
					'right' => esc_html__( 'Right', 'sahel-core')
				),
				'default' => ''
			]
		);

		$repeater->add_control(
			'link',
			[
				'label'     => esc_html__( 'Link', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Set custom link around item', 'sahel-core' )
			]
		);

		$repeater->add_control(
			'link_target',
			[
				'label'     => esc_html__( 'Custom Link Target', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Same Window', 'sahel-core'),
					'_blank' => esc_html__( 'New Window', 'sahel-core')
				),
				'default' => '_self',
				'condition' => [
					'link!' => ''
				]
			]
		);

		$repeater->add_control(
			'header_skin',
			[
				'label'     => esc_html__( 'Header and Navigation Skin', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Choose a predefined header style for header elements and for full screen sections navigation/pagination', 'sahel-core' ),
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'),
					'light' => esc_html__( 'Light', 'sahel-core'),
					'dark' => esc_html__( 'Dark', 'sahel-core')
				),
				'default' => ''
			]
		);

		$repeater->add_control(
			'image_laptop',
			[
				'label'     => esc_html__( 'Background Image for Laptops', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'image_tablet',
			[
				'label'     => esc_html__( 'Background Image for Tablets - Landscape', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'image_tablet_portrait',
			[
				'label'     => esc_html__( 'Background Image for Tablets - Portrait', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'image_mobile',
			[
				'label'     => esc_html__( 'Background Image for Mobiles', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$this->add_control(
			'full_screen_sections_item',
			[
				'label'     => esc_html__( 'Full Screen Sections Item', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'sahel-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['holder_data']    = $this->getHolderData( $params );

		foreach ($params['full_screen_sections_item'] as $key => $item) {

			$bg_img = $params['full_screen_sections_item'][$key]['background_image'];
			$params['full_screen_sections_item'][$key]['background_image'] = !empty($bg_img) ? $bg_img['id'] : $bg_img;

			$img_laptop = $params['full_screen_sections_item'][$key]['image_laptop'];
			$params['full_screen_sections_item'][$key]['image_laptop'] = !empty($img_laptop) ? $img_laptop['id'] : $img_laptop;

			$img_tablet = $params['full_screen_sections_item'][$key]['image_tablet'];
			$params['full_screen_sections_item'][$key]['image_tablet'] = !empty($img_tablet) ? $img_tablet['id'] : $img_tablet;

			$img_tablet_portrait = $params['full_screen_sections_item'][$key]['image_tablet_portrait'];
			$params['full_screen_sections_item'][$key]['image_tablet_portrait'] = !empty($img_tablet_portrait) ? $img_tablet_portrait['id'] : $img_tablet_portrait;

			$img_mobile = $params['full_screen_sections_item'][$key]['image_mobile'];
			$params['full_screen_sections_item'][$key]['image_mobile'] = !empty($img_mobile) ? $img_mobile['id'] : $img_mobile;

		}

		?>
		<div class="eltdf-full-screen-sections <?php echo esc_attr( $params['holder_classes'] ); ?>" <?php echo sahel_elated_get_inline_attrs( $params['holder_data'] ); ?>>
			<div class="eltdf-fss-wrapper">

				<?php foreach ($params['full_screen_sections_item'] as $item) {

					$rand_class = 'eltdf-fss-custom-' . mt_rand(100000,1000000);


					$item['template_id'] = ! empty( $item['template_id'] ) ? $item['template_id'] : '';

					$item_template = Elementor\Plugin::instance()->frontend->get_builder_content_for_display($item['template_id']);

					if( !empty($item_template) ) {
						$item['content'] = $item_template;

					} else {
						$item['content'] = $item['text'];
					}

					$item['holder_unique_class'] = $rand_class;
				    $item['holder_classes'] 	 = $this->getItemClasses( $item );
					$item['holder_data']         = $this->getItemData( $item );
					$item['holder_styles']       = $this->getItemStyles( $item );
					$item['item_inner_styles']   = $this->getItemInnerStyles( $item );
					$item['link_target']         = !empty($item['link_target']) ? $item['link_target'] : '_self';

					echo sahel_core_get_shortcode_module_template_part('templates/full-screen-sections-item', 'full-screen-sections', '', $item);
				}?>

			</div>
			<?php if ( $params['enable_navigation'] === 'yes' ) { ?>
				<div class="eltdf-fss-nav-holder">
					<a id="eltdf-fss-nav-up" href="#"><span class='icon-arrows-up'></span></a>
					<a id="eltdf-fss-nav-down" href="#"><span class='icon-arrows-down'></span></a>
				</div>
			<?php } ?>
		</div>

		<?php
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = $params['enable_navigation'] === 'yes' ? 'eltdf-fss-has-nav' : '';
		
		return implode( ' ', $holderClasses );
	}

	private function getHolderData( $params ) {
		$data = array();
		
		if ( ! empty( $params['enable_continuous_vertical'] ) ) {
			$data['data-enable-continuous-vertical'] = $params['enable_continuous_vertical'];
		}

		if ( ! empty( $params['enable_navigation'] ) ) {
			$data['data-enable-navigation'] = $params['enable_navigation'];
		}

		if ( ! empty( $params['enable_pagination'] ) ) {
			$data['data-enable-pagination'] = $params['enable_pagination'];
		}
		
		return $data;
	}


	private function getItemClasses( $params ) {
		$holderClasses = array();

		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['holder_unique_class'] ) ? $params['holder_unique_class'] : '';
		$holderClasses[] = ! empty( $params['vertical_alignment'] ) ? 'eltdf-fss-item-va-' . $params['vertical_alignment'] : '';
		$holderClasses[] = ! empty( $params['horizontal_alignment'] ) ? 'eltdf-fss-item-ha-' . $params['horizontal_alignment'] : '';
		$holderClasses[] = ! empty( $params['link'] ) ? 'eltdf-fss-item-has-link' : '';
		$holderClasses[] = ! empty( $params['header_skin'] ) ? 'eltdf-fss-item-has-style' : '';

		return implode( ' ', $holderClasses );
	}

	private function getItemData( $params ) {
		$data                    = array();
		$data['data-item-class'] = $params['holder_unique_class'];

		if ( ! empty( $params['header_skin'] ) ) {
			$data['data-header-style'] = $params['header_skin'];
		}

		if ( ! empty( $params['image_laptop'] ) ) {
			$image                     = wp_get_attachment_image_src( $params['image_laptop'], 'full' );
			$data['data-laptop-image'] = $image[0];
		}

		if ( ! empty( $params['image_tablet'] ) ) {
			$image                     = wp_get_attachment_image_src( $params['image_tablet'], 'full' );
			$data['data-tablet-image'] = $image[0];
		}

		if ( ! empty( $params['image_tablet_portrait'] ) ) {
			$image                              = wp_get_attachment_image_src( $params['image_tablet_portrait'], 'full' );
			$data['data-tablet-portrait-image'] = $image[0];

			var_dump($params['image_tablet_portrait']);
		}

		if ( ! empty( $params['image_mobile'] ) ) {
			$image                     = wp_get_attachment_image_src( $params['image_mobile'], 'full' );
			$data['data-mobile-image'] = $image[0];
		}

		return $data;
	}

	private function getItemStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['background_color'] ) ) {
			$styles[] = 'background-color: ' . $params['background_color'];
		}

		if ( ! empty( $params['background_image'] ) ) {
			$styles[] = 'background-image: url(' . wp_get_attachment_url( $params['background_image'] ) . ')';

			if ( ! empty( $params['background_position'] ) ) {
				$styles[] = 'background-position:' . $params['background_position'];
			}

			if ( ! empty( $params['background_size'] ) ) {
				$styles[] = 'background-size:' . $params['background_size'];
			}
		}

		return implode( ';', $styles );
	}

	private function getItemInnerStyles( $params ) {
		$styles = array();

		if ( $params['padding'] !== '' ) {
			$styles[] = 'padding: ' . $params['padding'];
		}

		return implode( ';', $styles );
	}



}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorFullScreenSections() );