<?php
class ElementorExpandingCarousel extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_expanding_carousel'; 
	}

	public function get_title() {
		return esc_html__( 'Expanding Carousel', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-expanding-carousel';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'item_image',
			[
				'label'     => esc_html__( 'Item Image', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'item_title',
			[
				'label'     => esc_html__( 'Item Title', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'item_title_color',
			[
				'label'     => esc_html__( 'Item Title Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$repeater->add_control(
			'item_link',
			[
				'label'     => esc_html__( 'Item Link', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'carousel_items',
			[
				'label'     => esc_html__( 'Carousel Items', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'sahel-core' )
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_and_behavior',
			[
				'label' => esc_html__( 'Layout and Behavior', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'carousel_size',
			[
				'label'     => esc_html__( 'Carousel Size', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'fullscreen' => esc_html__( 'Fullscreen', 'sahel-core'), 
					'landscape' => esc_html__( 'Landscape', 'sahel-core'), 
					'square' => esc_html__( 'Square', 'sahel-core')
				),
				'default' => 'fullscreen'
			]
		);

		$this->add_control(
			'change_slides_on_scroll',
			[
				'label'     => esc_html__( 'Change Slides On Scroll', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'), 
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'items_link_target',
			[
				'label'     => esc_html__( 'Items Link Target', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Same Window', 'sahel-core'), 
					'_blank' => esc_html__( 'New Window', 'sahel-core')
				),
				'default' => '_self'
			]
		);

		$this->add_control(
			'enable_border',
			[
				'label'     => esc_html__( 'Enable Border', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'), 
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'enable_navigation',
			[
				'label'     => esc_html__( 'Enable Navigation', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'), 
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'navigation_left_offset',
			[
				'label'     => esc_html__( 'Navigation Left Offset (px/%)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'enable_navigation' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'navigation_bottom_offset',
			[
				'label'     => esc_html__( 'Navigation Bottom Offset (px/%)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'If this option set, navigation will not follow border', 'sahel-core' ),
				'condition' => [
					'enable_navigation' => array( 'yes' )
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();


		foreach ($params['carousel_items'] as $key => $item ) {
			$img_id = $params['carousel_items'][$key]['item_image'];
			$params['carousel_items'][$key]['item_image'] = !empty($img_id) ? $img_id['id'] : $img_id;
		}

		$params['holder_classes'] = $this->getHolderClasses($params);
        $params['nav_style'] = $this->getNavStyle($params);

		echo sahel_core_get_shortcode_module_template_part('templates/expanding-carousel-template', 'expanding-carousel', '', $params);
	}

	private function getHolderClasses($params){
		$holderClasses = array();

		$holderClasses[] = 'eltdf-expanding-carousel-holder';

		if ($params['carousel_size'] !== '') {
			$holderClasses[] = 'eltdf-expanding-'.$params['carousel_size'];
		}

		if ($params['change_slides_on_scroll'] == 'yes') {
			$holderClasses[] = 'eltdf-esc-slide-on-scroll';
		}

		if (($params['enable_border']) == 'yes') {
			$holderClasses[] = 'eltdf-esc-with-border';
		}

		if (($params['enable_navigation']) == 'yes') {
			$holderClasses[] = 'eltdf-esc-with-nav';
		}

		return implode(' ', $holderClasses);
	}

	private function getNavStyle($params) {
		$style = array();

		if ($params['navigation_left_offset'] !== '') {
			$style[] = 'left: '.$params['navigation_left_offset'];
		}

		if ($params['navigation_bottom_offset'] !== '') {
			$style[] = 'bottom: '.$params['navigation_bottom_offset'];
		}

		return implode(';', $style);
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorExpandingCarousel() );