<?php
class ElementorCountdown extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_countdown'; 
	}

	public function get_title() {
		return esc_html__( 'Countdown', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-countdown';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_class',
			[
				'label'     => esc_html__( 'Custom CSS Class', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'sahel-core' )
			]
		);

		$this->add_control(
			'skin',
			[
				'label'     => esc_html__( 'Skin', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'eltdf-light-skin' => esc_html__( 'Light', 'sahel-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'year',
			[
				'label'     => esc_html__( 'Year', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'2018' => esc_html__( '2018', 'sahel-core'), 
					'2019' => esc_html__( '2019', 'sahel-core'), 
					'2020' => esc_html__( '2020', 'sahel-core'), 
					'2021' => esc_html__( '2021', 'sahel-core'), 
					'2022' => esc_html__( '2022', 'sahel-core'),
					'2023' => esc_html__( '2023', 'sahel-core'),
					'2024' => esc_html__( '2024', 'sahel-core'),
					'2025' => esc_html__( '2025', 'sahel-core')
				),
				'default' => '2018'
			]
		);

		$this->add_control(
			'month',
			[
				'label'     => esc_html__( 'Month', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( 'January', 'sahel-core'), 
					'2' => esc_html__( 'February', 'sahel-core'), 
					'3' => esc_html__( 'March', 'sahel-core'), 
					'4' => esc_html__( 'April', 'sahel-core'), 
					'5' => esc_html__( 'May', 'sahel-core'), 
					'6' => esc_html__( 'June', 'sahel-core'), 
					'7' => esc_html__( 'July', 'sahel-core'), 
					'8' => esc_html__( 'August', 'sahel-core'), 
					'9' => esc_html__( 'September', 'sahel-core'), 
					'10' => esc_html__( 'October', 'sahel-core'), 
					'11' => esc_html__( 'November', 'sahel-core'), 
					'12' => esc_html__( 'December', 'sahel-core')
				),
				'default' => '1'
			]
		);

		$this->add_control(
			'day',
			[
				'label'     => esc_html__( 'Day', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( '1', 'sahel-core'), 
					'2' => esc_html__( '2', 'sahel-core'), 
					'3' => esc_html__( '3', 'sahel-core'), 
					'4' => esc_html__( '4', 'sahel-core'), 
					'5' => esc_html__( '5', 'sahel-core'), 
					'6' => esc_html__( '6', 'sahel-core'), 
					'7' => esc_html__( '7', 'sahel-core'), 
					'8' => esc_html__( '8', 'sahel-core'), 
					'9' => esc_html__( '9', 'sahel-core'), 
					'10' => esc_html__( '10', 'sahel-core'), 
					'11' => esc_html__( '11', 'sahel-core'), 
					'12' => esc_html__( '12', 'sahel-core'), 
					'13' => esc_html__( '13', 'sahel-core'), 
					'14' => esc_html__( '14', 'sahel-core'), 
					'15' => esc_html__( '15', 'sahel-core'), 
					'16' => esc_html__( '16', 'sahel-core'), 
					'17' => esc_html__( '17', 'sahel-core'), 
					'18' => esc_html__( '18', 'sahel-core'), 
					'19' => esc_html__( '19', 'sahel-core'), 
					'20' => esc_html__( '20', 'sahel-core'), 
					'21' => esc_html__( '21', 'sahel-core'), 
					'22' => esc_html__( '22', 'sahel-core'), 
					'23' => esc_html__( '23', 'sahel-core'), 
					'24' => esc_html__( '24', 'sahel-core'), 
					'25' => esc_html__( '25', 'sahel-core'), 
					'26' => esc_html__( '26', 'sahel-core'), 
					'27' => esc_html__( '27', 'sahel-core'), 
					'28' => esc_html__( '28', 'sahel-core'), 
					'29' => esc_html__( '29', 'sahel-core'), 
					'30' => esc_html__( '30', 'sahel-core'), 
					'31' => esc_html__( '31', 'sahel-core')
				),
				'default' => '1'
			]
		);

		$this->add_control(
			'hour',
			[
				'label'     => esc_html__( 'Hour', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'0' => esc_html__( '0', 'sahel-core'), 
					'1' => esc_html__( '1', 'sahel-core'), 
					'2' => esc_html__( '2', 'sahel-core'), 
					'3' => esc_html__( '3', 'sahel-core'), 
					'4' => esc_html__( '4', 'sahel-core'), 
					'5' => esc_html__( '5', 'sahel-core'), 
					'6' => esc_html__( '6', 'sahel-core'), 
					'7' => esc_html__( '7', 'sahel-core'), 
					'8' => esc_html__( '8', 'sahel-core'), 
					'9' => esc_html__( '9', 'sahel-core'), 
					'10' => esc_html__( '10', 'sahel-core'), 
					'11' => esc_html__( '11', 'sahel-core'), 
					'12' => esc_html__( '12', 'sahel-core'), 
					'13' => esc_html__( '13', 'sahel-core'), 
					'14' => esc_html__( '14', 'sahel-core'), 
					'15' => esc_html__( '15', 'sahel-core'), 
					'16' => esc_html__( '16', 'sahel-core'), 
					'17' => esc_html__( '17', 'sahel-core'), 
					'18' => esc_html__( '18', 'sahel-core'), 
					'19' => esc_html__( '19', 'sahel-core'), 
					'20' => esc_html__( '20', 'sahel-core'), 
					'21' => esc_html__( '21', 'sahel-core'), 
					'22' => esc_html__( '22', 'sahel-core'), 
					'23' => esc_html__( '23', 'sahel-core'), 
					'24' => esc_html__( '24', 'sahel-core')
				),
				'default' => '0'
			]
		);

		$this->add_control(
			'minute',
			[
				'label'     => esc_html__( 'Minute', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'0' => esc_html__( '0', 'sahel-core'), 
					'1' => esc_html__( '1', 'sahel-core'), 
					'2' => esc_html__( '2', 'sahel-core'), 
					'3' => esc_html__( '3', 'sahel-core'), 
					'4' => esc_html__( '4', 'sahel-core'), 
					'5' => esc_html__( '5', 'sahel-core'), 
					'6' => esc_html__( '6', 'sahel-core'), 
					'7' => esc_html__( '7', 'sahel-core'), 
					'8' => esc_html__( '8', 'sahel-core'), 
					'9' => esc_html__( '9', 'sahel-core'), 
					'10' => esc_html__( '10', 'sahel-core'), 
					'11' => esc_html__( '11', 'sahel-core'), 
					'12' => esc_html__( '12', 'sahel-core'), 
					'13' => esc_html__( '13', 'sahel-core'), 
					'14' => esc_html__( '14', 'sahel-core'), 
					'15' => esc_html__( '15', 'sahel-core'), 
					'16' => esc_html__( '16', 'sahel-core'), 
					'17' => esc_html__( '17', 'sahel-core'), 
					'18' => esc_html__( '18', 'sahel-core'), 
					'19' => esc_html__( '19', 'sahel-core'), 
					'20' => esc_html__( '20', 'sahel-core'), 
					'21' => esc_html__( '21', 'sahel-core'), 
					'22' => esc_html__( '22', 'sahel-core'), 
					'23' => esc_html__( '23', 'sahel-core'), 
					'24' => esc_html__( '24', 'sahel-core'), 
					'25' => esc_html__( '25', 'sahel-core'), 
					'26' => esc_html__( '26', 'sahel-core'), 
					'27' => esc_html__( '27', 'sahel-core'), 
					'28' => esc_html__( '28', 'sahel-core'), 
					'29' => esc_html__( '29', 'sahel-core'), 
					'30' => esc_html__( '30', 'sahel-core'), 
					'31' => esc_html__( '31', 'sahel-core'), 
					'32' => esc_html__( '32', 'sahel-core'), 
					'33' => esc_html__( '33', 'sahel-core'), 
					'34' => esc_html__( '34', 'sahel-core'), 
					'35' => esc_html__( '35', 'sahel-core'), 
					'36' => esc_html__( '36', 'sahel-core'), 
					'37' => esc_html__( '37', 'sahel-core'), 
					'38' => esc_html__( '38', 'sahel-core'), 
					'39' => esc_html__( '39', 'sahel-core'), 
					'40' => esc_html__( '40', 'sahel-core'), 
					'41' => esc_html__( '41', 'sahel-core'), 
					'42' => esc_html__( '42', 'sahel-core'), 
					'43' => esc_html__( '43', 'sahel-core'), 
					'44' => esc_html__( '44', 'sahel-core'), 
					'45' => esc_html__( '45', 'sahel-core'), 
					'46' => esc_html__( '46', 'sahel-core'), 
					'47' => esc_html__( '47', 'sahel-core'), 
					'48' => esc_html__( '48', 'sahel-core'), 
					'49' => esc_html__( '49', 'sahel-core'), 
					'50' => esc_html__( '50', 'sahel-core'), 
					'51' => esc_html__( '51', 'sahel-core'), 
					'52' => esc_html__( '52', 'sahel-core'), 
					'53' => esc_html__( '53', 'sahel-core'), 
					'54' => esc_html__( '54', 'sahel-core'), 
					'55' => esc_html__( '55', 'sahel-core'), 
					'56' => esc_html__( '56', 'sahel-core'), 
					'57' => esc_html__( '57', 'sahel-core'), 
					'58' => esc_html__( '58', 'sahel-core'), 
					'59' => esc_html__( '59', 'sahel-core'), 
					'60' => esc_html__( '60', 'sahel-core')
				),
				'default' => '0'
			]
		);

		$this->add_control(
			'month_label',
			[
				'label'     => esc_html__( 'Month Label', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'day_label',
			[
				'label'     => esc_html__( 'Day Label', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'hour_label',
			[
				'label'     => esc_html__( 'Hour Label', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'minute_label',
			[
				'label'     => esc_html__( 'Minute Label', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'second_label',
			[
				'label'     => esc_html__( 'Second Label', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'digit_font_size',
			[
				'label'     => esc_html__( 'Digit Font Size (px)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'label_font_size',
			[
				'label'     => esc_html__( 'Label Font Size (px)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();


		
		$params['id']             = mt_rand( 1000, 9999 );
		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['holder_data']    = $this->getHolderData( $params );
		
		echo sahel_core_get_shortcode_module_template_part( 'templates/countdown', 'countdown', '', $params );
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['skin'] ) ? $params['skin'] : '';
		
		return implode( ' ', $holderClasses );
	}

	private function getHolderData( $params ) {
		$holderData = array();
		
		$holderData['data-year']         = ! empty( $params['year'] ) ? $params['year'] : '';
		$holderData['data-month']        = ! empty( $params['month'] ) ? $params['month'] : '';
		$holderData['data-day']          = ! empty( $params['day'] ) ? $params['day'] : '';
		$holderData['data-hour']         = $params['hour'] !== '' ? $params['hour'] : '';
		$holderData['data-minute']       = $params['minute'] !== '' ? $params['minute'] : '';
		$holderData['data-month-label']  = ! empty( $params['month_label'] ) ? $params['month_label'] : esc_html__( 'Months', 'sahel-core' );
		$holderData['data-day-label']    = ! empty( $params['day_label'] ) ? $params['day_label'] : esc_html__( 'Days', 'sahel-core' );
		$holderData['data-hour-label']   = ! empty( $params['hour_label'] ) ? $params['hour_label'] : esc_html__( 'Hours', 'sahel-core' );
		$holderData['data-minute-label'] = ! empty( $params['minute_label'] ) ? $params['minute_label'] : esc_html__( 'Minutes', 'sahel-core' );
		$holderData['data-second-label'] = ! empty( $params['second_label'] ) ? $params['second_label'] : esc_html__( 'Seconds', 'sahel-core' );
		$holderData['data-digit-size']   = ! empty( $params['digit_font_size'] ) ? $params['digit_font_size'] : '';
		$holderData['data-label-size']   = ! empty( $params['label_font_size'] ) ? $params['label_font_size'] : '';
		
		return $holderData;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorCountdown() );