<?php
class ElementorClientsGrid extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_clients_grid'; 
	}

	public function get_title() {
		return esc_html__( 'Clients Grid', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-clients-grid';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number_of_columns',
			[
				'label'     => esc_html__( 'Number of Columns', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'one' => esc_html__( 'One', 'sahel-core'), 
					'two' => esc_html__( 'Two', 'sahel-core'), 
					'three' => esc_html__( 'Three', 'sahel-core'), 
					'four' => esc_html__( 'Four', 'sahel-core'), 
					'five' => esc_html__( 'Five', 'sahel-core'), 
					'six' => esc_html__( 'Six', 'sahel-core')
				),
				'default' => 'three'
			]
		);

		$this->add_control(
			'space_between_items',
			[
				'label'     => esc_html__( 'Space Between Items', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'huge' => esc_html__( 'Huge (80)', 'sahel-core'), 
					'large' => esc_html__( 'Large (40)', 'sahel-core'), 
					'medium' => esc_html__( 'Medium (20)', 'sahel-core'), 
					'normal' => esc_html__( 'Normal (15)', 'sahel-core'), 
					'small' => esc_html__( 'Small (10)', 'sahel-core'), 
					'tiny' => esc_html__( 'Tiny (5)', 'sahel-core'), 
					'no' => esc_html__( 'No (0)', 'sahel-core')
				),
				'default' => 'normal'
			]
		);

		$this->add_control(
			'image_alignment',
			[
				'label'     => esc_html__( 'Items Horizontal Alignment', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default Center', 'sahel-core'), 
					'left' => esc_html__( 'Left', 'sahel-core'), 
					'right' => esc_html__( 'Right', 'sahel-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'items_hover_animation',
			[
				'label'     => esc_html__( 'Items Hover Animation', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'switch-images' => esc_html__( 'Switch Images', 'sahel-core'), 
					'roll-over' => esc_html__( 'Roll Over', 'sahel-core')
				),
				'default' => 'switch-images'
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image',
			[
				'label'     => esc_html__( 'Image', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Select image from media library', 'sahel-core' )
			]
		);

		$repeater->add_control(
			'hover_image',
			[
				'label'     => esc_html__( 'Hover Image', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Select image from media library', 'sahel-core' )
			]
		);

		$repeater->add_control(
			'image_size',
			[
				'label'     => esc_html__( 'Image Size', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use &quot;thumbnail&quot; size', 'sahel-core' )
			]
		);

		$repeater->add_control(
			'link',
			[
				'label'     => esc_html__( 'Custom Link', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'target',
			[
				'label'     => esc_html__( 'Custom Link Target', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Same Window', 'sahel-core'), 
					'_blank' => esc_html__( 'New Window', 'sahel-core')
				),
				'default' => '_self'
			]
		);

		$this->add_control(
			'clients_carousel_item',
			[
				'label'     => esc_html__( 'Clients Item', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'sahel-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['holder_classes'] = $this->getHolderClasses( $params );
		?>
		<div class="eltdf-clients-grid-holder eltdf-grid-list eltdf-disable-bottom-space <?php echo esc_attr( $params['holder_classes'] ); ?>">
			<div class="eltdf-cg-inner eltdf-outer-space">
				<?php foreach ( $params['clients_carousel_item'] as $client ) {

					$client['holder_classes']   = $this->getItemHolderClasses( $client );
					$client['image']            = $this->getItemCarouselImage( $client );
					$client['hover_image']      = $this->getItemCarouselHoverImage( $client );

					echo sahel_core_get_shortcode_module_template_part( 'templates/clients-carousel-item', 'clients-carousel', '', $client );
				} ?>
			</div>
		</div>
		<?php
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['number_of_columns'] ) ? 'eltdf-' . $params['number_of_columns'] . '-columns' : 'eltdf-three-columns';
		$holderClasses[] = ! empty( $params['space_between_items'] ) ? 'eltdf-' . $params['space_between_items'] . '-space' : 'eltdf-normal-space';
		$holderClasses[] = ! empty( $params['image_alignment'] ) ? 'eltdf-cg-alignment-' . $params['image_alignment'] : '';
		$holderClasses[] = ! empty( $params['items_hover_animation'] ) ? 'eltdf-cc-hover-' . $params['items_hover_animation'] : 'eltdf-cc-hover-switch-images';
		
		return implode( ' ', $holderClasses );
	}

	private function getItemHolderClasses( $params ) {
		$holderClasses = array();

		$holderClasses[] = ! empty( $params['link'] ) ? 'eltdf-cci-has-link' : 'eltdf-cci-no-link';

		return implode( ' ', $holderClasses );
	}

	private function getItemCarouselImage( $params ) {
		$image_meta = array();

		if ( ! empty( $params['image'] ) ) {
			$image_size  = $this->getItemCarouselImageSize( $params['image_size'] );
			$image_id       = $params['image']['id'];
			$image_original = wp_get_attachment_image_src( $image_id, $image_size );
			$image['url']   = $image_original[0];
			$image['alt']   = get_post_meta( $image_id, '_wp_attachment_image_alt', true );

			$image_meta = $image;
		}

		return $image_meta;
	}

	private function getItemCarouselHoverImage( $params ) {
		$image_meta = array();

		if ( ! empty( $params['hover_image'] ) ) {
			$image_size  = $this->getItemCarouselImageSize( $params['image_size'] );
			$image_id       = $params['hover_image']['id'];
			$image_original = wp_get_attachment_image_src( $image_id, $image_size );
			$image['url']   = $image_original[0];
			$image['alt']   = get_post_meta( $image_id, '_wp_attachment_image_alt', true );

			$image_meta = $image;
		}

		return $image_meta;
	}

	private function getItemCarouselImageSize( $image_size ) {
		$image_size = trim( $image_size );

		//Find digits
		preg_match_all( '/\d+/', $image_size, $matches );

		if ( in_array( $image_size, array( 'thumbnail', 'thumb', 'medium', 'large', 'full' ) ) ) {
			return $image_size;
		} elseif ( ! empty( $matches[0] ) ) {
			return array(
				$matches[0][0],
				$matches[0][1]
			);
		} else {
			return 'full';
		}
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorClientsGrid() );