<?php
class ElementorPortfolioList extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_portfolio_list'; 
	}

	public function get_title() {
		return esc_html__( 'Portfolio List', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-portfolio-list';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Portfolio List Template', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'gallery' => esc_html__( 'Gallery', 'sahel-core'), 
					'masonry' => esc_html__( 'Masonry', 'sahel-core'), 
					'scattered' => esc_html__( 'Scattered', 'sahel-core')
				),
				'default' => 'gallery'
			]
		);

		$this->add_control(
			'scattered_offset',
			[
				'label'     => esc_html__( 'Scattered Offset', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'small' => esc_html__( 'Small', 'sahel-core'), 
					'normal' => esc_html__( 'Normal', 'sahel-core'), 
					'big' => esc_html__( 'Big', 'sahel-core')
				),
				'default' => 'normal',
				'condition' => [
					'type' => array( 'scattered' )
				]
			]
		);

		$this->add_control(
			'item_type',
			[
				'label'     => esc_html__( 'Click Behavior', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Open portfolio single page on click', 'sahel-core'), 
					'gallery' => esc_html__( 'Open gallery in Pretty Photo on click', 'sahel-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'number_of_columns',
			[
				'label'     => esc_html__( 'Number of Columns', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Default value is Three', 'sahel-core' ),
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'one' => esc_html__( 'One', 'sahel-core'), 
					'two' => esc_html__( 'Two', 'sahel-core'), 
					'three' => esc_html__( 'Three', 'sahel-core'), 
					'four' => esc_html__( 'Four', 'sahel-core'), 
					'five' => esc_html__( 'Five', 'sahel-core'), 
					'six' => esc_html__( 'Six', 'sahel-core')
				),
				'default' => 'three',
				'condition' => [
					'type' => array( 'gallery', 'masonry' )
				]
			]
		);

		$this->add_control(
			'space_between_items',
			[
				'label'     => esc_html__( 'Space Between Items', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'huge' => esc_html__( 'Huge (80)', 'sahel-core'), 
					'large' => esc_html__( 'Large (40)', 'sahel-core'), 
					'medium' => esc_html__( 'Medium (20)', 'sahel-core'), 
					'normal' => esc_html__( 'Normal (15)', 'sahel-core'), 
					'small' => esc_html__( 'Small (10)', 'sahel-core'), 
					'tiny' => esc_html__( 'Tiny (5)', 'sahel-core'), 
					'no' => esc_html__( 'No (0)', 'sahel-core')
				),
				'default' => 'normal'
			]
		);

		$this->add_control(
			'number_of_items',
			[
				'label'     => esc_html__( 'Number of Portfolios Per Page', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Set number of items for your portfolio list. Enter -1 to show all.', 'sahel-core' )
			]
		);

		$this->add_control(
			'image_proportions',
			[
				'label'     => esc_html__( 'Image Proportions', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Set image proportions for your portfolio list.', 'sahel-core' ),
				'options' => array(
					'full' => esc_html__( 'Original', 'sahel-core'), 
					'square' => esc_html__( 'Square', 'sahel-core'), 
					'landscape' => esc_html__( 'Landscape', 'sahel-core'), 
					'portrait' => esc_html__( 'Portrait', 'sahel-core'), 
					'medium' => esc_html__( 'Medium', 'sahel-core'), 
					'large' => esc_html__( 'Large', 'sahel-core')
				),
				'default' => 'full',
				'condition' => [
					'type' => array( 'gallery' )
				]
			]
		);

		$this->add_control(
			'enable_fixed_proportions',
			[
				'label'     => esc_html__( 'Enable Fixed Image Proportions', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Set predefined image proportions for your masonry portfolio list. This option will apply image proportions you set in Portfolio Single page - dimensions for masonry option.', 'sahel-core' ),
				'options' => array(
					'no' => esc_html__( 'No', 'sahel-core'), 
					'yes' => esc_html__( 'Yes', 'sahel-core')
				),
				'default' => 'no',
				'condition' => [
					'type' => array( 'masonry' )
				]
			]
		);

		$this->add_control(
			'enable_image_shadow',
			[
				'label'     => esc_html__( 'Enable Image Shadow', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'sahel-core'), 
					'yes' => esc_html__( 'Yes', 'sahel-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'category',
			[
				'label'     => esc_html__( 'One-Category Portfolio List', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter one category slug (leave empty for showing all categories)', 'sahel-core' )
			]
		);

		$this->add_control(
			'selected_projects',
			[
				'label'     => esc_html__( 'Show Only Projects with Listed IDs', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Delimit ID numbers by comma (leave empty for all)', 'sahel-core' )
			]
		);

		$this->add_control(
			'tag',
			[
				'label'     => esc_html__( 'One-Tag Portfolio List', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter one tag slug (leave empty for showing all tags)', 'sahel-core' )
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'date' => esc_html__( 'Date', 'sahel-core'), 
					'ID' => esc_html__( 'ID', 'sahel-core'), 
					'menu_order' => esc_html__( 'Menu Order', 'sahel-core'), 
					'name' => esc_html__( 'Post Name', 'sahel-core'), 
					'rand' => esc_html__( 'Random', 'sahel-core'), 
					'title' => esc_html__( 'Title', 'sahel-core')
				),
				'default' => 'date'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'ASC' => esc_html__( 'ASC', 'sahel-core'), 
					'DESC' => esc_html__( 'DESC', 'sahel-core')
				),
				'default' => 'ASC'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_layout',
			[
				'label' => esc_html__( 'Content Layout', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'item_style',
			[
				'label'     => esc_html__( 'Item Style', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'standard-blur' => esc_html__( 'Standard - Blur', 'sahel-core'), 
					'standard-shader' => esc_html__( 'Standard - Shader', 'sahel-core'), 
					'standard-switch-images' => esc_html__( 'Standard - Switch Featured Images', 'sahel-core'), 
					'gallery-overlay' => esc_html__( 'Gallery - Overlay', 'sahel-core'), 
					'gallery-slide-from-image-bottom' => esc_html__( 'Gallery - Slide From Image Bottom', 'sahel-core')
				),
				'default' => 'standard-blur'
			]
		);

		$this->add_control(
			'content_top_margin',
			[
				'label'     => esc_html__( 'Content Top Margin (px or %)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'item_style' => array( 'standard-blur', 'standard-shader', 'standard-switch-images' )
				]
			]
		);

		$this->add_control(
			'content_bottom_margin',
			[
				'label'     => esc_html__( 'Content Bottom Margin (px or %)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'item_style' => array( 'standard-blur', 'standard-shader', 'standard-switch-images' )
				]
			]
		);

		$this->add_control(
			'enable_title',
			[
				'label'     => esc_html__( 'Enable Title', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'), 
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'h1' => esc_html__( 'h1', 'sahel-core'), 
					'h2' => esc_html__( 'h2', 'sahel-core'), 
					'h3' => esc_html__( 'h3', 'sahel-core'), 
					'h4' => esc_html__( 'h4', 'sahel-core'), 
					'h5' => esc_html__( 'h5', 'sahel-core'), 
					'h6' => esc_html__( 'h6', 'sahel-core')
				),
				'default' => 'h3',
				'condition' => [
					'enable_title' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'title_text_transform',
			[
				'label'     => esc_html__( 'Title Text Transform', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'none' => esc_html__( 'None', 'sahel-core'), 
					'capitalize' => esc_html__( 'Capitalize', 'sahel-core'), 
					'uppercase' => esc_html__( 'Uppercase', 'sahel-core'), 
					'lowercase' => esc_html__( 'Lowercase', 'sahel-core'), 
					'initial' => esc_html__( 'Initial', 'sahel-core'), 
					'inherit' => esc_html__( 'Inherit', 'sahel-core')
				),
				'default' => '',
				'condition' => [
					'enable_title' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'enable_category',
			[
				'label'     => esc_html__( 'Enable Category', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'), 
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'enable_count_images',
			[
				'label'     => esc_html__( 'Enable Number of Images', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'), 
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes',
				'condition' => [
					'type' => array( 'gallery' )
				]
			]
		);

		$this->add_control(
			'enable_excerpt',
			[
				'label'     => esc_html__( 'Enable Excerpt', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'sahel-core'), 
					'yes' => esc_html__( 'Yes', 'sahel-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'excerpt_length',
			[
				'label'     => esc_html__( 'Excerpt Length', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Number of characters', 'sahel-core' ),
				'condition' => [
					'enable_excerpt' => array( 'yes' )
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'additional_features',
			[
				'label' => esc_html__( 'Additional Features', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'enable_list_title',
			[
				'label'     => esc_html__( 'Enable List Title Section', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'sahel-core'), 
					'yes' => esc_html__( 'Yes', 'sahel-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'list_title',
			[
				'label'     => esc_html__( 'List Title', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'enable_list_title' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'list_title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'h1' => esc_html__( 'h1', 'sahel-core'), 
					'h2' => esc_html__( 'h2', 'sahel-core'), 
					'h3' => esc_html__( 'h3', 'sahel-core'), 
					'h4' => esc_html__( 'h4', 'sahel-core'), 
					'h5' => esc_html__( 'h5', 'sahel-core'), 
					'h6' => esc_html__( 'h6', 'sahel-core')
				),
				'default' => 'h1',
				'condition' => [
					'list_title!' => ''
				]
			]
		);

		$this->add_control(
			'list_subtitle',
			[
				'label'     => esc_html__( 'List Subtitle', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'enable_list_title' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'list_text',
			[
				'label'     => esc_html__( 'List Text', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'enable_list_title' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'list_title_padding',
			[
				'label'     => esc_html__( 'List Title Padding', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter padding in form (0px 5px 5px 0px)', 'sahel-core' ),
				'condition' => [
					'enable_list_title' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'pagination_type',
			[
				'label'     => esc_html__( 'Pagination Type', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no-pagination' => esc_html__( 'None', 'sahel-core'), 
					'standard' => esc_html__( 'Standard', 'sahel-core'), 
					'load-more' => esc_html__( 'Load More', 'sahel-core'), 
					'infinite-scroll' => esc_html__( 'Infinite Scroll', 'sahel-core')
				),
				'default' => 'no-pagination'
			]
		);

		$this->add_control(
			'load_more_top_margin',
			[
				'label'     => esc_html__( 'Load More Top Margin (px or %)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'pagination_type' => array( 'load-more' )
				]
			]
		);

		$this->add_control(
			'filter',
			[
				'label'     => esc_html__( 'Enable Category Filter', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'sahel-core'), 
					'yes' => esc_html__( 'Yes', 'sahel-core')
				),
				'default' => 'no',
				'condition' => [
					'type' => array( 'gallery', 'masonry' )
				]
			]
		);

		$this->add_control(
			'filter_order_by',
			[
				'label'     => esc_html__( 'Filter Order By', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'name' => esc_html__( 'Name', 'sahel-core'), 
					'count' => esc_html__( 'Count', 'sahel-core'), 
					'id' => esc_html__( 'Id', 'sahel-core'), 
					'slug' => esc_html__( 'Slug', 'sahel-core')
				),
				'default' => 'name',
				'condition' => [
					'filter' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'filter_text_transform',
			[
				'label'     => esc_html__( 'Filter Text Transform', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'none' => esc_html__( 'None', 'sahel-core'), 
					'capitalize' => esc_html__( 'Capitalize', 'sahel-core'), 
					'uppercase' => esc_html__( 'Uppercase', 'sahel-core'), 
					'lowercase' => esc_html__( 'Lowercase', 'sahel-core'), 
					'initial' => esc_html__( 'Initial', 'sahel-core'), 
					'inherit' => esc_html__( 'Inherit', 'sahel-core')
				),
				'default' => '',
				'condition' => [
					'filter' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'filter_bottom_margin',
			[
				'label'     => esc_html__( 'Filter Bottom Margin (px or %)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'filter' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'additional_effects',
			[
				'label'     => esc_html__( 'Additional Effects', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'None', 'sahel-core'), 
					'article-loading-animation' => esc_html__( 'Article Loading Animation', 'sahel-core'), 
					'article-parallax-animation' => esc_html__( 'Article Parallax Animation', 'sahel-core')
				),
				'default' => ''
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$args = array(
			'type'                     => 'gallery',
			'item_type'                => '',
			'scattered_offset'		   => 'normal',
			'number_of_columns'        => 'three',
			'space_between_items'      => 'normal',
			'number_of_items'          => '-1',
			'image_proportions'        => 'full',
			'enable_fixed_proportions' => 'no',
			'enable_image_shadow'      => 'no',
			'category'                 => '',
			'selected_projects'        => '',
			'tag'                      => '',
			'orderby'                  => 'date',
			'order'                    => 'ASC',
			'item_style'               => 'standard-blur',
			'content_top_margin'       => '',
			'content_bottom_margin'    => '',
			'enable_title'             => 'yes',
			'title_tag'                => 'h3',
			'title_text_transform'     => '',
			'enable_category'          => 'yes',
			'enable_count_images'      => 'yes',
			'enable_excerpt'           => 'no',
			'excerpt_length'           => '20',
			'pagination_type'          => 'no-pagination',
			'load_more_top_margin'     => '',
			'filter'                   => 'no',
			'filter_order_by'          => 'name',
			'filter_text_transform'    => '',
			'filter_bottom_margin'     => '',
			'additional_effects' 	   => '',
			'portfolio_slider_on'      => 'no',
			'enable_loop'              => 'yes',
			'enable_autoplay'          => 'yes',
			'slider_speed'             => '5000',
			'slider_speed_animation'   => '600',
			'enable_navigation'        => 'yes',
			'navigation_skin'          => '',
			'enable_pagination'        => 'yes',
			'pagination_skin'          => '',
			'pagination_position'      => '',
			'enable_list_title'        => 'no',
			'list_title'		       => '',
			'list_title_tag'		   => 'h1',
			'list_subtitle'     	   => '',
			'list_text'			       => '',
			'list_title_padding'	   => ''
		);
		$params = shortcode_atts( $args, $this->get_settings_for_display() );


		
		/***
		 * @params query_results
		 * @params holder_data
		 * @params holder_classes
		 * @params holder_inner_classes
		 */
		$additional_params = array();
		
		$query_array                        = $this->getQueryArray( $params );
		$query_results                      = new \WP_Query( $query_array );
		$additional_params['query_results'] = $query_results;
		$params['scattered'] = 0;

		if ($params['type'] == 'scattered'){
			$params['scattered'] = 1;
			$params['type'] = 'masonry';
			$params['additional_class'] = 'eltdf-scattered-images';
			$params['number_of_columns'] = 'two';
		}

		$additional_params['holder_data']          = sahel_elated_get_holder_data_for_cpt( $params, $additional_params );
		$additional_params['holder_classes']       = $this->getHolderClasses( $params );
		$additional_params['holder_inner_classes'] = $this->getHolderInnerClasses( $params );

		$params['this_object'] = $this;
		$params['title_params_array'] = $this->getListTitleParams( $params );

		echo sahel_core_get_cpt_shortcode_module_template_part( 'portfolio', 'portfolio-list', 'portfolio-holder', $params['type'], $params, $additional_params );
	}

	public function getQueryArray( $params ) {
		$query_array = array(
			'post_status'    => 'publish',
			'post_type'      => 'portfolio-item',
			'posts_per_page' => $params['number_of_items'],
			'orderby'        => $params['orderby'],
			'order'          => $params['order']
		);
		
		if ( ! empty( $params['category'] ) ) {
			$query_array['portfolio-category'] = $params['category'];
		}
		
		$project_ids = null;
		if ( ! empty( $params['selected_projects'] ) ) {
			$project_ids             = explode( ',', $params['selected_projects'] );
			$query_array['post__in'] = $project_ids;
		}
		
		if ( ! empty( $params['tag'] ) ) {
			$query_array['portfolio-tag'] = $params['tag'];
		}
		
		if ( ! empty( $params['next_page'] ) ) {
			$query_array['paged'] = $params['next_page'];
		} else {
			$query_array['paged'] = 1;
		}
		
		return $query_array;
	}

	public function getHolderClasses( $params ) {
		$classes = array();
		
		$classes[] = ! empty( $params['type'] ) ? 'eltdf-pl-' . $params['type'] : 'eltdf-pl-gallery';
		$classes[] = ! empty( $params['number_of_columns'] ) ? 'eltdf-' . $params['number_of_columns'] . '-columns' : 'eltdf-three-columns';
		$classes[] = ! empty( $params['space_between_items'] ) ? 'eltdf-' . $params['space_between_items'] . '-space' : 'eltdf-normal-space';
		$classes[] = ! empty( $params['item_style'] ) ? 'eltdf-pl-' . $params['item_style'] : '';
		$classes[] = $params['enable_fixed_proportions'] === 'yes' ? 'eltdf-fixed-masonry-items' : '';
		$classes[] = $params['enable_image_shadow'] === 'yes' ? 'eltdf-pl-has-shadow' : '';
		$classes[] = $params['enable_title'] === 'no' && $params['enable_category'] === 'no' && $params['enable_excerpt'] === 'no' ? 'eltdf-pl-no-content' : '';
		$classes[] = ! empty( $params['pagination_type'] ) ? 'eltdf-pl-pag-' . $params['pagination_type'] : '';
		$classes[] = $params['filter'] === 'yes' ? 'eltdf-pl-has-filter' : '';
		$classes[] = !empty($params['additional_effects']) ? 'eltdf-pl-has-'.$params['additional_effects'] : '';
		$classes[] = ! empty( $params['navigation_skin'] ) ? 'eltdf-nav-' . $params['navigation_skin'] . '-skin' : '';
		$classes[] = ! empty( $params['pagination_skin'] ) ? 'eltdf-pag-' . $params['pagination_skin'] . '-skin' : '';
		$classes[] = ! empty( $params['pagination_position'] ) ? 'eltdf-pag-' . $params['pagination_position'] : '';
		$classes[] = ! empty( $params['scattered_offset'] ) ? 'eltdf-scattered-offset-' . $params['scattered_offset'] : '';
		$classes[] = ! empty( $params['additional_class'] ) ? $params['additional_class'] : '';

		return implode( ' ', $classes );
	}

	public function getHolderInnerClasses( $params ) {
		$classes = array();
		
		$classes[] = $params['portfolio_slider_on'] === 'yes' ? 'eltdf-owl-slider eltdf-list-is-slider' : '';
		
		return implode( ' ', $classes );
	}

	public function getArticleClasses( $params ) {
		$classes = array();
		
		$type       = $params['type'];
		$item_style = $params['item_style'];
		
		if ( get_post_meta( get_the_ID(), "eltdf_portfolio_featured_image_meta", true ) !== "" && $item_style === 'standard-switch-images' ) {
			$classes[] = 'eltdf-pl-has-switch-image';
		} elseif ( get_post_meta( get_the_ID(), "eltdf_portfolio_featured_image_meta", true ) === "" && $item_style === 'standard-switch-images' ) {
			$classes[] = 'eltdf-pl-no-switch-image';
		}
		
		$image_proportion = $params['enable_fixed_proportions'] === 'yes' ? 'fixed' : 'original';
		$masonry_size     = get_post_meta( get_the_ID(), 'eltdf_portfolio_masonry_' . $image_proportion . '_dimensions_meta', true );
		
		$classes[] = ! empty( $masonry_size ) && $type === 'masonry' && ! $params['scattered'] ? 'eltdf-masonry-size-' . esc_attr( $masonry_size ) : '';
		
		$article_classes = get_post_class( $classes );
		
		return implode( ' ', $article_classes );
	}

	public function getArticleInnerData( $params ) {
		$articleInnerData = array();

		if ($params['additional_effects'] === 'article-parallax-animation') {
		    $y_absolute = rand(-80, -100);
		    $smoothness = 20; //1 is for linear, non-animated parallax

		    $articleInnerData['data-parallax']= '{&quot;y&quot;: '.$y_absolute.', &quot;smoothness&quot;: '.$smoothness.'}';
		}

		return $articleInnerData;
	}

	public function getImageSize( $params ) {
		$thumb_size = 'full';
		
		if ( ! empty( $params['image_proportions'] ) && $params['type'] == 'gallery' ) {
			$image_size = $params['image_proportions'];
			
			switch ( $image_size ) {
				case 'landscape':
					$thumb_size = 'sahel_elated_image_landscape';
					break;
				case 'portrait':
					$thumb_size = 'sahel_elated_image_portrait';
					break;
				case 'square':
					$thumb_size = 'sahel_elated_image_square';
					break;
				case 'medium':
					$thumb_size = 'medium';
					break;
				case 'large':
					$thumb_size = 'large';
					break;
				case 'full':
					$thumb_size = 'full';
					break;
			}
		}
		
		if ( $params['type'] == 'masonry' && $params['enable_fixed_proportions'] === 'yes' ) {
			$fixed_image_size = get_post_meta( get_the_ID(), 'eltdf_portfolio_masonry_fixed_dimensions_meta', true );
			
			switch ( $fixed_image_size ) {
				case 'small' :
					$thumb_size = 'sahel_elated_image_square';
					break;
				case 'large-width':
					$thumb_size = 'sahel_elated_image_landscape';
					break;
				case 'large-height':
					$thumb_size = 'sahel_elated_image_portrait';
					break;
				case 'large-width-height':
					$thumb_size = 'sahel_elated_image_huge';
					break;
				default :
					$thumb_size = 'full';
					break;
			}
		}
		
		return $thumb_size;
	}

	public function getStandardContentStyles( $params ) {
		$styles = array();
		
		$margin_top    = isset( $params['content_top_margin'] ) ? $params['content_top_margin'] : '';
		$margin_bottom = isset( $params['content_bottom_margin'] ) ? $params['content_bottom_margin'] : '';
		
		if ( ! empty( $margin_top ) ) {
			if ( sahel_elated_string_ends_with( $margin_top, '%' ) || sahel_elated_string_ends_with( $margin_top, 'px' ) ) {
				$styles[] = 'margin-top: ' . $margin_top;
			} else {
				$styles[] = 'margin-top: ' . sahel_elated_filter_px( $margin_top ) . 'px';
			}
		}
		
		if ( ! empty( $margin_bottom ) ) {
			if ( sahel_elated_string_ends_with( $margin_bottom, '%' ) || sahel_elated_string_ends_with( $margin_bottom, 'px' ) ) {
				$styles[] = 'margin-bottom: ' . $margin_bottom;
			} else {
				$styles[] = 'margin-bottom: ' . sahel_elated_filter_px( $margin_bottom ) . 'px';
			}
		}
		
		return implode( ';', $styles );
	}

	public function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_text_transform'] ) ) {
			$styles[] = 'text-transform: ' . $params['title_text_transform'];
		}
		
		return implode( ';', $styles );
	}

	public function getSwitchFeaturedImage() {
		$featured_image_meta = get_post_meta( get_the_ID(), 'eltdf_portfolio_featured_image_meta', true );
		
		$featured_image = ! empty( $featured_image_meta ) ? esc_url( $featured_image_meta ) : '';
		
		return $featured_image;
	}

	public function getLoadMoreStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['load_more_top_margin'] ) ) {
			$margin = $params['load_more_top_margin'];
			
			if ( sahel_elated_string_ends_with( $margin, '%' ) || sahel_elated_string_ends_with( $margin, 'px' ) ) {
				$styles[] = 'margin-top: ' . $margin;
			} else {
				$styles[] = 'margin-top: ' . sahel_elated_filter_px( $margin ) . 'px';
			}
		}
		
		return implode( ';', $styles );
	}

	public function getFilterCategories( $params ) {
		$cat_id = 0;
		
		if ( ! empty( $params['category'] ) ) {
			$top_category = get_term_by( 'slug', $params['category'], 'portfolio-category' );
			
			if ( isset( $top_category->term_id ) ) {
				$cat_id = $top_category->term_id;
			}
		}
		
		$order = $params['filter_order_by'] === 'count' ? 'DESC' : 'ASC';
		
		$args = array(
			'taxonomy' => 'portfolio-category',
			'child_of' => $cat_id,
			'orderby'  => $params['filter_order_by'],
			'order'    => $order
		);
		
		$filter_categories = get_terms( $args );
		
		return $filter_categories;
	}

	public function getFilterHolderStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['filter_bottom_margin'] ) ) {
			$margin = $params['filter_bottom_margin'];
			
			if ( sahel_elated_string_ends_with( $margin, '%' ) || sahel_elated_string_ends_with( $margin, 'px' ) ) {
				$styles[] = 'margin-bottom: ' . $margin;
			} else {
				$styles[] = 'margin-bottom: ' . sahel_elated_filter_px( $margin ) . 'px';
			}
		}
		
		return implode( ';', $styles );
	}

	public function getFilterStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['filter_text_transform'] ) ) {
			$styles[] = 'text-transform: ' . $params['filter_text_transform'];
		}
		
		return implode( ';', $styles );
	}

	public function getItemLink() {
		$portfolio_link_meta = get_post_meta( get_the_ID(), 'portfolio_external_link', true );
		$portfolio_link      = ! empty( $portfolio_link_meta ) ? $portfolio_link_meta : get_permalink( get_the_ID() );
		
		return apply_filters( 'sahel_elated_filter_portfolio_external_link', $portfolio_link );
	}

	public function getItemLinkTarget() {
		$portfolio_link_meta   = get_post_meta( get_the_ID(), 'portfolio_external_link', true );
		$portfolio_link_target = ! empty( $portfolio_link_meta ) ? '_blank' : '_self';
		
		return apply_filters( 'sahel_elated_filter_portfolio_external_link_target', $portfolio_link_target );
	}

	public function getListTitleParams( $params ) {
		$params_array = array();
		$title_params = array();
		$title_style = array();

		if ( $params['enable_list_title'] === 'no') {
			return $title_params;
		}
		if ( $params['list_title'] !== '' ) {
			$title_params['title'] =  $params['list_title'];
		}

		if ( $params['list_title_tag'] !== '' ) {
			$title_params['title_tag'] =  $params['list_title_tag'];
		}

		if ( $params['list_subtitle'] !== '' ) {
			$title_params['subtitle'] =  $params['list_subtitle'];
		}

		if ( $params['list_text'] !== '' ) {
			$title_params['text'] =  $params['list_text'];
		}

		$params_array['title_params'] = $title_params;

		if ( $params['list_title_padding'] !== '') {
			$title_style[] = 'padding: '.$params['list_title_padding'];
		}

		$params_array['title_style'] = implode(';', $title_style);

		return $params_array;
	}

	public function portfolioCategoryAutocompleteSuggester( $query ) {
		global $wpdb;
		$post_meta_infos = $wpdb->get_results( $wpdb->prepare( "SELECT a.slug AS slug, a.name AS portfolio_category_title
					FROM {$wpdb->terms} AS a
					LEFT JOIN ( SELECT term_id, taxonomy  FROM {$wpdb->term_taxonomy} ) AS b ON b.term_id = a.term_id
					WHERE b.taxonomy = 'portfolio-category' AND a.name LIKE '%%%s%%'", stripslashes( $query ) ), ARRAY_A );
		
		$results = array();
		if ( is_array( $post_meta_infos ) && ! empty( $post_meta_infos ) ) {
			foreach ( $post_meta_infos as $value ) {
				$data          = array();
				$data['value'] = $value['slug'];
				$data['label'] = ( ( strlen( $value['portfolio_category_title'] ) > 0 ) ? esc_html__( 'Category', 'sahel-core' ) . ': ' . $value['portfolio_category_title'] : '' );
				$results[]     = $data;
			}
		}
		
		return $results;
	}

	public function portfolioCategoryAutocompleteRender( $query ) {
		$query = trim( $query['value'] ); // get value from requested
		if ( ! empty( $query ) ) {
			// get portfolio category
			$portfolio_category = get_term_by( 'slug', $query, 'portfolio-category' );
			if ( is_object( $portfolio_category ) ) {
				
				$portfolio_category_slug  = $portfolio_category->slug;
				$portfolio_category_title = $portfolio_category->name;
				
				$portfolio_category_title_display = '';
				if ( ! empty( $portfolio_category_title ) ) {
					$portfolio_category_title_display = esc_html__( 'Category', 'sahel-core' ) . ': ' . $portfolio_category_title;
				}
				
				$data          = array();
				$data['value'] = $portfolio_category_slug;
				$data['label'] = $portfolio_category_title_display;
				
				return ! empty( $data ) ? $data : false;
			}
			
			return false;
		}
		
		return false;
	}

	public function portfolioIdAutocompleteSuggester( $query ) {
		global $wpdb;
		$portfolio_id    = (int) $query;
		$post_meta_infos = $wpdb->get_results( $wpdb->prepare( "SELECT ID AS id, post_title AS title
					FROM {$wpdb->posts} 
					WHERE post_type = 'portfolio-item' AND ( ID = '%d' OR post_title LIKE '%%%s%%' )", $portfolio_id > 0 ? $portfolio_id : - 1, stripslashes( $query ), stripslashes( $query ) ), ARRAY_A );
		
		$results = array();
		if ( is_array( $post_meta_infos ) && ! empty( $post_meta_infos ) ) {
			foreach ( $post_meta_infos as $value ) {
				$data          = array();
				$data['value'] = $value['id'];
				$data['label'] = esc_html__( 'Id', 'sahel-core' ) . ': ' . $value['id'] . ( ( strlen( $value['title'] ) > 0 ) ? ' - ' . esc_html__( 'Title', 'sahel-core' ) . ': ' . $value['title'] : '' );
				$results[]     = $data;
			}
		}
		
		return $results;
	}

	public function portfolioIdAutocompleteRender( $query ) {
		$query = trim( $query['value'] ); // get value from requested
		if ( ! empty( $query ) ) {
			// get portfolio
			$portfolio = get_post( (int) $query );
			if ( ! is_wp_error( $portfolio ) ) {
				
				$portfolio_id    = $portfolio->ID;
				$portfolio_title = $portfolio->post_title;
				
				$portfolio_title_display = '';
				if ( ! empty( $portfolio_title ) ) {
					$portfolio_title_display = ' - ' . esc_html__( 'Title', 'sahel-core' ) . ': ' . $portfolio_title;
				}
				
				$portfolio_id_display = esc_html__( 'Id', 'sahel-core' ) . ': ' . $portfolio_id;
				
				$data          = array();
				$data['value'] = $portfolio_id;
				$data['label'] = $portfolio_id_display . $portfolio_title_display;
				
				return ! empty( $data ) ? $data : false;
			}
			
			return false;
		}
		
		return false;
	}

	public function portfolioTagAutocompleteSuggester( $query ) {
		global $wpdb;
		$post_meta_infos = $wpdb->get_results( $wpdb->prepare( "SELECT a.slug AS slug, a.name AS portfolio_tag_title
					FROM {$wpdb->terms} AS a
					LEFT JOIN ( SELECT term_id, taxonomy  FROM {$wpdb->term_taxonomy} ) AS b ON b.term_id = a.term_id
					WHERE b.taxonomy = 'portfolio-tag' AND a.name LIKE '%%%s%%'", stripslashes( $query ) ), ARRAY_A );
		
		$results = array();
		if ( is_array( $post_meta_infos ) && ! empty( $post_meta_infos ) ) {
			foreach ( $post_meta_infos as $value ) {
				$data          = array();
				$data['value'] = $value['slug'];
				$data['label'] = ( ( strlen( $value['portfolio_tag_title'] ) > 0 ) ? esc_html__( 'Tag', 'sahel-core' ) . ': ' . $value['portfolio_tag_title'] : '' );
				$results[]     = $data;
			}
		}
		
		return $results;
	}

	public function portfolioTagAutocompleteRender( $query ) {
		$query = trim( $query['value'] ); // get value from requested
		if ( ! empty( $query ) ) {
			// get portfolio category
			$portfolio_tag = get_term_by( 'slug', $query, 'portfolio-tag' );
			if ( is_object( $portfolio_tag ) ) {
				
				$portfolio_tag_slug  = $portfolio_tag->slug;
				$portfolio_tag_title = $portfolio_tag->name;
				
				$portfolio_tag_title_display = '';
				if ( ! empty( $portfolio_tag_title ) ) {
					$portfolio_tag_title_display = esc_html__( 'Tag', 'sahel-core' ) . ': ' . $portfolio_tag_title;
				}
				
				$data          = array();
				$data['value'] = $portfolio_tag_slug;
				$data['label'] = $portfolio_tag_title_display;
				
				return ! empty( $data ) ? $data : false;
			}
			
			return false;
		}
		
		return false;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorPortfolioList() );