<?php
/**
 * Product quantity inputs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/quantity-input.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 10.1.0
 *
 * @var bool   $readonly If the input should be set to readonly mode.
 * @var string $type     The input type attribute.
 */

defined( 'ABSPATH' ) || exit;

if ( ! isset ( $input_id ) ) {
	$input_id = uniqid( 'quantity_' );
}

if ( $max_value && $min_value === $max_value ) {
	?>
	<div class="eltdf-quantity-buttons quantity hidden">
		<input type="hidden" id="<?php echo esc_attr( $input_id ); ?>" class="qty" name="<?php echo esc_attr( $input_name ); ?>" value="<?php echo esc_attr( $min_value ); ?>" />
	</div>
	<?php
} else {
	/* translators: %s: Quantity. */
	$labelledby = ! empty( $args['product_name'] ) ? sprintf( __( '%s quantity', 'sahel' ), strip_tags( $args['product_name'] ) ) : '';
	?>
	<div class="eltdf-quantity-buttons quantity">
		<span class="eltdf-quantity-label" for="<?php echo esc_attr( $input_id ); ?>"><?php esc_html_e('Quantity','sahel'); ?></span>
		<span class="eltdf-quantity-minus icon_minus-06"></span>
		<input type="text" id="<?php echo esc_attr( $input_id ); ?>"
		       class="input-text qty text eltdf-quantity-input"
		       data-step="<?php echo esc_attr( $step ); ?>"
		       data-min="<?php echo esc_attr( $min_value ); ?>"
		       data-max="<?php echo esc_attr( 0 < $max_value ? $max_value : '' ); ?>"
		       name="<?php echo esc_attr( $input_name ); ?>"
		       value="<?php echo esc_attr( $input_value ); ?>"
				<?php if ( in_array( $type, array( 'text', 'search', 'tel', 'url', 'email', 'password' ), true ) ) : ?>
					size="4"
				<?php endif; ?>
		       aria-label="<?php echo esc_attr_x( 'Qty', 'Product quantity input tooltip', 'sahel' ) ?>" size="4" pattern="<?php echo esc_attr( $pattern ); ?>" inputmode="<?php echo esc_attr( $inputmode ); ?>" aria-labelledby="<?php echo esc_attr( $labelledby ); ?>"
				<?php if ( ! $readonly ) : ?>
					step="<?php echo esc_attr( $step ); ?>"
					placeholder="<?php echo esc_attr( $placeholder ); ?>"
					inputmode="<?php echo esc_attr( $inputmode ); ?>"
					autocomplete="<?php echo esc_attr( isset( $autocomplete ) ? $autocomplete : 'on' ); ?>"
				<?php endif; ?>
		/>
		<span class="eltdf-quantity-plus icon_plus"></span>
	</div>
	<?php
}
