<?php
if ( class_exists( 'SahelCoreClassWidget' ) ) {
    class SahelElatedClassWoocommerceDropdownCart extends SahelCoreClassWidget
    {
        public function __construct()
        {
            parent::__construct(
                'eltdf_woocommerce_dropdown_cart',
                esc_html__('Sahel WooCommerce Dropdown Cart', 'sahel'),
                array('description' => esc_html__('Display a shop cart icon with a dropdown that shows products that are in the cart', 'sahel'),)
            );

            $this->setParams();
        }

        protected function setParams()
        {
            $this->params = array(
                array(
                    'type' => 'textfield',
                    'name' => 'woocommerce_dropdown_cart_margin',
                    'title' => esc_html__('Icon Margin', 'sahel'),
                    'description' => esc_html__('Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'sahel')
                )
            );
        }

        public function widget($args, $instance)
        {
            extract($args);

            $icon_styles = array();

            if ($instance['woocommerce_dropdown_cart_margin'] !== '') {
                $icon_styles[] = 'margin: ' . $instance['woocommerce_dropdown_cart_margin'];
            }

            $dropdown_cart_icon_class = sahel_elated_get_dropdown_cart_icon_class();
            ?>
            <div class="eltdf-shopping-cart-holder" <?php sahel_elated_inline_style($icon_styles) ?>>
	            <?php if ( is_object( WC()->cart ) ) { ?>
		            <div class="eltdf-shopping-cart-inner">
			            <a itemprop="url" <?php sahel_elated_class_attribute( $dropdown_cart_icon_class ); ?>
			               href="<?php echo esc_url( wc_get_cart_url() ); ?>">
				            <span class="eltdf-cart-icon"><?php echo sahel_elated_get_icon_sources_html( 'dropdown_cart', false, array( 'dropdown_cart' => 'yes' ) ); ?></span>
				            <span class="eltdf-cart-number"><?php echo sprintf( _n( '%d', '%d', WC()->cart->cart_contents_count, 'sahel' ), WC()->cart->cart_contents_count ); ?></span>
			            </a>
			            <div class="eltdf-shopping-cart-dropdown">
				            <ul>
					            <?php if ( ! WC()->cart->is_empty() ) : ?>
						            <?php foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) :
							            $_product = $cart_item['data'];
							            // Only display if allowed
							            if ( ! $_product->exists() || $cart_item['quantity'] == 0 ) {
								            continue;
							            } ?>
							            <li>
								            <div class="eltdf-item-image-holder">
									            <a itemprop="url"
									               href="<?php echo esc_url( get_permalink( $cart_item['product_id'] ) ); ?>">
										            <?php echo wp_kses( apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image() ), array(
											            'img' => array(
												            'src'    => true,
												            'width'  => true,
												            'height' => true,
												            'class'  => true,
												            'alt'    => true,
												            'title'  => true,
												            'id'     => true
											            )
										            ) ); ?>
									            </a>
								            </div>
								            <div class="eltdf-item-info-holder">
									            <h5 itemprop="name" class="eltdf-product-title">
										            <a itemprop="url"
										               href="<?php echo esc_url( get_permalink( $cart_item['product_id'] ) ); ?>"><?php echo apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $_product ); ?></a>
									            </h5>
									            <?php echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key ); ?>
									            <?php if ( apply_filters( 'sahel_elated_woo_cart_enable_quantity', true ) ) { ?>
										            <span class="eltdf-quantity"><?php esc_html_e( 'Quantity: ', 'sahel' );
											            echo esc_html( $cart_item['quantity'] ); ?></span>
									            <?php } ?>
									            <?php echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf( '<a href="%s" class="remove" title="%s"><span class="icon-arrows-remove"></span></a>', esc_url( wc_get_cart_remove_url( $cart_item_key ) ), esc_attr__( 'Remove this item', 'sahel' ) ), $cart_item_key ); ?>
								            </div>
							            </li>
						            <?php endforeach; ?>
						            <li class="eltdf-cart-bottom">
							            <div class="eltdf-subtotal-holder clearfix">
								            <span class="eltdf-total"><?php esc_html_e( 'Total:', 'sahel' ); ?></span>
								            <span class="eltdf-total-amount">
										<?php echo wp_kses( WC()->cart->get_cart_subtotal(), array(
											'span' => array(
												'class' => true,
												'id'    => true
											)
										) ); ?>
									</span>
							            </div>
							
							            <div class="eltdf-btn-holder clearfix">
								            <a itemprop="url" href="<?php echo esc_url( wc_get_cart_url() ); ?>"
								               class="eltdf-view-cart"
								               data-title="<?php esc_attr_e( 'View cart', 'sahel' ); ?>"><span><?php esc_html_e( 'View cart', 'sahel' ); ?></span></a>
							            </div>
							            <div class="eltdf-btn-holder clearfix">
								            <a itemprop="url" href="<?php echo esc_url( wc_get_checkout_url() ); ?>"
								               class="eltdf-checkout"
								               data-title="<?php esc_attr_e( 'Checkout', 'sahel' ); ?>"><span><?php esc_html_e( 'Checkout', 'sahel' ); ?></span></a>
							            </div>
						            </li>
					            <?php else : ?>
						            <li class="eltdf-empty-cart"><?php esc_html_e( 'No products in the cart.', 'sahel' ); ?></li>
					            <?php endif; ?>
				            </ul>
			            </div>
		            </div>
	            <?php } ?>
            </div>
            <?php
        }
    }
}

add_filter('woocommerce_add_to_cart_fragments', 'sahel_elated_woocommerce_header_add_to_cart_fragment');

function sahel_elated_woocommerce_header_add_to_cart_fragment($fragments) {

    ob_start();
    
    $dropdown_cart_icon_class = sahel_elated_get_dropdown_cart_icon_class();

    ?>
    <div class="eltdf-shopping-cart-inner">
	    <?php if ( is_object( WC()->cart ) ) { ?>
		    <a itemprop="url" <?php sahel_elated_class_attribute( $dropdown_cart_icon_class ); ?>
		       href="<?php echo esc_url( wc_get_cart_url() ); ?>">
			    <span class="eltdf-cart-icon"><svg xmlns="http://www.w3.org/2000/svg"
			                                       xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
			                                       width="20px" height="20px" viewBox="0 0 20 20"
			                                       style="enable-background:new 0 0 20 20;" xml:space="preserve"><g><path
								    d="M16.7,5h-3.2V4c0-2.1-1.7-3.9-3.9-3.9C7.5,0.1,5.8,1.8,5.8,4v1H3C2.8,5,2.6,5.2,2.6,5.4L0.2,19.6c0,0.2,0.2,0.4,0.4,0.4h18.7c0.2,0,0.4-0.2,0.4-0.4L17.2,5.4C17.2,5.2,17,5,16.7,5z M6.6,4c0-1.7,1.4-3,3-3c1.7,0,3,1.4,3,3v1h-6V4z M18.9,19.2H1.1L3.4,5.9h12.9L18.9,19.2z"/></g></svg></span><span
					    class="eltdf-cart-number"><?php echo sprintf( _n( '%d', '%d', WC()->cart->cart_contents_count, 'sahel' ), WC()->cart->cart_contents_count ); ?></span>
		    </a>
		    <div class="eltdf-shopping-cart-dropdown">
			    <ul>
				    <?php if ( ! WC()->cart->is_empty() ) : ?>
					    <?php foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) :
						    $_product = $cart_item['data'];
						    // Only display if allowed
						    if ( ! $_product->exists() || $cart_item['quantity'] == 0 ) {
							    continue;
						    } ?>
						    <li>
							    <div class="eltdf-item-image-holder">
								    <a itemprop="url"
								       href="<?php echo esc_url( get_permalink( $cart_item['product_id'] ) ); ?>">
									    <?php echo wp_kses( apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image() ), array(
										    'img' => array(
											    'src'    => true,
											    'width'  => true,
											    'height' => true,
											    'class'  => true,
											    'alt'    => true,
											    'title'  => true,
											    'id'     => true
										    )
									    ) ); ?>
								    </a>
							    </div>
							    <div class="eltdf-item-info-holder">
								    <h5 itemprop="name" class="eltdf-product-title">
									    <a itemprop="url"
									       href="<?php echo esc_url( get_permalink( $cart_item['product_id'] ) ); ?>"><?php echo apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $_product ); ?></a>
								    </h5>
								    <?php echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key ); ?>
								    <?php if ( apply_filters( 'sahel_elated_woo_cart_enable_quantity', true ) ) { ?>
									    <span class="eltdf-quantity"><?php esc_html_e( 'Quantity: ', 'sahel' );
										    echo esc_html( $cart_item['quantity'] ); ?></span>
								    <?php } ?>
								    <?php echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf( '<a href="%s" class="remove" title="%s"><span class="icon-arrows-remove"></span></a>', esc_url( wc_get_cart_remove_url( $cart_item_key ) ), esc_attr__( 'Remove this item', 'sahel' ) ), $cart_item_key ); ?>
							    </div>
						    </li>
					    <?php endforeach; ?>
					    <li class="eltdf-cart-bottom">
						    <div class="eltdf-subtotal-holder clearfix">
							    <span class="eltdf-total"><?php esc_html_e( 'Total:', 'sahel' ); ?></span>
							    <span class="eltdf-total-amount">
								<?php echo wp_kses( WC()->cart->get_cart_subtotal(), array(
									'span' => array(
										'class' => true,
										'id'    => true
									)
								) ); ?>
							</span>
						    </div>
						    <div class="eltdf-btn-holder clearfix">
							    <a itemprop="url" href="<?php echo esc_url( wc_get_cart_url() ); ?>"
							       class="eltdf-view-cart"
							       data-title="<?php esc_attr_e( 'View cart', 'sahel' ); ?>"><span><?php esc_html_e( 'View cart', 'sahel' ); ?></span></a>
						    </div>
						    <div class="eltdf-btn-holder clearfix">
							    <a itemprop="url" href="<?php echo esc_url( wc_get_checkout_url() ); ?>"
							       class="eltdf-checkout"
							       data-title="<?php esc_attr_e( 'Checkout', 'sahel' ); ?>"><span><?php esc_html_e( 'Checkout', 'sahel' ); ?></span></a>
						    </div>
					    </li>
				    <?php else : ?>
					    <li class="eltdf-empty-cart"><?php esc_html_e( 'No products in the cart.', 'sahel' ); ?></li>
				    <?php endif; ?>
			    </ul>
		    </div>
	    <?php } ?>
    </div>

    <?php
    $fragments['div.eltdf-shopping-cart-inner'] = ob_get_clean();

    return $fragments;
}

?>