<?php

if ( ! function_exists( 'sahel_elated_dropdown_cart_icon_styles' ) ) {
	/**
	 * Generates styles for dropdown cart icon
	 */
	function sahel_elated_dropdown_cart_icon_styles() {
		$icon_color       = sahel_elated_options()->getOptionValue( 'dropdown_cart_icon_color' );
		$icon_hover_color = sahel_elated_options()->getOptionValue( 'dropdown_cart_hover_color' );
		
		if ( ! empty( $icon_color ) ) {
			echo sahel_elated_dynamic_css( '.eltdf-shopping-cart-holder .eltdf-header-cart a', array( 'color' => $icon_color ) );
		}
		
		if ( ! empty( $icon_hover_color ) ) {
			echo sahel_elated_dynamic_css( '.eltdf-shopping-cart-holder .eltdf-header-cart a:hover', array( 'color' => $icon_hover_color ) );
		}
	}
	
	add_action( 'sahel_elated_action_style_dynamic', 'sahel_elated_dropdown_cart_icon_styles' );
}