<?php

if ( ! function_exists( 'sahel_elated_add_product_pair_shortcode' ) ) {
	function sahel_elated_add_product_pair_shortcode( $shortcodes_class_name ) {
		$shortcodes = array(
			'SahelCore\CPT\Shortcodes\ProductPair\ProductPair',
		);
		
		$shortcodes_class_name = array_merge( $shortcodes_class_name, $shortcodes );
		
		return $shortcodes_class_name;
	}
	
	if ( sahel_elated_core_plugin_installed() ) {
		add_filter( 'sahel_core_filter_add_vc_shortcode', 'sahel_elated_add_product_pair_shortcode' );
	}
}

if ( ! function_exists( 'sahel_elated_set_product_pair_icon_class_name_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom icon class name for product list shortcode to set our icon for Visual Composer shortcodes panel
	 */
	function sahel_elated_set_product_pair_icon_class_name_for_vc_shortcodes( $shortcodes_icon_class_array ) {
		$shortcodes_icon_class_array[] = '.icon-wpb-product-pair';

		return $shortcodes_icon_class_array;
	}

	add_filter( 'sahel_core_filter_add_vc_shortcodes_custom_icon_class', 'sahel_elated_set_product_pair_icon_class_name_for_vc_shortcodes' );
}

if ( ! function_exists( 'sahel_elated_product_pair_into_shortcodes_list' ) ) {
	function sahel_elated_product_pair_into_shortcodes_list( $woocommerce_shortcodes ) {
		$woocommerce_shortcodes[] = 'eltdf_product_pair';
		
		return $woocommerce_shortcodes;
	}
	
	add_filter( 'sahel_elated_filter_woocommerce_shortcodes_list', 'sahel_elated_product_pair_into_shortcodes_list' );
}