<?php
class ElementorProductPair extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_product_pair'; 
	}

	public function get_title() {
		return esc_html__( 'Product Pair', 'sahel' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-product-pair';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'small_product_id',
			[
				'label'     => esc_html__( 'Small Product', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'If you left this field empty then product ID will be of the current page', 'sahel' )
			]
		);

		$this->add_control(
			'enable_custom_image_1',
			[
				'label'     => esc_html__( 'Enable Custom Image For Small Product', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'sahel'), 
					'yes' => esc_html__( 'Yes', 'sahel')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'custom_image_1',
			[
				'label'     => esc_html__( 'Custom Image', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'condition' => [
					'enable_custom_image_1' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'big_product_id',
			[
				'label'     => esc_html__( 'Big Product', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'If you left this field empty then product ID will be of the current page', 'sahel' )
			]
		);

		$this->add_control(
			'enable_custom_image_2',
			[
				'label'     => esc_html__( 'Enable Custom Image For Big Image', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'sahel'), 
					'yes' => esc_html__( 'Yes', 'sahel')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'custom_image_2',
			[
				'label'     => esc_html__( 'Custom Image', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'condition' => [
					'enable_custom_image_2' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'layout',
			[
				'label'     => esc_html__( 'Layout order', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Small Product On The Left', 'sahel'), 
					'eltdf-big-product-first' => esc_html__( 'Big Product On The Left', 'sahel')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel'), 
					'h1' => esc_html__( 'h1', 'sahel'), 
					'h2' => esc_html__( 'h2', 'sahel'), 
					'h3' => esc_html__( 'h3', 'sahel'), 
					'h4' => esc_html__( 'h4', 'sahel'), 
					'h5' => esc_html__( 'h5', 'sahel'), 
					'h6' => esc_html__( 'h6', 'sahel')
				),
				'default' => 'h5'
			]
		);

		$this->add_control(
			'trim_background_color',
			[
				'label'     => esc_html__( 'Trim Background Color', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'parallax_scroll',
			[
				'label'     => esc_html__( 'Enable Parallax Scroll Effect', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel'),
					'no' => esc_html__( 'No', 'sahel')
				),
				'default' => 'yes'
			]
		);


		$this->end_controls_section();
	}

	public function render() {

		$params = $this->get_settings_for_display();

	    $params['small_product_id'] = !empty($params['small_product_id']) ? $params['small_product_id'] : get_the_ID();
		$params['big_product_id'] = !empty($params['big_product_id']) ? $params['big_product_id'] : get_the_ID();

		$params['custom_image_1'] = !empty($params['custom_image_1']) ? $params['custom_image_1']['id'] : $params['custom_image_1'];
		$params['custom_image_2'] = !empty($params['custom_image_2']) ? $params['custom_image_2']['id'] : $params['custom_image_2'];

		$params['title_tag'] = !empty($params['title_tag']) ? $params['title_tag'] : 'h5';

		$params['products'] = array();
		$params['products'][] = array('class_name' => 'eltdf-small-product', 'product_id' => $params['small_product_id'], 'image_size' => 'sahel_elated_image_square', 'enable_custom_image' => $params['enable_custom_image_1'], 'custom_image' => $params['custom_image_1'], 'display_button' => 'yes' );
		$params['products'][] = array('class_name' => 'eltdf-big-product', 'product_id' => $params['big_product_id'], 'image_size' => 'sahel_elated_image_portrait', 'enable_custom_image' => $params['enable_custom_image_2'], 'custom_image' => $params['custom_image_2'], 'display_button' => 'yes' );


		$params['holder_classes'] = $this->getHolderClasses($params);
		$params['trim_styles'] = $this->getTrimStyles($params);
		$params['parallax_data_1'] = $this->getParallaxData1($params);
		$params['parallax_data_2'] = $this->getParallaxData2($params);

		echo sahel_elated_get_woo_shortcode_module_template_part( 'templates/product-pair', 'product-pair', '', $params );
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		if ( ! empty( $params['layout'] ) ) {
			$holderClasses[] = $params['layout'];
		}

		if ($params['parallax_scroll'] == 'yes') {
			$holderClasses[] = 'eltdf-parallax-scroll';
		}
		
		return implode( ' ', $holderClasses );
	}

	public function getItemTitleHtml( $params ) {
		$html               = '';
		$product_id         = $params['product_id'];
		$title              = get_the_title( $product_id );
		$title_tag          = $params['title_tag'];

		if ( ! empty( $title ) ) {
			$html = '<' . esc_attr( $title_tag ) . ' itemprop="name" class="eltdf-pi-title entry-title">';
				$html .= '<a itemprop="url" href="' . esc_url( get_the_permalink( $product_id ) ) . '">' . esc_html( $title ) . '</a>';
			$html .= '</' . esc_attr( $title_tag ) . '>';
		}
		
		return $html;
	}

	public function getItemPriceHtml( $params ) {
		$html               = '';
		$product_id         = $params['product_id'];
		$product            = wc_get_product( $product_id );
		$currency = '<div class="eltdf-currency">' . get_woocommerce_currency_symbol() . '</div>';
		
		if ($product->is_in_stock() ) {

			if( $product->is_on_sale() ) {
				$price_html = $currency . $product->get_sale_price($context = 'view');
			}
			else $price_html = $currency . $product->get_regular_price();

			$html = '<div class="eltdf-pi-price">' . $price_html . '</div>';
		}
		
		return $html;
	}

	public function getItemExcerptHtml( $params ) {
		$html               = '';
		$product_id         = $params['product_id'];

		if ( $product_excerpt = get_the_excerpt($product_id) ) {
			$html = '<div class="eltdf-pi-excerpt">' . $product_excerpt . '</div>';
		}

		return $html;
	}

	public function getParallaxData1( $params ) {
		$parallaxData = array();

		if ($params['parallax_scroll'] === 'yes') {
		    $y_absolute = rand(-80, -100);
		    $smoothness = 20; //1 is for linear, non-animated parallax

		    $parallaxData['data-parallax']= '{&quot;y&quot;: '.$y_absolute.', &quot;smoothness&quot;: '.$smoothness.'}';
		}

		return $parallaxData;
	}

	public function getParallaxData2( $params ) {
		$parallaxData = array();

		if ($params['parallax_scroll'] === 'yes') {
		    $y_absolute = rand(-20, -60);
		    $smoothness = 20; //1 is for linear, non-animated parallax

		    $parallaxData['data-parallax']= '{&quot;y&quot;: '.$y_absolute.', &quot;smoothness&quot;: '.$smoothness.'}';
		}

		return $parallaxData;
	}

	public function smallProductIdAutocompleteSuggester( $query ) {
		global $wpdb;
		$product_id = (int) $query;
		$post_meta_infos = $wpdb->get_results( $wpdb->prepare( "SELECT ID AS id, post_title AS title
					FROM {$wpdb->posts} 
					WHERE post_type = 'product' AND ( ID = '%d' OR post_title LIKE '%%%s%%' )", $product_id > 0 ? $product_id : - 1, stripslashes( $query ), stripslashes( $query ) ), ARRAY_A );

		$results = array();
		if ( is_array( $post_meta_infos ) && ! empty( $post_meta_infos ) ) {
			foreach ( $post_meta_infos as $value ) {
				$data = array();
				$data['value'] = $value['id'];
				$data['label'] = esc_html__( 'Id', 'sahel' ) . ': ' . $value['id'] . ( ( strlen( $value['title'] ) > 0 ) ? ' - ' . esc_html__( 'Title', 'sahel' ) . ': ' . $value['title'] : '' );
				$results[] = $data;
			}
		}

		return $results;

	}

	public function smallProductIdAutocompleteRender( $query ) {
		$query = trim( $query['value'] ); // get value from requested
		if ( ! empty( $query ) ) {
			
			$product = get_post( (int) $query );
			if ( ! is_wp_error( $product ) ) {
				
				$product_id = $product->ID;
				$product_title = $product->post_title;
				
				$product_title_display = '';
				if ( ! empty( $portfolio_title ) ) {
					$product_title_display = ' - ' . esc_html__( 'Title', 'sahel' ) . ': ' . $product_title;
				}
				
				$product_id_display = esc_html__( 'Id', 'sahel' ) . ': ' . $product_id;

				$data          = array();
				$data['value'] = $product_id;
				$data['label'] = $product_id_display . $product_title_display;

				return ! empty( $data ) ? $data : false;
			}

			return false;
		}

		return false;
	}

	public function bigProductIdAutocompleteSuggester( $query ) {
		global $wpdb;
		$product_id = (int) $query;
		$post_meta_infos = $wpdb->get_results( $wpdb->prepare( "SELECT ID AS id, post_title AS title
					FROM {$wpdb->posts}
					WHERE post_type = 'product' AND ( ID = '%d' OR post_title LIKE '%%%s%%' )", $product_id > 0 ? $product_id : - 1, stripslashes( $query ), stripslashes( $query ) ), ARRAY_A );

		$results = array();
		if ( is_array( $post_meta_infos ) && ! empty( $post_meta_infos ) ) {
			foreach ( $post_meta_infos as $value ) {
				$data = array();
				$data['value'] = $value['id'];
				$data['label'] = esc_html__( 'Id', 'sahel' ) . ': ' . $value['id'] . ( ( strlen( $value['title'] ) > 0 ) ? ' - ' . esc_html__( 'Title', 'sahel' ) . ': ' . $value['title'] : '' );
				$results[] = $data;
			}
		}

		return $results;

	}

	public function bigProductIdAutocompleteRender( $query ) {
		$query = trim( $query['value'] ); // get value from requested
		if ( ! empty( $query ) ) {

			$product = get_post( (int) $query );
			if ( ! is_wp_error( $product ) ) {

				$product_id = $product->ID;
				$product_title = $product->post_title;

				$product_title_display = '';
				if ( ! empty( $portfolio_title ) ) {
					$product_title_display = ' - ' . esc_html__( 'Title', 'sahel' ) . ': ' . $product_title;
				}

				$product_id_display = esc_html__( 'Id', 'sahel' ) . ': ' . $product_id;

				$data          = array();
				$data['value'] = $product_id;
				$data['label'] = $product_id_display . $product_title_display;

				return ! empty( $data ) ? $data : false;
			}

			return false;
		}

		return false;
	}

	public function getTrimStyles( $params ) {
		$styles = array();

		if (!empty($params['trim_background_color'])) {
			$styles[] = 'border-color: ' . $params['trim_background_color'] . ';';
		}

		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorProductPair() );