<?php

if ( ! function_exists( 'sahel_elated_map_woocommerce_meta' ) ) {
	function sahel_elated_map_woocommerce_meta() {
		
		$woocommerce_meta_box = sahel_elated_create_meta_box(
			array(
				'scope' => array( 'product' ),
				'title' => esc_html__( 'Product Meta', 'sahel' ),
				'name'  => 'woo_product_meta'
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_product_featured_image_size',
				'type'        => 'select',
				'label'       => esc_html__( 'Dimensions for Product List Shortcode', 'sahel' ),
				'description' => esc_html__( 'Choose image layout when it appears in Elated Product List - Masonry layout shortcode', 'sahel' ),
				'options'     => array(
					''                   => esc_html__( 'Default', 'sahel' ),
					'small'              => esc_html__( 'Small', 'sahel' ),
					'large-width'        => esc_html__( 'Large Width', 'sahel' ),
					'large-height'       => esc_html__( 'Large Height', 'sahel' ),
					'large-width-height' => esc_html__( 'Large Width Height', 'sahel' )
				),
				'parent'      => $woocommerce_meta_box
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_woo_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'sahel' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'sahel' ),
				'options'       => sahel_elated_get_yes_no_select_array(),
				'parent'        => $woocommerce_meta_box
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_new_sign_woo_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show New Sign', 'sahel' ),
				'description'   => esc_html__( 'Enabling this option will show new sign mark on product', 'sahel' ),
				'parent'        => $woocommerce_meta_box
			)
		);
	}
	
	add_action( 'sahel_elated_action_meta_boxes_map', 'sahel_elated_map_woocommerce_meta', 99 );
}