<?php

class SahelElatedClassSeparatorWidget extends SahelElatedClassWidget {
	public function __construct() {
		parent::__construct(
			'eltdf_separator_widget',
			esc_html__( 'Sahel Separator Widget', 'sahel' ),
			array( 'description' => esc_html__( 'Add a separator element to your widget areas', 'sahel' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Type', 'sahel' ),
				'options' => array(
					'normal'     => esc_html__( 'Normal', 'sahel' ),
					'full-width' => esc_html__( 'Full Width', 'sahel' )
				)
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'position',
				'title'   => esc_html__( 'Position', 'sahel' ),
				'options' => array(
					'center' => esc_html__( 'Center', 'sahel' ),
					'left'   => esc_html__( 'Left', 'sahel' ),
					'right'  => esc_html__( 'Right', 'sahel' )
				)
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'border_style',
				'title'   => esc_html__( 'Style', 'sahel' ),
				'options' => array(
					'solid'  => esc_html__( 'Solid', 'sahel' ),
					'dashed' => esc_html__( 'Dashed', 'sahel' ),
					'dotted' => esc_html__( 'Dotted', 'sahel' )
				)
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'sahel' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'width',
				'title' => esc_html__( 'Width (px or %)', 'sahel' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'thickness',
				'title' => esc_html__( 'Thickness (px)', 'sahel' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'top_margin',
				'title' => esc_html__( 'Top Margin (px or %)', 'sahel' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'bottom_margin',
				'title' => esc_html__( 'Bottom Margin (px or %)', 'sahel' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}
		
		//prepare variables
		$params = '';
		
		//is instance empty?
		if ( is_array( $instance ) && count( $instance ) ) {
			//generate shortcode params
			foreach ( $instance as $key => $value ) {
				$params .= " $key='$value' ";
			}
		}
		
		echo '<div class="widget eltdf-separator-widget">';
			echo do_shortcode( "[eltdf_separator $params]" ); // XSS OK
		echo '</div>';
	}
}