<?php

class SahelElatedClassButtonWidget extends SahelElatedClassWidget {
	public function __construct() {
		parent::__construct(
			'eltdf_button_widget',
			esc_html__( 'Sahel Button Widget', 'sahel' ),
			array( 'description' => esc_html__( 'Add button element to widget areas', 'sahel' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Type', 'sahel' ),
				'options' => array(
					'solid'   => esc_html__( 'Solid', 'sahel' ),
					'outline' => esc_html__( 'Outline', 'sahel' ),
					'simple'  => esc_html__( 'Simple', 'sahel' )
				)
			),
			array(
				'type'        => 'dropdown',
				'name'        => 'size',
				'title'       => esc_html__( 'Size', 'sahel' ),
				'options'     => array(
					'small'  => esc_html__( 'Small', 'sahel' ),
					'medium' => esc_html__( 'Medium', 'sahel' ),
					'large'  => esc_html__( 'Large', 'sahel' ),
					'huge'   => esc_html__( 'Huge', 'sahel' )
				),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'sahel' )
			),
			array(
				'type'    => 'textfield',
				'name'    => 'text',
				'title'   => esc_html__( 'Text', 'sahel' ),
				'default' => esc_html__( 'Button Text', 'sahel' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'link',
				'title' => esc_html__( 'Link', 'sahel' )
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'target',
				'title'   => esc_html__( 'Link Target', 'sahel' ),
				'options' => sahel_elated_get_link_target_array()
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'sahel' )
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'hover_color',
				'title' => esc_html__( 'Hover Color', 'sahel' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'background_color',
				'title'       => esc_html__( 'Background Color', 'sahel' ),
				'description' => esc_html__( 'This option is only available for solid button type', 'sahel' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'hover_background_color',
				'title'       => esc_html__( 'Hover Background Color', 'sahel' ),
				'description' => esc_html__( 'This option is only available for solid button type', 'sahel' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'border_color',
				'title'       => esc_html__( 'Border Color', 'sahel' ),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'sahel' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'hover_border_color',
				'title'       => esc_html__( 'Hover Border Color', 'sahel' ),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'sahel' )
			),
			array(
				'type'        => 'textfield',
				'name'        => 'margin',
				'title'       => esc_html__( 'Margin', 'sahel' ),
				'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'sahel' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		$params = '';
		
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}
		
		// Filter out all empty params
		$instance = array_filter( $instance, function ( $array_value ) {
			return trim( $array_value ) != '';
		} );
		
		// Default values
		if ( ! isset( $instance['text'] ) ) {
			$instance['text'] = 'Button Text';
		}
		
		// Generate shortcode params
		foreach ( $instance as $key => $value ) {
			$params .= " $key='$value' ";
		}
		
		echo '<div class="widget eltdf-button-widget">';
			echo do_shortcode( "[eltdf_button $params]" ); // XSS OK
		echo '</div>';
	}
}