<?php

class SahelElatedClassAuthorInfoWidget extends SahelElatedClassWidget {
	public function __construct() {
		parent::__construct(
			'eltdf_author_info_widget',
			esc_html__( 'Sahel Author Info Widget', 'sahel' ),
			array( 'description' => esc_html__( 'Add author info element to widget areas', 'sahel' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'  => 'textfield',
				'name'  => 'extra_class',
				'title' => esc_html__( 'Custom CSS Class', 'sahel' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'widget_bottom_margin',
				'title' => esc_html__( 'Widget Bottom Margin (px)', 'sahel' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'author_username',
				'title' => esc_html__( 'Author Username', 'sahel' )
			),
            array(
                'type'  => 'textfield',
                'name'  => 'author_position',
                'title' => esc_html__( 'Author Position', 'sahel' )
            )
		);
	}
	
	public function widget( $args, $instance ) {
		extract( $args );
		
		$extra_class = '';
		if ( ! empty( $instance['extra_class'] ) ) {
			$extra_class = $instance['extra_class'];
		}
		
		$widget_styles = array();
		if ( isset( $instance['widget_bottom_margin'] ) && $instance['widget_bottom_margin'] !== '' ) {
			$widget_styles[] = 'margin-bottom: ' . sahel_elated_filter_px( $instance['widget_bottom_margin'] ) . 'px';
		}
		
		$authorID = 1;
		if ( ! empty( $instance['author_username'] ) ) {
			$author = get_user_by( 'login', $instance['author_username'] );
			
			if ( $author ) {
				$authorID = $author->ID;
			}
		}
		
		$author_info = get_the_author_meta( 'description', $authorID );

		$author_position = $instance['author_position'];

		?>
		
		<div class="widget eltdf-author-info-widget <?php echo esc_attr( $extra_class ); ?>" <?php echo sahel_elated_get_inline_style( $widget_styles ); ?>>
			<div class="eltdf-aiw-inner">
				<a itemprop="url" class="eltdf-aiw-image" href="<?php echo esc_url( get_author_posts_url( $authorID ) ); ?>">
					<?php echo sahel_elated_kses_img( get_avatar( $authorID, 500 ) ); ?>
				</a>
				<?php if ( $author_info !== "" ) { ?>
                    <div class="eltdf-aiw-wrapper">
                        <h5 class="eltdf-aiw-title"><?php echo esc_html( get_the_author_meta('user_login', $authorID));?></h5>
                        <?php if($author_position !== ""){?>
                            <h6 itemprop="description" class="eltdf-aiw-text"><?php echo wp_kses_post( $author_position ); ?></h6>
                        <?php }?>
                    </div>
				<?php } ?>
			</div>
		</div>
		<?php
	}
}