<?php

if ( ! function_exists( 'sahel_elated_get_title_types_meta_boxes' ) ) {
	function sahel_elated_get_title_types_meta_boxes() {
		$title_type_options = apply_filters( 'sahel_elated_filter_title_type_meta_boxes', $title_type_options = array( '' => esc_html__( 'Default', 'sahel' ) ) );
		
		return $title_type_options;
	}
}

foreach ( glob( ELATED_FRAMEWORK_MODULES_ROOT_DIR . '/title/types/*/admin/meta-boxes/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'sahel_elated_map_title_meta' ) ) {
	function sahel_elated_map_title_meta() {
		$title_type_meta_boxes = sahel_elated_get_title_types_meta_boxes();
		
		$title_meta_box = sahel_elated_create_meta_box(
			array(
				'scope' => apply_filters( 'sahel_elated_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'title_meta' ),
				'title' => esc_html__( 'Title', 'sahel' ),
				'name'  => 'title_meta'
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_show_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'sahel' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'sahel' ),
				'parent'        => $title_meta_box,
				'options'       => sahel_elated_get_yes_no_select_array()
			)
		);
		
			$show_title_area_meta_container = sahel_elated_add_admin_container(
				array(
					'parent'          => $title_meta_box,
					'name'            => 'eltdf_show_title_area_meta_container',
					'dependency' => array(
						'hide' => array(
							'eltdf_show_title_area_meta' => 'no'
						)
					)
				)
			);
		
				sahel_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_type_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area Type', 'sahel' ),
						'description'   => esc_html__( 'Choose title type', 'sahel' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => $title_type_meta_boxes
					)
				);
		
				sahel_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_in_grid_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area In Grid', 'sahel' ),
						'description'   => esc_html__( 'Set title area content to be in grid', 'sahel' ),
						'options'       => sahel_elated_get_yes_no_select_array(),
						'parent'        => $show_title_area_meta_container
					)
				);
		
				sahel_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_height_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Height', 'sahel' ),
						'description' => esc_html__( 'Set a height for Title Area', 'sahel' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px'
						)
					)
				);
				
				sahel_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_background_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Background Color', 'sahel' ),
						'description' => esc_html__( 'Choose a background color for title area', 'sahel' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				sahel_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_area_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'sahel' ),
						'description' => esc_html__( 'Choose an Image for title area', 'sahel' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				sahel_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_background_image_behavior_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Behavior', 'sahel' ),
						'description'   => esc_html__( 'Choose title area background image behavior', 'sahel' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''                    => esc_html__( 'Default', 'sahel' ),
							'hide'                => esc_html__( 'Hide Image', 'sahel' ),
							'responsive'          => esc_html__( 'Enable Responsive Image', 'sahel' ),
							'responsive-disabled' => esc_html__( 'Disable Responsive Image', 'sahel' ),
							'parallax'            => esc_html__( 'Enable Parallax Image', 'sahel' ),
							'parallax-zoom-out'   => esc_html__( 'Enable Parallax With Zoom Out Image', 'sahel' ),
							'parallax-disabled'   => esc_html__( 'Disable Parallax Image', 'sahel' )
						)
					)
				);
				
				sahel_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_vertical_alignment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Vertical Alignment', 'sahel' ),
						'description'   => esc_html__( 'Specify title area content vertical alignment', 'sahel' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''              => esc_html__( 'Default', 'sahel' ),
							'header-bottom' => esc_html__( 'From Bottom of Header', 'sahel' ),
							'window-top'    => esc_html__( 'From Window Top', 'sahel' )
						)
					)
				);
				

				sahel_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_border_bottom_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Enable Title Border Bottom', 'sahel' ),
						'options'       => sahel_elated_get_yes_no_select_array(),
						'parent'        => $show_title_area_meta_container,

					)
				);

				sahel_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_border_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Title Border Bottom Color', 'sahel' ),
						'description' => esc_html__( 'Choose a color for Title Border Bottom ', 'sahel' ),
						'parent'      => $show_title_area_meta_container,
						'dependency' => array(
							'hide' => array(
								'eltdf_title_border_bottom_meta' => 'no'
							)
						)
					)
				);

				sahel_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_border_offset_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Set Title Border Offset', 'sahel' ),
						'description' => esc_html__( 'Enter left (right) border offset in px or %', 'sahel' ),
						'parent'      => $show_title_area_meta_container,
						'args'          => array(
							 'col_width'  => 3,
							  'suffix'    => esc_html__( 'px', 'sahel' )
						),
						'dependency' => array(
							'hide' => array(
								'eltdf_title_border_bottom_meta' => 'no'
							)
						)
					)
				);


				
				sahel_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_title_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Tag', 'sahel' ),
						'options'       => sahel_elated_get_title_tag( true ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				sahel_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_title_text_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Title Color', 'sahel' ),
						'description' => esc_html__( 'Choose a color for title text', 'sahel' ),
						'parent'      => $show_title_area_meta_container
					)
				);
				
				sahel_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_subtitle_meta',
						'type'          => 'text',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Text', 'sahel' ),
						'description'   => esc_html__( 'Enter your subtitle text', 'sahel' ),
						'parent'        => $show_title_area_meta_container,
						'args'          => array(
							'col_width' => 6
						)
					)
				);
		
				sahel_elated_create_meta_box_field(
					array(
						'name'          => 'eltdf_title_area_subtitle_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Tag', 'sahel' ),
						'options'       => sahel_elated_get_title_tag( true, array( 'p' => 'p' ) ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				sahel_elated_create_meta_box_field(
					array(
						'name'        => 'eltdf_subtitle_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Subtitle Color', 'sahel' ),
						'description' => esc_html__( 'Choose a color for subtitle text', 'sahel' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
		/***************** Additional Title Area Layout - start *****************/
		
		do_action( 'sahel_elated_action_additional_title_area_meta_boxes', $show_title_area_meta_container );
		
		/***************** Additional Title Area Layout - end *****************/
		
	}
	
	add_action( 'sahel_elated_action_meta_boxes_map', 'sahel_elated_map_title_meta', 60 );
}