<?php

if ( ! function_exists( 'sahel_elated_register_sidebars' ) ) {
	/**
	 * Function that registers theme's sidebars
	 */
	function sahel_elated_register_sidebars() {
		
		register_sidebar(
			array(
				'id'            => 'sidebar',
				'name'          => esc_html__( 'Sidebar', 'sahel' ),
				'description'   => esc_html__( 'Default Sidebar area. In order to display this area you need to enable it through global theme options or on page meta box options.', 'sahel' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="eltdf-widget-title-holder"><h4 class="eltdf-widget-title">',
				'after_title'   => '</h4></div>'
			)
		);
	}
	
	add_action( 'widgets_init', 'sahel_elated_register_sidebars', 1 );
}

if ( ! function_exists( 'sahel_elated_add_support_custom_sidebar' ) ) {
	/**
	 * Function that adds theme support for custom sidebars. It also creates SahelElatedClassSidebar object
	 */
	function sahel_elated_add_support_custom_sidebar() {
		add_theme_support( 'SahelElatedClassSidebar' );
		
		if ( get_theme_support( 'SahelElatedClassSidebar' ) ) {
			new SahelElatedClassSidebar();
		}
	}
	
	add_action( 'after_setup_theme', 'sahel_elated_add_support_custom_sidebar' );
}