<?php

if ( ! function_exists( 'sahel_elated_sidebar_options_map' ) ) {
	function sahel_elated_sidebar_options_map() {
		
		sahel_elated_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'sahel' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = sahel_elated_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'sahel' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		sahel_elated_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'sahel' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'sahel' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => sahel_elated_get_custom_sidebars_options()
		) );
		
		$sahel_custom_sidebars = sahel_elated_get_custom_sidebars();
		if ( count( $sahel_custom_sidebars ) > 0 ) {
			sahel_elated_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'sahel' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'sahel' ),
				'parent'      => $sidebar_panel,
				'options'     => $sahel_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'sahel_elated_action_options_map', 'sahel_elated_sidebar_options_map', sahel_elated_set_options_map_position( 'sidebar' ) );
}