<?php

if ( ! function_exists( 'sahel_elated_sidearea_options_map' ) ) {
	function sahel_elated_sidearea_options_map() {

        sahel_elated_add_admin_page(
            array(
                'slug'  => '_side_area_page',
                'title' => esc_html__('Side Area', 'sahel'),
                'icon'  => 'fa fa-indent'
            )
        );

        $side_area_panel = sahel_elated_add_admin_panel(
            array(
                'title' => esc_html__('Side Area', 'sahel'),
                'name'  => 'side_area',
                'page'  => '_side_area_page'
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'select',
                'name'          => 'side_area_type',
                'default_value' => 'side-menu-slide-from-right',
                'label'         => esc_html__('Side Area Type', 'sahel'),
                'description'   => esc_html__('Choose a type of Side Area', 'sahel'),
                'options'       => array(
                    'side-menu-slide-from-right'       => esc_html__('Slide from Right Over Content', 'sahel'),
                    'side-menu-slide-with-content'     => esc_html__('Slide from Right With Content', 'sahel'),
                    'side-area-uncovered-from-content' => esc_html__('Side Area Uncovered from Content', 'sahel'),
                ),
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'text',
                'name'          => 'side_area_width',
                'default_value' => '',
                'label'         => esc_html__('Side Area Width', 'sahel'),
                'description'   => esc_html__('Enter a width for Side Area (px or %). Default width: 405px.', 'sahel'),
                'args'          => array(
                    'col_width' => 3,
                )
            )
        );

        $side_area_width_container = sahel_elated_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_width_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_type' => 'side-menu-slide-from-right',
                    )
                )
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent'        => $side_area_width_container,
                'type'          => 'color',
                'name'          => 'side_area_content_overlay_color',
                'default_value' => '',
                'label'         => esc_html__('Content Overlay Background Color', 'sahel'),
                'description'   => esc_html__('Choose a background color for a content overlay', 'sahel'),
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent'        => $side_area_width_container,
                'type'          => 'text',
                'name'          => 'side_area_content_overlay_opacity',
                'default_value' => '',
                'label'         => esc_html__('Content Overlay Background Transparency', 'sahel'),
                'description'   => esc_html__('Choose a transparency for the content overlay background color (0 = fully transparent, 1 = opaque)', 'sahel'),
                'args'          => array(
                    'col_width' => 3
                )
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'select',
                'name'          => 'side_area_icon_source',
                'default_value' => 'icon_pack',
                'label'         => esc_html__('Select Side Area Icon Source', 'sahel'),
                'description'   => esc_html__('Choose whether you would like to use icons from an icon pack or SVG icons', 'sahel'),
                'options'       => sahel_elated_get_icon_sources_array()
            )
        );

        $side_area_icon_pack_container = sahel_elated_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_icon_pack_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_icon_source' => 'icon_pack'
                    )
                )
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent'        => $side_area_icon_pack_container,
                'type'          => 'select',
                'name'          => 'side_area_icon_pack',
                'default_value' => 'font_elegant',
                'label'         => esc_html__('Side Area Icon Pack', 'sahel'),
                'description'   => esc_html__('Choose icon pack for Side Area icon', 'sahel'),
                'options'       => sahel_elated_icon_collections()->getIconCollectionsExclude(array('linea_icons', 'dripicons', 'simple_line_icons'))
            )
        );

        $side_area_svg_icons_container = sahel_elated_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_svg_icons_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_icon_source' => 'svg_path'
                    )
                )
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent'      => $side_area_svg_icons_container,
                'type'        => 'textarea',
                'name'        => 'side_area_icon_svg_path',
                'label'       => esc_html__('Side Area Icon SVG Path', 'sahel'),
                'description' => esc_html__('Enter your Side Area icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'sahel'),
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent'      => $side_area_svg_icons_container,
                'type'        => 'textarea',
                'name'        => 'side_area_close_icon_svg_path',
                'label'       => esc_html__('Side Area Close Icon SVG Path', 'sahel'),
                'description' => esc_html__('Enter your Side Area close icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'sahel'),
            )
        );

        $side_area_icon_style_group = sahel_elated_add_admin_group(
            array(
                'parent'      => $side_area_panel,
                'name'        => 'side_area_icon_style_group',
                'title'       => esc_html__('Side Area Icon Style', 'sahel'),
                'description' => esc_html__('Define styles for Side Area icon', 'sahel')
            )
        );

        $side_area_icon_style_row1 = sahel_elated_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name'   => 'side_area_icon_style_row1'
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type'   => 'colorsimple',
                'name'   => 'side_area_icon_color',
                'label'  => esc_html__('Color', 'sahel')
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type'   => 'colorsimple',
                'name'   => 'side_area_icon_hover_color',
                'label'  => esc_html__('Hover Color', 'sahel')
            )
        );

        $side_area_icon_style_row2 = sahel_elated_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name'   => 'side_area_icon_style_row2',
                'next'   => true
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type'   => 'colorsimple',
                'name'   => 'side_area_close_icon_color',
                'label'  => esc_html__('Close Icon Color', 'sahel')
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type'   => 'colorsimple',
                'name'   => 'side_area_close_icon_hover_color',
                'label'  => esc_html__('Close Icon Hover Color', 'sahel')
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'color',
                'name'        => 'side_area_background_color',
                'label'       => esc_html__('Background Color', 'sahel'),
                'description' => esc_html__('Choose a background color for Side Area', 'sahel')
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'text',
                'name'        => 'side_area_padding',
                'label'       => esc_html__('Padding', 'sahel'),
                'description' => esc_html__('Define padding for Side Area in format top right bottom left', 'sahel'),
                'args'        => array(
                    'col_width' => 3
                )
            )
        );

        sahel_elated_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'selectblank',
                'name'          => 'side_area_aligment',
                'default_value' => '',
                'label'         => esc_html__('Text Alignment', 'sahel'),
                'description'   => esc_html__('Choose text alignment for side area', 'sahel'),
                'options'       => array(
                    ''       => esc_html__('Default', 'sahel'),
                    'left'   => esc_html__('Left', 'sahel'),
                    'center' => esc_html__('Center', 'sahel'),
                    'right'  => esc_html__('Right', 'sahel')
                )
            )
        );
    }

    add_action('sahel_elated_action_options_map', 'sahel_elated_sidearea_options_map', sahel_elated_set_options_map_position( 'sidearea' ) );
}