<?php

if ( ! function_exists( 'sahel_elated_sticky_header_styles' ) ) {
	/**
	 * Generates styles for sticky haeder
	 */
	function sahel_elated_sticky_header_styles() {
		$background_color        = sahel_elated_options()->getOptionValue( 'sticky_header_background_color' );
		$background_transparency = sahel_elated_options()->getOptionValue( 'sticky_header_transparency' );
		$border_color            = sahel_elated_options()->getOptionValue( 'sticky_header_border_color' );
		$header_height           = sahel_elated_options()->getOptionValue( 'sticky_header_height' );
		
		if ( ! empty( $background_color ) ) {
			$header_background_color              = $background_color;
			$header_background_color_transparency = 1;
			
			if ( $background_transparency !== '' ) {
				$header_background_color_transparency = $background_transparency;
			}
			
			echo sahel_elated_dynamic_css( '.eltdf-page-header .eltdf-sticky-header .eltdf-sticky-holder', array( 'background-color' => sahel_elated_rgba_color( $header_background_color, $header_background_color_transparency ) ) );
		}

		$border_color_selector = array(
			'.eltdf-page-header .eltdf-sticky-header .eltdf-sticky-holder',
			'.eltdf-menu-area-bordered-type .eltdf-sticky-header .eltdf-sticky-holder .eltdf-last-widget-wrapper',
			'.eltdf-menu-area-bordered-type .eltdf-sticky-header .eltdf-sticky-holder .eltdf-logo-wrapper-outer'
		);
		if ( ! empty( $border_color ) ) {
			echo sahel_elated_dynamic_css( $border_color_selector, array( 'border-color' => $border_color ) );
		}
		
		if ( ! empty( $header_height ) ) {
			$height = sahel_elated_filter_px( $header_height ) . 'px';
			
			echo sahel_elated_dynamic_css( '.eltdf-page-header .eltdf-sticky-header', array( 'height' => $height ) );
			echo sahel_elated_dynamic_css( '.eltdf-page-header .eltdf-sticky-header .eltdf-logo-wrapper a', array( 'max-height' => $height ) );
		}
		
		$sticky_container_selector = '.eltdf-sticky-header .eltdf-sticky-holder .eltdf-vertical-align-containers';
		$sticky_container_styles   = array();
		$container_side_padding    = sahel_elated_options()->getOptionValue( 'sticky_header_side_padding' );
		
		if ( $container_side_padding !== '' ) {
			if ( sahel_elated_string_ends_with( $container_side_padding, 'px' ) || sahel_elated_string_ends_with( $container_side_padding, '%' ) ) {
				$sticky_container_styles['padding-left']  = $container_side_padding;
				$sticky_container_styles['padding-right'] = $container_side_padding;
			} else {
				$sticky_container_styles['padding-left']  = sahel_elated_filter_px( $container_side_padding ) . 'px';
				$sticky_container_styles['padding-right'] = sahel_elated_filter_px( $container_side_padding ) . 'px';
			}
			
			echo sahel_elated_dynamic_css( $sticky_container_selector, $sticky_container_styles );
		}
		
		// sticky menu style
		
		$menu_item_styles = sahel_elated_get_typography_styles( 'sticky' );
		
		$menu_item_selector = array(
			'.eltdf-main-menu.eltdf-sticky-nav > ul > li > a'
		);
		
		echo sahel_elated_dynamic_css( $menu_item_selector, $menu_item_styles );
		
		
		$hover_color = sahel_elated_options()->getOptionValue( 'sticky_hovercolor' );
		
		$menu_item_hover_styles = array();
		if ( ! empty( $hover_color ) ) {
			$menu_item_hover_styles['color'] = $hover_color;
		}
		
		$menu_item_hover_selector = array(
			'.eltdf-main-menu.eltdf-sticky-nav > ul > li:hover > a',
			'.eltdf-main-menu.eltdf-sticky-nav > ul > li.eltdf-active-item > a'
		);
		
		echo sahel_elated_dynamic_css( $menu_item_hover_selector, $menu_item_hover_styles );
	}
	
	add_action( 'sahel_elated_action_style_dynamic', 'sahel_elated_sticky_header_styles' );
}