<?php

if ( ! function_exists( 'sahel_elated_get_hide_dep_for_header_standard_meta_boxes' ) ) {
	function sahel_elated_get_hide_dep_for_header_standard_meta_boxes() {
		$hide_dep_options = apply_filters( 'sahel_elated_filter_header_standard_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'sahel_elated_header_standard_meta_map' ) ) {
	function sahel_elated_header_standard_meta_map( $parent ) {
		$hide_dep_options = sahel_elated_get_hide_dep_for_header_standard_meta_boxes();
		
		sahel_elated_create_meta_box_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'eltdf_set_menu_area_position_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Choose Menu Area Position', 'sahel' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'sahel' ),
				'options'         => array(
					''       => esc_html__( 'Default', 'sahel' ),
					'left'   => esc_html__( 'Left', 'sahel' ),
					'right'  => esc_html__( 'Right', 'sahel' ),
					'center' => esc_html__( 'Center', 'sahel' )
				),
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'sahel_elated_action_additional_header_area_meta_boxes_map', 'sahel_elated_header_standard_meta_map' );
}