<?php

if ( ! function_exists( 'sahel_elated_register_header_minimal_type' ) ) {
	/**
	 * This function is used to register header type class for header factory file
	 */
	function sahel_elated_register_header_minimal_type( $header_types ) {
		$header_type = array(
			'header-minimal' => 'SahelElatedNamespace\Modules\Header\Types\HeaderMinimal'
		);
		
		$header_types = array_merge( $header_types, $header_type );
		
		return $header_types;
	}
}

if ( ! function_exists( 'sahel_elated_init_register_header_minimal_type' ) ) {
	/**
	 * This function is used to wait header-function.php file to init header object and then to init hook registration function above
	 */
	function sahel_elated_init_register_header_minimal_type() {
		add_filter( 'sahel_elated_filter_register_header_type_class', 'sahel_elated_register_header_minimal_type' );
	}
	
	add_action( 'sahel_elated_action_before_header_function_init', 'sahel_elated_init_register_header_minimal_type' );
}

if ( ! function_exists( 'sahel_elated_include_header_minimal_full_screen_menu' ) ) {
	/**
	 * Registers additional menu navigation for theme
	 */
	function sahel_elated_include_header_minimal_full_screen_menu( $menus ) {
		$menus['popup-navigation'] = esc_html__( 'Full Screen Navigation', 'sahel' );
		
		return $menus;
	}
	
	if ( sahel_elated_check_is_header_type_enabled( 'header-minimal' ) ) {
		add_filter( 'sahel_elated_filter_register_headers_menu', 'sahel_elated_include_header_minimal_full_screen_menu' );
	}
}

if ( ! function_exists( 'sahel_elated_get_fullscreen_menu_icon_class' ) ) {
	/**
	 * Loads full screen menu icon class
	 */
	function sahel_elated_get_fullscreen_menu_icon_class() {
		$classes = array(
			'eltdf-fullscreen-menu-opener'
		);
		
		$classes[] = sahel_elated_get_icon_sources_class( 'fullscreen_menu', 'eltdf-fullscreen-menu-opener' );
		
		return $classes;
	}
}

if ( ! function_exists( 'sahel_elated_header_minimal_per_page_custom_styles' ) ) {
	/**
	 * Return header per page styles
	 */
	function sahel_elated_header_minimal_per_page_custom_styles( $style, $class_prefix, $page_id ) {
		$icon_holder_style    = array();
		$header_area_selector = array( $class_prefix . '.eltdf-header-minimal.eltdf-minimal-icon-boxed .eltdf-fullscreen-outer-holder' );

		$padding  = get_post_meta( $page_id, 'eltdf_fullscreen_menu_icon_padding_meta', true );
		$background_color  = get_post_meta( $page_id, 'eltdf_fullscreen_menu_icon_box_background_color_meta', true );
		$enable_border = get_post_meta( $page_id, 'eltdf_enable_fullscreen_menu_icon_border_meta', true );
		$border_color = get_post_meta( $page_id, 'eltdf_fullscreen_menu_icon_border_color_meta', true );

		if ( $padding !== '' ) {
			$icon_holder_style['padding'] = $padding;
		}

		if ( $background_color !== '' ) {
			$icon_holder_style['background-color'] = $background_color;
		}

		if ( $enable_border == 'yes' ) {
			$icon_holder_style['border-left'] = '1px solid';
			$icon_holder_style['border-bottom'] = '1px solid';

			if ( $border_color !== '' ) {
				$icon_holder_style['border-color'] = $border_color;
			} else {
				$icon_holder_style['border-color'] = '#ece8e5';
			}
		} elseif ( $enable_border == 'no' ) {
			$icon_holder_style['border'] = 'none';
		}

		$current_style = '';

		if ( ! empty( $icon_holder_style ) ) {
			$current_style .= sahel_elated_dynamic_css( $header_area_selector, $icon_holder_style );
		}

		$current_style = $current_style . $style;

		return $current_style;
	}

	add_filter( 'sahel_elated_filter_add_header_page_custom_style', 'sahel_elated_header_minimal_per_page_custom_styles', 10, 3 );
}