<?php

if ( ! function_exists( 'sahel_elated_get_hide_dep_for_full_screen_menu_options' ) ) {
	function sahel_elated_get_hide_dep_for_full_screen_menu_options() {
		$hide_dep_options = apply_filters( 'sahel_elated_filter_full_screen_menu_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'sahel_elated_fullscreen_menu_options_map' ) ) {
	function sahel_elated_fullscreen_menu_options_map() {
		$hide_dep_options = sahel_elated_get_hide_dep_for_full_screen_menu_options();
		
		$fullscreen_panel = sahel_elated_add_admin_panel(
			array(
				'title'           => esc_html__( 'Full Screen Menu', 'sahel' ),
				'name'            => 'panel_fullscreen_menu',
				'page'            => '_header_page',
				'dependency' => array(
					'hide' => array(
						'header_options'  => $hide_dep_options
					)
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $fullscreen_panel,
				'type'          => 'select',
				'name'          => 'fullscreen_menu_animation_style',
				'default_value' => 'fade-push-text-right',
				'label'         => esc_html__( 'Full Screen Menu Overlay Animation', 'sahel' ),
				'description'   => esc_html__( 'Choose animation type for full screen menu overlay', 'sahel' ),
				'options'       => array(
					'fade-push-text-right' => esc_html__( 'Fade Push Text Right', 'sahel' ),
					'fade-push-text-top'   => esc_html__( 'Fade Push Text Top', 'sahel' ),
					'fade-text-scaledown'  => esc_html__( 'Fade Text Scaledown', 'sahel' )
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $fullscreen_panel,
				'type'          => 'yesno',
				'name'          => 'fullscreen_in_grid',
				'default_value' => 'no',
				'label'         => esc_html__( 'Full Screen Menu in Grid', 'sahel' ),
				'description'   => esc_html__( 'Enabling this option will put full screen menu content in grid', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $fullscreen_panel,
				'type'          => 'selectblank',
				'name'          => 'fullscreen_alignment',
				'default_value' => '',
				'label'         => esc_html__( 'Full Screen Menu Alignment', 'sahel' ),
				'description'   => esc_html__( 'Choose alignment for full screen menu content', 'sahel' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'sahel' ),
					'left'   => esc_html__( 'Left', 'sahel' ),
					'center' => esc_html__( 'Center', 'sahel' ),
					'right'  => esc_html__( 'Right', 'sahel' )
				)
			)
		);
		
		$background_group = sahel_elated_add_admin_group(
			array(
				'parent'      => $fullscreen_panel,
				'name'        => 'background_group',
				'title'       => esc_html__( 'Background', 'sahel' ),
				'description' => esc_html__( 'Select a background color and transparency for full screen menu (0 = fully transparent, 1 = opaque)', 'sahel' )
			)
		);
		
		$background_group_row = sahel_elated_add_admin_row(
			array(
				'parent' => $background_group,
				'name'   => 'background_group_row'
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent' => $background_group_row,
				'type'   => 'colorsimple',
				'name'   => 'fullscreen_menu_background_color',
				'label'  => esc_html__( 'Background Color', 'sahel' )
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent' => $background_group_row,
				'type'   => 'textsimple',
				'name'   => 'fullscreen_menu_background_transparency',
				'label'  => esc_html__( 'Background Transparency', 'sahel' )
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'      => $fullscreen_panel,
				'type'        => 'image',
				'name'        => 'fullscreen_menu_background_image',
				'label'       => esc_html__( 'Background Image', 'sahel' ),
				'description' => esc_html__( 'Choose a background image for full screen menu background', 'sahel' )
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'      => $fullscreen_panel,
				'type'        => 'image',
				'name'        => 'fullscreen_menu_pattern_image',
				'label'       => esc_html__( 'Pattern Background Image', 'sahel' ),
				'description' => esc_html__( 'Choose a pattern image for full screen menu background', 'sahel' )
			)
		);
		
		//1st level style group
		$first_level_style_group = sahel_elated_add_admin_group(
			array(
				'parent'      => $fullscreen_panel,
				'name'        => 'first_level_style_group',
				'title'       => esc_html__( '1st Level Style', 'sahel' ),
				'description' => esc_html__( 'Define styles for 1st level in full screen menu', 'sahel' )
			)
		);
		
		$first_level_style_row1 = sahel_elated_add_admin_row(
			array(
				'parent' => $first_level_style_group,
				'name'   => 'first_level_style_row1'
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $first_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_color',
				'default_value' => '',
				'label'         => esc_html__( 'Text Color', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $first_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_hover_color',
				'default_value' => '',
				'label'         => esc_html__( 'Hover Text Color', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $first_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_active_color',
				'default_value' => '',
				'label'         => esc_html__( 'Active Text Color', 'sahel' ),
			)
		);
		
		$first_level_style_row3 = sahel_elated_add_admin_row(
			array(
				'parent' => $first_level_style_group,
				'name'   => 'first_level_style_row3'
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $first_level_style_row3,
				'type'          => 'fontsimple',
				'name'          => 'fullscreen_menu_google_fonts',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $first_level_style_row3,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_font_size',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'sahel' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $first_level_style_row3,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_line_height',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'sahel' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$first_level_style_row4 = sahel_elated_add_admin_row(
			array(
				'parent' => $first_level_style_group,
				'name'   => 'first_level_style_row4'
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $first_level_style_row4,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_font_style',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'sahel' ),
				'options'       => sahel_elated_get_font_style_array()
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $first_level_style_row4,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_font_weight',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'sahel' ),
				'options'       => sahel_elated_get_font_weight_array()
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $first_level_style_row4,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_letter_spacing',
				'default_value' => '',
				'label'         => esc_html__( 'Lettert Spacing', 'sahel' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $first_level_style_row4,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_text_transform',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'sahel' ),
				'options'       => sahel_elated_get_text_transform_array()
			)
		);
		
		//2nd level style group
		$second_level_style_group = sahel_elated_add_admin_group(
			array(
				'parent'      => $fullscreen_panel,
				'name'        => 'second_level_style_group',
				'title'       => esc_html__( '2nd Level Style', 'sahel' ),
				'description' => esc_html__( 'Define styles for 2nd level in full screen menu', 'sahel' )
			)
		);
		
		$second_level_style_row1 = sahel_elated_add_admin_row(
			array(
				'parent' => $second_level_style_group,
				'name'   => 'second_level_style_row1'
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $second_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_color_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Text Color', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $second_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_hover_color_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Hover/Active Text Color', 'sahel' ),
			)
		);
		
		$second_level_style_row2 = sahel_elated_add_admin_row(
			array(
				'parent' => $second_level_style_group,
				'name'   => 'second_level_style_row2'
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $second_level_style_row2,
				'type'          => 'fontsimple',
				'name'          => 'fullscreen_menu_google_fonts_2nd',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $second_level_style_row2,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_font_size_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'sahel' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $second_level_style_row2,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_line_height_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'sahel' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$second_level_style_row3 = sahel_elated_add_admin_row(
			array(
				'parent' => $second_level_style_group,
				'name'   => 'second_level_style_row3'
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $second_level_style_row3,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_font_style_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'sahel' ),
				'options'       => sahel_elated_get_font_style_array()
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $second_level_style_row3,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_font_weight_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'sahel' ),
				'options'       => sahel_elated_get_font_weight_array()
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $second_level_style_row3,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_letter_spacing_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Lettert Spacing', 'sahel' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $second_level_style_row3,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_text_transform_2nd',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'sahel' ),
				'options'       => sahel_elated_get_text_transform_array()
			)
		);
		
		$third_level_style_group = sahel_elated_add_admin_group(
			array(
				'parent'      => $fullscreen_panel,
				'name'        => 'third_level_style_group',
				'title'       => esc_html__( '3rd Level Style', 'sahel' ),
				'description' => esc_html__( 'Define styles for 3rd level in full screen menu', 'sahel' )
			)
		);
		
		$third_level_style_row1 = sahel_elated_add_admin_row(
			array(
				'parent' => $third_level_style_group,
				'name'   => 'third_level_style_row1'
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $third_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_color_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Text Color', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $third_level_style_row1,
				'type'          => 'colorsimple',
				'name'          => 'fullscreen_menu_hover_color_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Hover/Active Text Color', 'sahel' ),
			)
		);
		
		$third_level_style_row2 = sahel_elated_add_admin_row(
			array(
				'parent' => $third_level_style_group,
				'name'   => 'second_level_style_row2'
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $third_level_style_row2,
				'type'          => 'fontsimple',
				'name'          => 'fullscreen_menu_google_fonts_3rd',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $third_level_style_row2,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_font_size_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'sahel' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $third_level_style_row2,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_line_height_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'sahel' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$third_level_style_row3 = sahel_elated_add_admin_row(
			array(
				'parent' => $third_level_style_group,
				'name'   => 'second_level_style_row3'
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $third_level_style_row3,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_font_style_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'sahel' ),
				'options'       => sahel_elated_get_font_style_array()
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $third_level_style_row3,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_font_weight_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'sahel' ),
				'options'       => sahel_elated_get_font_weight_array()
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $third_level_style_row3,
				'type'          => 'textsimple',
				'name'          => 'fullscreen_menu_letter_spacing_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Lettert Spacing', 'sahel' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $third_level_style_row3,
				'type'          => 'selectblanksimple',
				'name'          => 'fullscreen_menu_text_transform_3rd',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'sahel' ),
				'options'       => sahel_elated_get_text_transform_array()
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $fullscreen_panel,
				'type'          => 'select',
				'name'          => 'fullscreen_menu_icon_source',
				'default_value' => 'icon_pack',
				'label'         => esc_html__( 'Select Full Screen Menu Icon Source', 'sahel' ),
				'description'   => esc_html__( 'Choose whether you would like to use icons from an icon pack or SVG icons', 'sahel' ),
				'options'       => sahel_elated_get_icon_sources_array()
			)
		);

		$fullscreen_menu_icon_pack_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $fullscreen_panel,
				'name'            => 'fullscreen_menu_icon_pack_container',
				'dependency' => array(
					'show' => array(
						'fullscreen_menu_icon_source' => 'icon_pack'
					)
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $fullscreen_menu_icon_pack_container,
				'type'          => 'select',
				'name'          => 'fullscreen_menu_icon_pack',
				'default_value' => 'font_elegant',
				'label'         => esc_html__( 'Full Screen Menu Icon Pack', 'sahel' ),
				'description'   => esc_html__( 'Choose icon pack for full screen menu icon', 'sahel' ),
				'options'       => sahel_elated_icon_collections()->getIconCollectionsExclude( array( 'linea_icons', 'dripicons', 'simple_line_icons' ) )
			)
		);

		$fullscreen_menu_icon_svg_path_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $fullscreen_panel,
				'name'            => 'fullscreen_menu_icon_svg_path_container',
				'dependency' => array(
					'show' => array(
						'fullscreen_menu_icon_source' => 'svg_path'
					)
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'      => $fullscreen_menu_icon_svg_path_container,
				'type'        => 'textarea',
				'name'        => 'fullscreen_menu_icon_svg_path',
				'label'       => esc_html__( 'Full Screen Menu Icon SVG Path', 'sahel' ),
				'description' => esc_html__( 'Enter your full screen menu icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'sahel' ),
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'      => $fullscreen_menu_icon_svg_path_container,
				'type'        => 'textarea',
				'name'        => 'fullscreen_menu_close_icon_svg_path',
				'label'       => esc_html__( 'Full Screen Menu Close Icon SVG Path', 'sahel' ),
				'description' => esc_html__( 'Enter your full screen menu close icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'sahel' ),
			)
		);

		$icon_style_group = sahel_elated_add_admin_group(
			array(
				'parent'      => $fullscreen_panel,
				'name'        => 'fullscreen_menu_icon_style_group',
				'title'       => esc_html__( 'Full Screen Menu Icon Style', 'sahel' ),
				'description' => esc_html__( 'Define styles for full screen menu icon', 'sahel' )
			)
		);
		
		$icon_colors_row1 = sahel_elated_add_admin_row(
			array(
				'parent' => $icon_style_group,
				'name'   => 'icon_colors_row1'
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent' => $icon_colors_row1,
				'type'   => 'colorsimple',
				'name'   => 'fullscreen_menu_icon_color',
				'label'  => esc_html__( 'Color', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent' => $icon_colors_row1,
				'type'   => 'colorsimple',
				'name'   => 'fullscreen_menu_icon_hover_color',
				'label'  => esc_html__( 'Hover Color', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent' => $icon_colors_row1,
				'type'   => 'colorsimple',
				'name'   => 'fullscreen_menu_icon_mobile_color',
				'label'  => esc_html__( 'Mobile Color', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent' => $icon_colors_row1,
				'type'   => 'colorsimple',
				'name'   => 'fullscreen_menu_icon_mobile_hover_color',
				'label'  => esc_html__( 'Mobile Hover Color', 'sahel' ),
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent' => $fullscreen_panel,
				'type'   => 'yesno',
				'default_value' => 'yes',
				'name'   => 'enable_fullscreen_menu_icon_boxed',
				'label'  => esc_html__( 'Enable Fullscreen Menu Icon in Box', 'sahel' ),
			)
		);


		$icon_box_widget_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $fullscreen_panel,
				'name'            => 'icon_box_widget_container',
				'dependency'	=> array(
					'show' => array(
						'enable_fullscreen_menu_icon_boxed' => 'yes',
					)
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $icon_box_widget_container,
				'type'          => 'text',
				'name'          => 'fullscreen_menu_icon_padding',
				'default_value' => '',
				'label'         => esc_html__( 'Icon Padding', 'sahel' ),
				'description'   => esc_html__( 'Enter icon padding in 20px 0 10px format. Default padding is 0 31px', 'sahel' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $icon_box_widget_container,
				'type'          => 'color',
				'name'          => 'fullscreen_menu_icon_box_background_color',
				'default_value' => '',
				'label'         => esc_html__( 'Icon Boxed Background Color', 'sahel' ),
				'description'   => esc_html__( 'Choose background color', 'sahel' )
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $icon_box_widget_container,
				'type'          => 'yesno',
				'name'          => 'enable_fullscreen_menu_icon_border',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Border on Icon Boxed', 'sahel' ),
				'description'   => esc_html__( 'Enable this option to show border', 'sahel' )
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $icon_box_widget_container,
				'type'          => 'color',
				'name'          => 'fullscreen_menu_icon_border_color',
				'default_value' => '',
				'label'         => esc_html__( 'Icon Border Color', 'sahel' ),
				'description'   => esc_html__( 'Choose border color', 'sahel' ),
				'dependency'	=> array(
					'show' => array(
						'enable_fullscreen_menu_icon_border' => 'yes'
					)
				)
			)
		);
	}
	
	add_action( 'sahel_elated_action_additional_header_menu_area_options_map', 'sahel_elated_fullscreen_menu_options_map' );
}