<?php

if ( ! function_exists( 'sahel_elated_get_hide_dep_for_header_minimal_meta_boxes' ) ) {
	function sahel_elated_get_hide_dep_for_header_minimal_meta_boxes() {
		$hide_dep_options = apply_filters( 'sahel_elated_filter_header_minimal_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'sahel_elated_header_minimal_meta_map' ) ) {
	function sahel_elated_header_minimal_meta_map( $parent ) {
		$hide_dep_options = sahel_elated_get_hide_dep_for_header_minimal_meta_boxes();

		sahel_elated_create_meta_box_field(
			array(
				'parent' => $parent,
				'type'   => 'select',
				'default_value' => '',
				'name'   => 'eltdf_enable_fullscreen_menu_icon_boxed_meta',
				'label'  => esc_html__( 'Enable Fullscreen Menu Icon in Box', 'sahel' ),
				'options'       => sahel_elated_get_yes_no_select_array(),
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);


		$icon_box_widget_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $parent,
				'name'            => 'icon_box_widget_container',
				'dependency'	=> array(
					'show' => array(
						'eltdf_enable_fullscreen_menu_icon_boxed_meta' => 'yes',
						'eltdf_header_type_meta' => 'header-minimal',
					)
				)
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $icon_box_widget_container,
				'type'          => 'text',
				'name'          => 'eltdf_fullscreen_menu_icon_padding_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Icon Padding', 'sahel' ),
				'description'   => esc_html__( 'Enter icon padding in 20px 0 10px format. Default padding is 0 31px', 'sahel' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $icon_box_widget_container,
				'type'          => 'color',
				'name'          => 'eltdf_fullscreen_menu_icon_box_background_color_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Icon Boxed Background Color', 'sahel' ),
				'description'   => esc_html__( 'Choose background color', 'sahel' )
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $icon_box_widget_container,
				'type'          => 'select',
				'name'          => 'eltdf_enable_fullscreen_menu_icon_border_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Border on Icon Boxed', 'sahel' ),
				'description'   => esc_html__( 'Enable this option to show border', 'sahel' ),
				'options'       => sahel_elated_get_yes_no_select_array(),
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $icon_box_widget_container,
				'type'          => 'color',
				'name'          => 'eltdf_fullscreen_menu_icon_border_color_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Icon Border Color', 'sahel' ),
				'description'   => esc_html__( 'Choose border color', 'sahel' ),
				'dependency'	=> array(
					'show' => array(
						'eltdf_enable_fullscreen_menu_icon_border_meta' => 'yes'
					)
				)
			)
		);
	}
	
	add_action( 'sahel_elated_action_additional_header_area_meta_boxes_map', 'sahel_elated_header_minimal_meta_map' );
}