<?php

if ( ! function_exists( 'sahel_elated_get_hide_dep_for_header_menu_area_options' ) ) {
	function sahel_elated_get_hide_dep_for_header_menu_area_options() {
		$hide_dep_options = apply_filters( 'sahel_elated_filter_header_menu_area_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'sahel_elated_header_menu_area_options_map' ) ) {
	function sahel_elated_header_menu_area_options_map( $panel_header ) {
		$hide_dep_options = sahel_elated_get_hide_dep_for_header_menu_area_options();
		
		$menu_area_container = sahel_elated_add_admin_container_no_style(
			array(
				'parent'          => $panel_header,
				'name'            => 'menu_area_container',
				'dependency' => array(
					'hide' => array(
						'header_options'  => $hide_dep_options
					)
				),
			)
		);
		
		sahel_elated_add_admin_section_title(
			array(
				'parent' => $menu_area_container,
				'name'   => 'menu_area_style',
				'title'  => esc_html__( 'Menu Area Style', 'sahel' )
			)
		);

		/*Border type*/

		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_border_type',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Menu Area Bordered Type', 'sahel' ),
				'description'   => esc_html__( 'Set menu area to be bordered type', 'sahel' ),
			)
		);

		$menu_area_border_type_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $menu_area_container,
				'name'            => 'menu_area_border_type_container',
				'dependency'	=> array(
					'show' => array(
						'menu_area_border_type' => 'yes'
					)
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_border_type_container,
				'type'          => 'text',
				'name'          => 'logo_padding',
				'default_value' => '',
				'label'         => esc_html__( 'Logo Padding', 'sahel' ),
				'description'   => esc_html__( 'Enter logo padding in 20px 0 10px format. Default padding is 0 44px', 'sahel' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_border_type_container,
				'type'          => 'yesno',
				'name'          => 'enable_logo_border',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Border on Logo', 'sahel' ),
				'description'   => esc_html__( 'Enable this option to show border on logo', 'sahel' ),
				'dependency'	=> array(
					'show' => array(
						'menu_area_border_type' => 'yes'
					)
				)
			)
		);

		$logo_border_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $menu_area_border_type_container,
				'name'            => 'logo_border_container',
				'dependency'	=> array(
					'show' => array(
						'enable_logo_border' => 'yes'
					)
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $logo_border_container,
				'type'          => 'color',
				'name'          => 'logo_border_color',
				'default_value' => '',
				'label'         => esc_html__( 'Logo Border Color', 'sahel' ),
				'description'   => esc_html__( 'Choose border color', 'sahel' ),
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_border_type_container,
				'type'          => 'yesno',
				'name'          => 'enable_last_widget_boxed',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Box on Last Widget', 'sahel' ),
				'description'   => esc_html__( 'Enable this option to place last widget in widget area one in box', 'sahel' ),
				'dependency'	=> array(
					'show' => array(
						'menu_area_border_type' => 'yes',
						'header_options' => array('','header-standard')
					)
				)
			)
		);

		$box_widget_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $menu_area_container,
				'name'            => 'box_widget_container',
				'dependency'	=> array(
					'show' => array(
						'enable_last_widget_boxed' => 'yes',
						'header_options' => array('','header-standard')
					)
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $box_widget_container,
				'type'          => 'text',
				'name'          => 'last_widget_box_padding',
				'default_value' => '',
				'label'         => esc_html__( 'Widget Padding', 'sahel' ),
				'description'   => esc_html__( 'Enter widget in 20px 0 10px format. Default padding is 0 35px', 'sahel' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $box_widget_container,
				'type'          => 'color',
				'name'          => 'last_widget_box_background_color',
				'default_value' => '',
				'label'         => esc_html__( 'Widget Background Color', 'sahel' ),
				'description'   => esc_html__( 'Choose background color', 'sahel' )
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $box_widget_container,
				'type'          => 'yesno',
				'name'          => 'enable_last_widget_border',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Border on Last Widget', 'sahel' ),
				'description'   => esc_html__( 'Enable this option to show border on last widget in widget area one', 'sahel' )
			)
		);

		sahel_elated_add_admin_field(
			array(
				'parent'        => $box_widget_container,
				'type'          => 'color',
				'name'          => 'last_widget_border_color',
				'default_value' => '',
				'label'         => esc_html__( 'Widget Border Color', 'sahel' ),
				'description'   => esc_html__( 'Choose border color', 'sahel' ),
				'dependency'	=> array(
					'show' => array(
						'enable_last_widget_border' => 'yes'
					)
				)
			)
		);

		/*Bordered type - end*/

		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_in_grid',
				'default_value' => 'no',
				'label'         => esc_html__( 'Menu Area In Grid', 'sahel' ),
				'description'   => esc_html__( 'Set menu area content to be in grid', 'sahel' ),
				'dependency'	=> array(
					'hide' => array(
						'menu_area_border_type' => 'yes'
					)
				)
			)
		);
		
		$menu_area_in_grid_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $menu_area_container,
				'name'            => 'menu_area_in_grid_container',
				'dependency' => array(
					'hide' => array(
						'menu_area_in_grid'  => 'no'
					)
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_container,
				'type'          => 'color',
				'name'          => 'menu_area_grid_background_color',
				'default_value' => '',
				'label'         => esc_html__( 'Grid Background Color', 'sahel' ),
				'description'   => esc_html__( 'Set grid background color for menu area', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_container,
				'type'          => 'text',
				'name'          => 'menu_area_grid_background_transparency',
				'default_value' => '',
				'label'         => esc_html__( 'Grid Background Transparency', 'sahel' ),
				'description'   => esc_html__( 'Set grid background transparency for menu area', 'sahel' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_in_grid_shadow',
				'default_value' => 'no',
				'label'         => esc_html__( 'Grid Area Shadow', 'sahel' ),
				'description'   => esc_html__( 'Set shadow on grid area', 'sahel' )
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_in_grid_border',
				'default_value' => 'no',
				'label'         => esc_html__( 'Grid Area Border', 'sahel' ),
				'description'   => esc_html__( 'Set border on grid area', 'sahel' )
			)
		);
		
		$menu_area_in_grid_border_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $menu_area_in_grid_container,
				'name'            => 'menu_area_in_grid_border_container',
				'dependency' => array(
					'hide' => array(
						'menu_area_in_grid_border'  => 'no'
					)
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_border_container,
				'type'          => 'color',
				'name'          => 'menu_area_in_grid_border_color',
				'default_value' => '',
				'label'         => esc_html__( 'Border Color', 'sahel' ),
				'description'   => esc_html__( 'Set border color for menu area', 'sahel' ),
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'color',
				'name'          => 'menu_area_background_color',
				'default_value' => '',
				'label'         => esc_html__( 'Background Color', 'sahel' ),
				'description'   => esc_html__( 'Set background color for menu area', 'sahel' )
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'text',
				'name'          => 'menu_area_background_transparency',
				'default_value' => '',
				'label'         => esc_html__( 'Background Transparency', 'sahel' ),
				'description'   => esc_html__( 'Set background transparency for menu area', 'sahel' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_shadow',
				'default_value' => 'no',
				'label'         => esc_html__( 'Menu Area Shadow', 'sahel' ),
				'description'   => esc_html__( 'Set shadow on menu area', 'sahel' ),
				'dependency'	=> array(
					'hide' => array(
						'menu_area_border_type' => 'yes'
					)
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'menu_area_border',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Menu Area Border', 'sahel' ),
				'description'   => esc_html__( 'Set border on menu area', 'sahel' ),
				'parent'        => $menu_area_container
			)
		);
		
		$menu_area_border_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $menu_area_container,
				'name'            => 'menu_area_border_container',
				'dependency' => array(
					'hide' => array(
						'menu_area_border'  => 'no'
					)
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'type'        => 'color',
				'name'        => 'menu_area_border_color',
				'label'       => esc_html__( 'Border Color', 'sahel' ),
				'description' => esc_html__( 'Set border color for menu area', 'sahel' ),
				'parent'      => $menu_area_border_container
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'type'        => 'text',
				'name'        => 'menu_area_height',
				'label'       => esc_html__( 'Height', 'sahel' ),
				'description' => esc_html__( 'Enter header height', 'sahel' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'type'   => 'text',
				'name'   => 'menu_area_side_padding',
				'label'  => esc_html__( 'Menu Area Side Padding', 'sahel' ),
				'parent' => $menu_area_container,
				'args'   => array(
					'col_width' => 2,
					'suffix'    => esc_html__( 'px or %', 'sahel' )
				),
				'dependency'	=> array(
					'hide' => array(
						'menu_area_border_type' => 'yes'
					)
				)
			)
		);
		
		do_action( 'sahel_elated_header_menu_area_additional_options', $panel_header );
	}
	
	add_action( 'sahel_elated_action_header_menu_area_options_map', 'sahel_elated_header_menu_area_options_map', 10, 1 );
}