<?php

if ( ! function_exists( 'sahel_elated_logo_options_map' ) ) {
	function sahel_elated_logo_options_map() {
		
		sahel_elated_add_admin_page(
			array(
				'slug'  => '_logo_page',
				'title' => esc_html__( 'Logo', 'sahel' ),
				'icon'  => 'fa fa-coffee'
			)
		);
		
		$panel_logo = sahel_elated_add_admin_panel(
			array(
				'page'  => '_logo_page',
				'name'  => 'panel_logo',
				'title' => esc_html__( 'Logo', 'sahel' )
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'parent'        => $panel_logo,
				'type'          => 'yesno',
				'name'          => 'hide_logo',
				'default_value' => 'no',
				'label'         => esc_html__( 'Hide Logo', 'sahel' ),
				'description'   => esc_html__( 'Enabling this option will hide logo image', 'sahel' )
			)
		);
		
		$hide_logo_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $panel_logo,
				'name'            => 'hide_logo_container',
				'dependency' => array(
					'hide' => array(
						'hide_logo'  => 'yes'
					)
				)
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'name'          => 'logo_image',
				'type'          => 'image',
				'default_value' => ELATED_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Default', 'sahel' ),
				'parent'        => $hide_logo_container
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'name'          => 'logo_image_dark',
				'type'          => 'image',
				'default_value' => ELATED_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Dark', 'sahel' ),
				'parent'        => $hide_logo_container
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'name'          => 'logo_image_light',
				'type'          => 'image',
				'default_value' => ELATED_ASSETS_ROOT . "/img/logo_white.png",
				'label'         => esc_html__( 'Logo Image - Light', 'sahel' ),
				'parent'        => $hide_logo_container
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'name'          => 'logo_image_sticky',
				'type'          => 'image',
				'default_value' => ELATED_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Sticky', 'sahel' ),
				'parent'        => $hide_logo_container
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'name'          => 'logo_image_mobile',
				'type'          => 'image',
				'default_value' => ELATED_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Mobile', 'sahel' ),
				'parent'        => $hide_logo_container
			)
		);
	}
	
	add_action( 'sahel_elated_action_options_map', 'sahel_elated_logo_options_map', sahel_elated_set_options_map_position( 'logo' ) );
}