<?php

if ( ! function_exists( 'sahel_elated_get_hide_dep_for_header_menu_area_meta_boxes' ) ) {
	function sahel_elated_get_hide_dep_for_header_menu_area_meta_boxes() {
		$hide_dep_options = apply_filters( 'sahel_elated_filter_header_menu_area_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'sahel_elated_header_menu_area_meta_options_map' ) ) {
	function sahel_elated_header_menu_area_meta_options_map( $header_meta_box ) {
		$hide_dep_options = sahel_elated_get_hide_dep_for_header_menu_area_meta_boxes();
		
		$menu_area_container = sahel_elated_add_admin_container_no_style(
			array(
				'type'       => 'container',
				'name'       => 'menu_area_container',
				'parent'     => $header_meta_box,
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta' => $hide_dep_options
					)
				),
				'args'       => array(
					'enable_panels_for_default_value' => true
				)
			)
		);
		
		sahel_elated_add_admin_section_title(
			array(
				'parent' => $menu_area_container,
				'name'   => 'menu_area_style',
				'title'  => esc_html__( 'Menu Area Style', 'sahel' )
			)
		);
		
		/* Bordered type*/

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'select',
				'name'          => 'eltdf_menu_area_border_type_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Menu Area Bordered Type', 'sahel' ),
				'description'   => esc_html__( 'Set menu area to be bordered type', 'sahel' ),
				'options'       => sahel_elated_get_yes_no_select_array()
			)
		);

		$menu_area_border_type_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $menu_area_container,
				'name'            => 'menu_area_border_type_container',
				'dependency'	=> array(
					'show' => array(
						'eltdf_menu_area_border_type_meta' => 'yes'
					)
				)
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $menu_area_border_type_container,
				'type'          => 'text',
				'name'          => 'eltdf_logo_padding_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Logo Padding', 'sahel' ),
				'description'   => esc_html__( 'Enter logo padding in 20px 0 10px format. Default padding is 0 44px', 'sahel' ),
				'args'          => array(
					'col_width' => 3
				),
				'dependency'	=> array(
					'show' => array(
						'eltdf_menu_area_border_type_meta' => 'yes'
					)
				)
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $menu_area_border_type_container,
				'type'          => 'select',
				'name'          => 'eltdf_enable_logo_border_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Border on Logo', 'sahel' ),
				'description'   => esc_html__( 'Enable this option to show border on logo', 'sahel' ),
				'dependency'	=> array(
					'show' => array(
						'eltdf_menu_area_border_type_meta' => 'yes'
					)
				),
				'options'       => sahel_elated_get_yes_no_select_array()
			)
		);

		$logo_border_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $menu_area_border_type_container,
				'name'            => 'logo_border_container',
				'dependency'	=> array(
					'show' => array(
						'eltdf_enable_logo_border_meta' => 'yes'
					)
				)
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $logo_border_container,
				'type'          => 'color',
				'name'          => 'eltdf_logo_border_color_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Logo Border Color', 'sahel' ),
				'description'   => esc_html__( 'Choose border color', 'sahel' ),
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $menu_area_border_type_container,
				'type'          => 'select',
				'name'          => 'eltdf_enable_last_widget_boxed_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Box on Last Widget', 'sahel' ),
				'description'   => esc_html__( 'Enable this option to place last widget in widget area one in box', 'sahel' ),
				'dependency'	=> array(
					'show' => array(
						'eltdf_menu_area_border_type_meta' => 'yes',
						'eltdf_header_type_meta' => array('','header-standard')
					)
				),
				'options'       => sahel_elated_get_yes_no_select_array()
			)
		);

		$box_widget_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $menu_area_container,
				'name'            => 'box_widget_container',
				'dependency'	=> array(
					'show' => array(
						'eltdf_enable_last_widget_boxed_meta' => 'yes',
						'eltdf_header_type_meta' => array('','header-standard')
					)
				)
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $box_widget_container,
				'type'          => 'text',
				'name'          => 'eltdf_last_widget_box_padding_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Widget Padding', 'sahel' ),
				'description'   => esc_html__( 'Enter widget in 20px 0 10px format. Default padding is 0 35px', 'sahel' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $box_widget_container,
				'type'          => 'color',
				'name'          => 'eltdf_last_widget_box_background_color_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Widget Background Color', 'sahel' ),
				'description'   => esc_html__( 'Choose background color', 'sahel' )
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $box_widget_container,
				'type'          => 'select',
				'name'          => 'eltdf_enable_last_widget_border_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Border on Last Widget', 'sahel' ),
				'description'   => esc_html__( 'Enable this option to show border on last widget in widget area one', 'sahel' ),
				'options'       => sahel_elated_get_yes_no_select_array()
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'parent'        => $box_widget_container,
				'type'          => 'color',
				'name'          => 'eltdf_last_widget_border_color_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Widget Border Color', 'sahel' ),
				'description'   => esc_html__( 'Choose border color', 'sahel' ),
				'dependency'	=> array(
					'show' => array(
						'eltdf_enable_last_widget_border_meta' => 'yes'
					)
				)
			)
		);
		
		/* Bordered type - end*/
		
		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_in_grid_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area In Grid', 'sahel' ),
				'description'   => esc_html__( 'Set menu area content to be in grid', 'sahel' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => sahel_elated_get_yes_no_select_array()
			)
		);
		
		$menu_area_in_grid_container = sahel_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_in_grid_container',
				'parent'          => $menu_area_container,
				'dependency' => array(
					'show' => array(
						'eltdf_menu_area_in_grid_meta'  => 'yes'
					)
				)
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_grid_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Grid Background Color', 'sahel' ),
				'description' => esc_html__( 'Set grid background color for menu area', 'sahel' ),
				'parent'      => $menu_area_in_grid_container
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_grid_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Grid Background Transparency', 'sahel' ),
				'description' => esc_html__( 'Set grid background transparency for menu area (0 = fully transparent, 1 = opaque)', 'sahel' ),
				'parent'      => $menu_area_in_grid_container,
				'args'        => array(
					'col_width' => 2
				)
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_in_grid_shadow_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Grid Area Shadow', 'sahel' ),
				'description'   => esc_html__( 'Set shadow on grid menu area', 'sahel' ),
				'parent'        => $menu_area_in_grid_container,
				'default_value' => '',
				'options'       => sahel_elated_get_yes_no_select_array()
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_in_grid_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Grid Area Border', 'sahel' ),
				'description'   => esc_html__( 'Set border on grid menu area', 'sahel' ),
				'parent'        => $menu_area_in_grid_container,
				'default_value' => '',
				'options'       => sahel_elated_get_yes_no_select_array()
			)
		);
		
		$menu_area_in_grid_border_container = sahel_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_in_grid_border_container',
				'parent'          => $menu_area_in_grid_container,
				'dependency' => array(
					'show' => array(
						'eltdf_menu_area_in_grid_border_meta'  => 'yes'
					)
				)
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_in_grid_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'sahel' ),
				'description' => esc_html__( 'Set border color for grid area', 'sahel' ),
				'parent'      => $menu_area_in_grid_border_container
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'sahel' ),
				'description' => esc_html__( 'Choose a background color for menu area', 'sahel' ),
				'parent'      => $menu_area_container
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Transparency', 'sahel' ),
				'description' => esc_html__( 'Choose a transparency for the menu area background color (0 = fully transparent, 1 = opaque)', 'sahel' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 2
				)
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_shadow_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area Shadow', 'sahel' ),
				'description'   => esc_html__( 'Set shadow on menu area', 'sahel' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => sahel_elated_get_yes_no_select_array()
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_menu_area_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area Border', 'sahel' ),
				'description'   => esc_html__( 'Set border on menu area', 'sahel' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => sahel_elated_get_yes_no_select_array()
			)
		);
		
		$menu_area_border_bottom_color_container = sahel_elated_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_border_bottom_color_container',
				'parent'          => $menu_area_container,
				'dependency' => array(
					'show' => array(
						'eltdf_menu_area_border_meta'  => 'yes'
					)
				)
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'        => 'eltdf_menu_area_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'sahel' ),
				'description' => esc_html__( 'Choose color of header bottom border', 'sahel' ),
				'parent'      => $menu_area_border_bottom_color_container
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'type'        => 'text',
				'name'        => 'eltdf_menu_area_height_meta',
				'label'       => esc_html__( 'Height', 'sahel' ),
				'description' => esc_html__( 'Enter header height', 'sahel' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => esc_html__( 'px', 'sahel' )
				)
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'type'        => 'text',
				'name'        => 'eltdf_menu_area_side_padding_meta',
				'label'       => esc_html__( 'Menu Area Side Padding', 'sahel' ),
				'description' => esc_html__( 'Enter value in px or percentage to define menu area side padding', 'sahel' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => esc_html__( 'px or %', 'sahel' )
				),
				'dependency' => array(
					'hide' => array(
						'eltdf_menu_area_border_type_meta' => 'yes'
					)
				)
			)
		);
		
		do_action( 'sahel_elated_header_menu_area_additional_meta_boxes_map', $menu_area_container );
	}
	
	add_action( 'sahel_elated_action_header_menu_area_meta_boxes_map', 'sahel_elated_header_menu_area_meta_options_map', 10, 1 );
}