<?php

if ( ! function_exists( 'sahel_elated_get_hide_dep_for_header_widget_areas_meta_boxes' ) ) {
	function sahel_elated_get_hide_dep_for_header_widget_areas_meta_boxes() {
		$hide_dep_options = apply_filters( 'sahel_elated_filter_header_widget_areas_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'sahel_elated_get_hide_dep_for_header_widget_area_two_meta_boxes' ) ) {
	function sahel_elated_get_hide_dep_for_header_widget_area_two_meta_boxes() {
		$hide_dep_options = apply_filters( 'sahel_elated_filter_header_widget_area_two_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'sahel_elated_header_widget_areas_meta_options_map' ) ) {
	function sahel_elated_header_widget_areas_meta_options_map( $header_meta_box ) {
		$hide_dep_widgets 			= sahel_elated_get_hide_dep_for_header_widget_areas_meta_boxes();
		$hide_dep_widget_area_two 	= sahel_elated_get_hide_dep_for_header_widget_area_two_meta_boxes();
		
		$header_widget_areas_container = sahel_elated_add_admin_container_no_style(
			array(
				'type'       => 'container',
				'name'       => 'header_widget_areas_container',
				'parent'     => $header_meta_box,
				'dependency' => array(
					'hide' => array(
						'eltdf_header_type_meta' => $hide_dep_widgets
					)
				),
				'args'       => array(
					'enable_panels_for_default_value' => true
				)
			)
		);
		
		sahel_elated_add_admin_section_title(
			array(
				'parent' => $header_widget_areas_container,
				'name'   => 'header_widget_areas',
				'title'  => esc_html__( 'Widget Areas', 'sahel' )
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_disable_header_widget_areas_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Header Widget Areas', 'sahel' ),
				'description'   => esc_html__( 'Enabling this option will hide widget areas from header', 'sahel' ),
				'parent'        => $header_widget_areas_container,
			)
		);

		$header_custom_widget_areas_container = sahel_elated_add_admin_container_no_style(
			array(
				'type'       => 'container',
				'name'       => 'header_custom_widget_areas_container',
				'parent'     => $header_widget_areas_container,
				'dependency' => array(
					'hide' => array(
						'eltdf_disable_header_widget_areas_meta' => 'yes'
					)
				)
			)
		);
					
		$sahel_custom_sidebars = sahel_elated_get_custom_sidebars();
		if ( count( $sahel_custom_sidebars ) > 0 ) {
			sahel_elated_create_meta_box_field(
				array(
					'name'        => 'eltdf_custom_header_widget_area_one_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Custom Header Widget Area One', 'sahel' ),
					'description' => esc_html__( 'Choose custom widget area to display in header widget area one', 'sahel' ),
					'parent'      => $header_custom_widget_areas_container,
					'options'     => $sahel_custom_sidebars
				)
			);
		}

		if ( count( $sahel_custom_sidebars ) > 0 ) {
			sahel_elated_create_meta_box_field(
				array(
					'name'        => 'eltdf_custom_header_widget_area_two_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Custom Header Widget Area Two', 'sahel' ),
					'description' => esc_html__( 'Choose custom widget area to display in header widget area two', 'sahel' ),
					'parent'      => $header_custom_widget_areas_container,
					'options'     => $sahel_custom_sidebars,
					'dependency' => array(
						'hide' => array(
							'eltdf_header_type_meta' => $hide_dep_widget_area_two
						)
					)
				)
			);
		}
		
		do_action( 'sahel_elated_header_widget_areas_additional_meta_boxes_map', $header_widget_areas_container );
	}
	
	add_action( 'sahel_elated_action_header_widget_areas_meta_boxes_map', 'sahel_elated_header_widget_areas_meta_options_map', 10, 1 );
}