<?php

if ( ! function_exists( 'sahel_elated_footer_options_map' ) ) {
	function sahel_elated_footer_options_map() {

		sahel_elated_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'sahel' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);

		$footer_panel = sahel_elated_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'sahel' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);

		sahel_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'sahel' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'sahel' ),
				'parent'        => $footer_panel
			)
		);

        sahel_elated_add_admin_field(
            array(
                'type'          => 'yesno',
                'name'          => 'uncovering_footer',
                'default_value' => 'no',
                'label'         => esc_html__( 'Uncovering Footer', 'sahel' ),
                'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'sahel' ),
                'parent'        => $footer_panel,
            )
        );

		sahel_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'sahel' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'sahel' ),
				'parent'        => $footer_panel,
			)
		);
		
		$show_footer_top_container = sahel_elated_add_admin_container(
			array(
				'name'       => 'show_footer_top_container',
				'parent'     => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_top' => 'yes'
					)
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '3 3 3 3',
				'label'         => esc_html__( 'Footer Top Columns', 'sahel' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'sahel' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3',
                    '3 3 6' => '3 (25% + 25% + 50%)',
					'3 3 3 3' => '4'
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => 'left',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'sahel' ),
				'description'   => esc_html__( 'Text Alignment in Footer Columns', 'sahel' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'sahel' ),
					'left'   => esc_html__( 'Left', 'sahel' ),
					'center' => esc_html__( 'Center', 'sahel' ),
					'right'  => esc_html__( 'Right', 'sahel' )
				),
				'parent'        => $show_footer_top_container,
			)
		);

		sahel_elated_add_admin_field(
			array(
				'name'        => 'footer_top_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'sahel' ),
				'description' => esc_html__( 'Set background color for top footer area', 'sahel' ),
				'parent'      => $show_footer_top_container
			)
		);



		sahel_elated_add_admin_field(
            array(
                'parent'      => $footer_panel,
                'type'        => 'image',
                'name'        => 'footer_background_image',
                'label'       => esc_html__( 'Background Image', 'sahel' ),
                'description' => esc_html__( 'Choose a background image for footer area', 'sahel' )
            )
        );

		sahel_elated_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Bottom', 'sahel' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'sahel' ),
				'parent'        => $footer_panel,
			)
		);

		$show_footer_bottom_container = sahel_elated_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'parent'          => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_bottom'  => 'yes'
					)
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '6 6',
				'label'         => esc_html__( 'Footer Bottom Columns', 'sahel' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'sahel' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3'
				),
				'parent'        => $show_footer_bottom_container,
			)
		);

		sahel_elated_add_admin_field(
			array(
				'name'        => 'footer_bottom_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'sahel' ),
				'description' => esc_html__( 'Set background color for bottom footer area', 'sahel' ),
				'parent'      => $show_footer_bottom_container
			)
		);
	}

	add_action( 'sahel_elated_action_options_map', 'sahel_elated_footer_options_map', sahel_elated_set_options_map_position( 'footer' ) );
}