<?php

if ( ! function_exists( 'sahel_elated_map_footer_meta' ) ) {
	function sahel_elated_map_footer_meta() {
		
		$footer_meta_box = sahel_elated_create_meta_box(
			array(
				'scope' => apply_filters( 'sahel_elated_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'footer_meta' ),
				'title' => esc_html__( 'Footer', 'sahel' ),
				'name'  => 'footer_meta'
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_disable_footer_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Disable Footer for this Page', 'sahel' ),
				'description'   => esc_html__( 'Enabling this option will hide footer on this page', 'sahel' ),
				'options'       => sahel_elated_get_yes_no_select_array(),
				'parent'        => $footer_meta_box
			)
		);
		
		$show_footer_meta_container = sahel_elated_add_admin_container(
			array(
				'name'       => 'eltdf_show_footer_meta_container',
				'parent'     => $footer_meta_box,
				'dependency' => array(
					'hide' => array(
						'eltdf_disable_footer_meta' => 'yes'
					)
				)
			)
		);
		
			sahel_elated_create_meta_box_field(
				array(
					'name'          => 'eltdf_footer_in_grid_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Footer in Grid', 'sahel' ),
					'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'sahel' ),
					'options'       => sahel_elated_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
			
			sahel_elated_create_meta_box_field(
				array(
					'name'          => 'eltdf_uncovering_footer_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Uncovering Footer', 'sahel' ),
					'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'sahel' ),
					'options'       => sahel_elated_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
		
			sahel_elated_create_meta_box_field(
				array(
					'name'          => 'eltdf_show_footer_top_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Footer Top', 'sahel' ),
					'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'sahel' ),
					'options'       => sahel_elated_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
		
			sahel_elated_create_meta_box_field(
				array(
					'name'        => 'eltdf_footer_top_background_color_meta',
					'type'        => 'color',
					'label'       => esc_html__( 'Footer Top Background Color', 'sahel' ),
					'description' => esc_html__( 'Set background color for top footer area', 'sahel' ),
					'parent'      => $show_footer_meta_container,
					'dependency' => array(
						'show' => array(
							'eltdf_show_footer_top_meta' => array( '', 'yes' )
						)
					)
				)
			);
			sahel_elated_create_meta_box_field(
				array(
					'name'        => 'eltdf_footer_background_image_meta',
					'type'        => 'image',
					'label'       => esc_html__( 'Background Image', 'sahel' ),
					'description' => esc_html__( 'Choose a background image for footer area', 'sahel' ),
					'parent'      => $show_footer_meta_container,
					'dependency' => array(
						'show' => array(
							'eltdf_show_footer_top_meta' => array( '', 'yes' )
						)
					)
				)
			);


			
			sahel_elated_create_meta_box_field(
				array(
					'name'          => 'eltdf_show_footer_bottom_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Footer Bottom', 'sahel' ),
					'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'sahel' ),
					'options'       => sahel_elated_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
		
			sahel_elated_create_meta_box_field(
				array(
					'name'        => 'eltdf_footer_bottom_background_color_meta',
					'type'        => 'color',
					'label'       => esc_html__( 'Footer Bottom Background Color', 'sahel' ),
					'description' => esc_html__( 'Set background color for bottom footer area', 'sahel' ),
					'parent'      => $show_footer_meta_container,
					'dependency' => array(
						'show' => array(
							'eltdf_show_footer_bottom_meta' => array( '', 'yes' )
						)
					)
				)
			);
	}
	
	add_action( 'sahel_elated_action_meta_boxes_map', 'sahel_elated_map_footer_meta', 70 );
}