<?php

if ( ! function_exists( 'sahel_elated_footer_top_general_styles' ) ) {
	/**
	 * Generates general custom styles for footer top area
	 */
	function sahel_elated_footer_top_general_styles() {
		$item_styles      = array();
		$background_color = sahel_elated_options()->getOptionValue( 'footer_top_background_color' );
		
		if ( ! empty( $background_color ) ) {
			$item_styles['background-color'] = $background_color;
		}
		
		echo sahel_elated_dynamic_css( '.eltdf-page-footer .eltdf-footer-top-holder', $item_styles );
	}
	
	add_action( 'sahel_elated_action_style_dynamic', 'sahel_elated_footer_top_general_styles' );
}

if ( ! function_exists( 'sahel_elated_footer_bottom_general_styles' ) ) {
	/**
	 * Generates general custom styles for footer bottom area
	 */
	function sahel_elated_footer_bottom_general_styles() {
		$item_styles      = array();
		$background_color = sahel_elated_options()->getOptionValue( 'footer_bottom_background_color' );
		
		if ( ! empty( $background_color ) ) {
			$item_styles['background-color'] = $background_color;
		}
		
		echo sahel_elated_dynamic_css( '.eltdf-page-footer .eltdf-footer-bottom-holder', $item_styles );
	}
	
	add_action( 'sahel_elated_action_style_dynamic', 'sahel_elated_footer_bottom_general_styles' );
}

if( ! function_exists('sahel_elated_footer_background_image')) {
    function sahel_elated_footer_background_image() {
        $footer_image_css = '';
        $background_image = sahel_elated_options()->getOptionValue( 'footer_background_image' );

        if(!empty($background_image)) {
            $footer_image_css = 'url(' . $background_image . ')';
        }

        echo sahel_elated_dynamic_css( '.eltdf-page-footer .eltdf-page-footer-holder-inner', array('background-image' => $footer_image_css));
    }

    add_action( 'sahel_elated_action_style_dynamic', 'sahel_elated_footer_background_image' );
}