<?php

if ( ! function_exists( 'sahel_elated_get_content_side_areas' ) ) {
	/**
	 * Loads content side areas HTML with all needed parameters
	 */
	function sahel_elated_get_content_side_areas() {
		$parameters = array();
		
		//Current page id
		$id = sahel_elated_get_page_id();
		
		//is content bottom area enabled for current page?
		$parameters['content_side_left_area'] = sahel_elated_get_meta_field_intersect( 'enable_content_side_left_area', $id );
		$parameters['content_side_right_area'] = sahel_elated_get_meta_field_intersect( 'enable_content_side_right_area', $id );
		$parameters['rotate_content_side_left_class'] = '';
		$parameters['rotate_content_side_right_class'] = '';

		if ( $parameters['content_side_left_area'] === 'yes' ) {
			
			//Sidebar for content bottom area
			$parameters['content_side_left_area_sidebar'] = sahel_elated_get_meta_field_intersect( 'content_side_left_sidebar_custom_display', $id );
			$rotate_left = sahel_elated_get_meta_field_intersect('content_side_left_rotate', $id);
			if ( $rotate_left !== 'no' ) {
				$parameters['rotate_content_side_left_class'] = 'eltdf-content-side-'.$rotate_left;
			}
		}

		if ( $parameters['content_side_right_area'] === 'yes' ) {

			//Sidebar for content bottom area
			$parameters['content_side_right_area_sidebar'] = sahel_elated_get_meta_field_intersect( 'content_side_right_sidebar_custom_display', $id );
			$rotate_right = sahel_elated_get_meta_field_intersect('content_side_right_rotate', $id);
			if ( $rotate_right !== 'no' ) {
				$parameters['rotate_content_side_right_class'] = 'eltdf-content-side-'.$rotate_right;
			}
		}

		if ( ( isset($parameters['content_side_left_area_sidebar'] ) && is_active_sidebar( $parameters['content_side_left_area_sidebar'] ) ) || ( isset($parameters['content_side_right_area_sidebar'] ) && is_active_sidebar( $parameters['content_side_right_area_sidebar'] ) ) ) {
			sahel_elated_get_module_template_part( 'templates/content-side-area', 'content-side', '', $parameters );
		}
	}
	
	add_action( 'sahel_elated_action_before_footer_content', 'sahel_elated_get_content_side_areas' );
}