(function ($) {
    "use strict";

    var contentSide = {};
    eltdf.modules.contentSide = contentSide;

    contentSide.eltdfOnDocumentReady = eltdfOnDocumentReady;

    $(document).ready(eltdfOnDocumentReady);

	/*
	 All functions to be called on $(document).ready() should be in this function
	 */

    function eltdfOnDocumentReady() {
        eltdfContentSideShowHide();
    }

    function eltdfContentSideShowHide() {
        eltdf.window.scroll(function () {
            var content = $('.eltdf-content').height(),
                contentSpace = content - 200,
                b = $(this).scrollTop(),
                c = $(this).height(),
                d;

            if (b > 0) {
                d = b + c / 2;
            } else {
                d = 1;
            }

            if (d > contentSpace) {
                eltdfContentSideHolder('off');
            } else {
                eltdfContentSideHolder('on');
            }
        });
    }

    function eltdfContentSideHolder(a) {
        var b = $(".eltdf-content-side .eltdf-content-side-holder-outer .eltdf-content-side-holder-inner");
        b.removeClass('off on');
        if (a === 'on') {
            b.addClass('on');
        } else {
            b.addClass('off');
        }
    }

})(jQuery);