<?php

if ( ! function_exists( 'sahel_elated_content_side_options_map' ) ) {
	function sahel_elated_content_side_options_map() {
		
		$panel_content_side = sahel_elated_add_admin_panel(
			array(
				'page'  => '_page_page',
				'name'  => 'panel_content_side',
				'title' => esc_html__( 'Content Side Areas Style', 'sahel' )
			)
		);
		
		sahel_elated_add_admin_field(
			array(
				'name'          => 'enable_content_side_left_area',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Content Side Left Area', 'sahel' ),
				'description'   => esc_html__( 'This option will enable Content Side Left area on pages', 'sahel' ),
				'parent'        => $panel_content_side
			)
		);
		
		$enable_content_side_left_area_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $panel_content_side,
				'name'            => 'enable_content_side_left_area_container',
				'dependency' => array(
					'show' => array(
						'enable_content_side_left_area'  => 'yes'
					)
				)
			)
		);
		
		$sahel_custom_sidebars = sahel_elated_get_custom_sidebars();
		
		sahel_elated_add_admin_field(
			array(
				'type'          => 'selectblank',
				'name'          => 'content_side_left_sidebar_custom_display',
				'default_value' => '',
				'label'         => esc_html__( 'Widget Area to Display', 'sahel' ),
				'description'   => esc_html__( 'Choose a Content Side Left widget area to display', 'sahel' ),
				'options'       => $sahel_custom_sidebars,
				'parent'        => $enable_content_side_left_area_container
			)
		);

		sahel_elated_add_admin_field(
			array(
				'type'          => 'selectblank',
				'name'          => 'content_side_left_rotate',
				'default_value' => '',
				'label'         => esc_html__( 'Rotate Widgets', 'sahel' ),
				'description'   => esc_html__( 'Choose whether to rotate widgets', 'sahel' ),
				'options'       => array(
					'no' => esc_html__('No','sahel'),
					'rotate-left' => esc_html__('Rotate to the left','sahel'),
					'rotate-right' => esc_html__('Rotate to the right','sahel'),
				),
				'parent'        => $enable_content_side_left_area_container
			)
		);

		sahel_elated_add_admin_field(
			array(
				'name'          => 'enable_content_side_right_area',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Content Side Right Area', 'sahel' ),
				'description'   => esc_html__( 'This option will enable Content Side Right area on pages', 'sahel' ),
				'parent'        => $panel_content_side
			)
		);

		$enable_content_side_right_area_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $panel_content_side,
				'name'            => 'enable_content_side_right_area_container',
				'dependency' => array(
					'show' => array(
						'enable_content_side_right_area'  => 'yes'
					)
				)
			)
		);

		sahel_elated_add_admin_field(
			array(
				'type'          => 'selectblank',
				'name'          => 'content_side_right_sidebar_custom_display',
				'default_value' => '',
				'label'         => esc_html__( 'Widget Area to Display', 'sahel' ),
				'description'   => esc_html__( 'Choose a Content Side Right widget area to display', 'sahel' ),
				'options'       => $sahel_custom_sidebars,
				'parent'        => $enable_content_side_right_area_container
			)
		);

		sahel_elated_add_admin_field(
			array(
				'type'          => 'selectblank',
				'name'          => 'content_side_right_rotate',
				'default_value' => '',
				'label'         => esc_html__( 'Rotate Widgets', 'sahel' ),
				'description'   => esc_html__( 'Choose whether to rotate widgets', 'sahel' ),
				'options'       => array(
					'no' => esc_html__('No','sahel'),
					'rotate-left' => esc_html__('Rotate to the left','sahel'),
					'rotate-right' => esc_html__('Rotate to the right','sahel'),
				),
				'parent'        => $enable_content_side_right_area_container
			)
		);
	}
	
	add_action( 'sahel_elated_action_additional_page_options_map', 'sahel_elated_content_side_options_map' );
}