<?php

if ( ! function_exists( 'sahel_elated_map_content_side_meta' ) ) {
	function sahel_elated_map_content_side_meta() {
		
		$content_side_meta_box = sahel_elated_create_meta_box(
			array(
				'scope' => apply_filters( 'sahel_elated_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'content_side_meta' ),
				'title' => esc_html__( 'Content Side Areas', 'sahel' ),
				'name'  => 'content_side_meta'
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_enable_content_side_left_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Content Side Left Area', 'sahel' ),
				'description'   => esc_html__( 'This option will enable Content Side Left area on pages', 'sahel' ),
				'parent'        => $content_side_meta_box,
				'options'       => sahel_elated_get_yes_no_select_array()
			)
		);
		
		$show_content_side_left_meta_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $content_side_meta_box,
				'name'            => 'eltdf_show_content_side_left_meta_container',
				'dependency' => array(
					'show' => array(
						'eltdf_enable_content_side_left_area_meta' => 'yes'
					)
				)
			)
		);
		
		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_content_side_left_sidebar_custom_display_meta',
				'type'          => 'selectblank',
				'default_value' => '',
				'label'         => esc_html__( 'Sidebar to Display', 'sahel' ),
				'description'   => esc_html__( 'Choose a content side left sidebar to display', 'sahel' ),
				'options'       => sahel_elated_get_custom_sidebars(),
				'parent'        => $show_content_side_left_meta_container,
				'args'          => array(
					'select2' => true
				)
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'type'          => 'selectblank',
				'name'          => 'eltdf_content_side_left_rotate_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Rotate Widgets', 'sahel' ),
				'description'   => esc_html__( 'Choose whether to rotate widgets', 'sahel' ),
				'options'       => array(
					'' => esc_html__('Default','sahel'),
					'no' => esc_html__('No','sahel'),
					'rotate-left' => esc_html__('Rotate to the left','sahel'),
					'rotate-right' => esc_html__('Rotate to the right','sahel'),
				),
				'parent'        => $show_content_side_left_meta_container
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_enable_content_side_right_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Content Side Right Area', 'sahel' ),
				'description'   => esc_html__( 'This option will enable Content Side Right area on pages', 'sahel' ),
				'parent'        => $content_side_meta_box,
				'options'       => sahel_elated_get_yes_no_select_array()
			)
		);

		$show_content_side_right_meta_container = sahel_elated_add_admin_container(
			array(
				'parent'          => $content_side_meta_box,
				'name'            => 'eltdf_show_content_side_right_meta_container',
				'dependency' => array(
					'show' => array(
						'eltdf_enable_content_side_right_area_meta' => 'yes'
					)
				)
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'name'          => 'eltdf_content_side_right_sidebar_custom_display_meta',
				'type'          => 'selectblank',
				'default_value' => '',
				'label'         => esc_html__( 'Sidebar to Display', 'sahel' ),
				'description'   => esc_html__( 'Choose a content side right sidebar to display', 'sahel' ),
				'options'       => sahel_elated_get_custom_sidebars(),
				'parent'        => $show_content_side_right_meta_container,
				'args'          => array(
					'select2' => true
				)
			)
		);

		sahel_elated_create_meta_box_field(
			array(
				'type'          => 'selectblank',
				'name'          => 'eltdf_content_side_right_rotate_meta',
				'default_value' => '',
				'label'         => esc_html__( 'Rotate Widgets', 'sahel' ),
				'description'   => esc_html__( 'Choose whether to rotate widgets', 'sahel' ),
				'options'       => array(
					'' => esc_html__('Default','sahel'),
					'no' => esc_html__('No','sahel'),
					'rotate-left' => esc_html__('Rotate to the left','sahel'),
					'rotate-right' => esc_html__('Rotate to the right','sahel'),
				),
				'parent'        => $show_content_side_right_meta_container
			)
		);
	}
	
	add_action( 'sahel_elated_action_meta_boxes_map', 'sahel_elated_map_content_side_meta', 72 );
}