<?php
$post_content_alignment = sahel_elated_options()->getOptionValue('blog_content_alignment');
$additional_blog_single_class = 'eltdf-post-content-alignment-' . $post_content_alignment;
$image_size          = isset( $image_size ) ? $image_size : 'full';
$image_meta          = get_post_meta( get_the_ID(), 'eltdf_blog_list_featured_image_meta', true );
$has_featured        = ! empty( $image_meta ) || has_post_thumbnail();
$blog_list_image_id  = ! empty( $image_meta ) && sahel_elated_blog_item_has_link() ? sahel_elated_get_attachment_id_from_url( $image_meta ) : '';
$tags = get_the_tags();
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="eltdf-post-content <?php if($post_content_alignment == 'centered') echo esc_attr($additional_blog_single_class); ?>">
        <div class="eltdf-post-text">
            <div class="eltdf-post-text-inner">
                <?php if($has_featured){?>
                <div class="eltdf-post-heading">
                    <?php sahel_elated_get_module_template_part('templates/parts/media', 'blog', $post_format, $part_params); ?>
                </div>
                <?php } ?>
                <?php sahel_elated_get_module_template_part('templates/parts/post-info/category', 'blog', '', $part_params); ?>
                <?php sahel_elated_get_module_template_part('templates/parts/title', 'blog', '', $part_params); ?>
                <div class="eltdf-post-info">
                    <?php sahel_elated_get_module_template_part('templates/parts/post-info/date', 'blog', '', $part_params); ?>
                    <?php sahel_elated_get_module_template_part('templates/parts/post-info/author', 'blog', '', $part_params); ?>
                </div>
                <div class="eltdf-post-text-main">
                    <?php the_content(); ?>
                    <?php do_action('sahel_elated_action_single_link_pages'); ?>
                </div>
                <?php if($tags || sahel_elated_options()->getOptionValue('enable_social_share') === 'yes' && sahel_elated_options()->getOptionValue('enable_social_share_on_post') === 'yes'){?>
                <div class="eltdf-post-info-bottom clearfix">
                    <div class="eltdf-post-info-bottom">
                        <?php sahel_elated_get_module_template_part('templates/parts/post-info/tags', 'blog', '', $part_params); ?>
                        <?php sahel_elated_get_module_template_part('templates/parts/post-info/share', 'blog', '', $part_params); ?>
                    </div>
                </div>
                <?php }?>
            </div>
        </div>
    </div>
</article>