<?php
$show_related = sahel_elated_options()->getOptionValue('blog_single_related_posts') == 'yes' ? true : false;
$related_post_number = sahel_elated_sidebar_layout() === 'no-sidebar' ? 4 : 3;
$related_posts_options = array(
    'posts_per_page' => $related_post_number
);
$related_posts = sahel_elated_get_blog_related_post_type(get_the_ID(), $related_posts_options);
$related_posts_image_size = isset($related_posts_image_size) ? $related_posts_image_size : 'sahel_elated_image_portrait';

$post_content_alignment = sahel_elated_options()->getOptionValue('blog_content_alignment');
$additional_blog_single_class = 'eltdf-post-comment-alignment-' . $post_content_alignment;

?>
<?php if($show_related) { ?>
    <div class="eltdf-related-posts-holder clearfix <?php if($post_content_alignment == 'centered') echo esc_attr($additional_blog_single_class); ?>">
        <div class="eltdf-related-posts-holder-inner">
            <?php if ( $related_posts && $related_posts->have_posts() ) : ?>
                <div class="eltdf-related-posts-title">
                    <h3><?php esc_html_e('Read recent articles', 'sahel' ); ?></h3>
                </div>
                <div class="eltdf-related-posts-inner clearfix">
                    <?php while ( $related_posts->have_posts() ) : $related_posts->the_post(); ?>
                        <div class="eltdf-related-post">
                            <div class="eltdf-related-post-inner">
			                    <?php if (has_post_thumbnail()) { ?>
                                <div class="eltdf-related-post-image">
                                    <a itemprop="url" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                                         <?php the_post_thumbnail($related_posts_image_size); ?>
                                    </a>
                                </div>
			                    <?php }	?>
                                <div class="eltdf-related-post-content">
                                    <div class="eltdf-related-post-info">
                                        <?php sahel_elated_get_module_template_part( 'templates/parts/post-info/category', 'blog', '', $params ); ?>
                                    </div>
                                    <h5 itemprop="name" class="entry-title eltdf-post-title"><a itemprop="url" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h5>
                                    <div class="eltdf-related-post-info-bottom">
                                        <?php sahel_elated_get_module_template_part('templates/parts/post-info/date', 'blog', '', $params); ?>
                                        <?php sahel_elated_get_module_template_part('templates/parts/post-info/author', 'blog', '', $params); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            <?php endif;
            wp_reset_postdata();
            ?>
        </div>
    </div>
<?php } ?>