<?php
class ElementorBlogSlider extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_blog_slider'; 
	}

	public function get_title() {
		return esc_html__( 'Blog Slider', 'sahel' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-blog-slider';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'slider_type',
			[
				'label'     => esc_html__( 'Type', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'slider' => esc_html__( 'Slider', 'sahel'), 
					'carousel' => esc_html__( 'Carousel', 'sahel'), 
					'carousel-centered' => esc_html__( 'Carousel Centered', 'sahel')
				),
				'default' => 'slider'
			]
		);

		$this->add_control(
			'number_of_posts',
			[
				'label'     => esc_html__( 'Number of Posts', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'date' => esc_html__( 'Date', 'sahel'), 
					'ID' => esc_html__( 'ID', 'sahel'), 
					'menu_order' => esc_html__( 'Menu Order', 'sahel'), 
					'name' => esc_html__( 'Post Name', 'sahel'), 
					'rand' => esc_html__( 'Random', 'sahel'), 
					'title' => esc_html__( 'Title', 'sahel')
				),
				'default' => 'title'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'ASC' => esc_html__( 'ASC', 'sahel'), 
					'DESC' => esc_html__( 'DESC', 'sahel')
				),
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'category',
			[
				'label'     => esc_html__( 'Category', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter one category slug (leave empty for showing all categories)', 'sahel' )
			]
		);

		$this->add_control(
			'image_size',
			[
				'label'     => esc_html__( 'Image Size', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'full' => esc_html__( 'Original', 'sahel'), 
					'sahel_elated_image_square' => esc_html__( 'Square', 'sahel'), 
					'sahel_elated_image_landscape' => esc_html__( 'Landscape', 'sahel'), 
					'sahel_elated_image_portrait' => esc_html__( 'Portrait', 'sahel'), 
					'thumbnail' => esc_html__( 'Thumbnail', 'sahel'), 
					'medium' => esc_html__( 'Medium', 'sahel'), 
					'large' => esc_html__( 'Large', 'sahel')
				),
				'default' => 'full'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'post_info',
			[
				'label' => esc_html__( 'Post Info', 'sahel' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel'), 
					'h1' => esc_html__( 'h1', 'sahel'), 
					'h2' => esc_html__( 'h2', 'sahel'), 
					'h3' => esc_html__( 'h3', 'sahel'), 
					'h4' => esc_html__( 'h4', 'sahel'), 
					'h5' => esc_html__( 'h5', 'sahel'), 
					'h6' => esc_html__( 'h6', 'sahel'), 
					'span' => esc_html__( 'span', 'sahel')
				),
				'default' => 'h2'
			]
		);

		$this->add_control(
			'title_transform',
			[
				'label'     => esc_html__( 'Title Text Transform', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel'), 
					'none' => esc_html__( 'None', 'sahel'), 
					'capitalize' => esc_html__( 'Capitalize', 'sahel'), 
					'uppercase' => esc_html__( 'Uppercase', 'sahel'), 
					'lowercase' => esc_html__( 'Lowercase', 'sahel'), 
					'initial' => esc_html__( 'Initial', 'sahel'), 
					'inherit' => esc_html__( 'Inherit', 'sahel')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'post_info_author',
			[
				'label'     => esc_html__( 'Enable Post Info Author', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel'), 
					'no' => esc_html__( 'No', 'sahel')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'post_info_date',
			[
				'label'     => esc_html__( 'Enable Post Info Date', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel'), 
					'no' => esc_html__( 'No', 'sahel')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'post_info_category',
			[
				'label'     => esc_html__( 'Enable Post Info Category', 'sahel' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel'), 
					'no' => esc_html__( 'No', 'sahel')
				),
				'default' => 'yes'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();


		
		$queryArray             = $this->generateBlogQueryArray( $params );
		$query_result           = new \WP_Query( $queryArray );
		$params['query_result'] = $query_result;
		
		$params['slider_type']    = ! empty( $params['slider_type'] ) ? $params['slider_type'] : 'slider';
		$params['slider_classes'] = $this->getSliderClasses( $params );
		$params['slider_data']    = $this->getSliderData( $params );
		
		ob_start();
		
		sahel_elated_get_module_template_part( 'shortcodes/blog-slider/holder', 'blog', '', $params );
		
		$html = ob_get_contents();
		
		ob_end_clean();
		
		echo sahel_elated_get_module_part($html);
	}

	public function generateBlogQueryArray( $params ) {
		$queryArray = array(
			'post_status'    => 'publish',
			'post_type'      => 'post',
			'orderby'        => $params['orderby'],
			'order'          => $params['order'],
			'posts_per_page' => $params['number_of_posts'],
			'post__not_in'   => get_option( 'sticky_posts' )
		);
		
		if ( ! empty( $params['category'] ) ) {
			$queryArray['category_name'] = $params['category'];
		}
		
		return $queryArray;
	}

	public function getSliderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = 'eltdf-bs-' . $params['slider_type'];
		
		return implode( ' ', $holderClasses );
	}

	private function getSliderData( $params ) {
		$type        = $params['slider_type'];
		$slider_data = array();
		
		if($type == 'carousel') {
			$slider_data['data-number-of-items']   = '2';
			$slider_data['data-slider-margin']     = '80';
			$slider_data['data-slider-padding']    = 'yes';
			$slider_data['data-enable-navigation'] = 'no';
		} else if ($type == 'carousel-centered') {
			$slider_data['data-number-of-items']   = '2';
			$slider_data['data-slider-margin']     = '30';
			$slider_data['data-enable-center']     = 'yes';
			$slider_data['data-enable-navigation'] = 'yes';
			$slider_data['data-enable-pagination'] = 'yes';
		} else {
			$slider_data['data-number-of-items']   = '1';
            $slider_data['data-enable-navigation'] = 'no';
			$slider_data['data-enable-pagination'] = 'yes';
		}
		
		return $slider_data;
	}

    public function blogListCategoryAutocompleteSuggester( $query ) {
        global $wpdb;
        $post_meta_infos = $wpdb->get_results( $wpdb->prepare( "SELECT a.slug AS slug, a.name AS category_title
					FROM {$wpdb->terms} AS a
					LEFT JOIN ( SELECT term_id, taxonomy  FROM {$wpdb->term_taxonomy} ) AS b ON b.term_id = a.term_id
					WHERE b.taxonomy = 'category' AND a.name LIKE '%%%s%%'", stripslashes( $query ) ), ARRAY_A );

        $results = array();
        if ( is_array( $post_meta_infos ) && ! empty( $post_meta_infos ) ) {
            foreach ( $post_meta_infos as $value ) {
                $data          = array();
                $data['value'] = $value['slug'];
                $data['label'] = ( ( strlen( $value['category_title'] ) > 0 ) ? esc_html__( 'Category', 'sahel' ) . ': ' . $value['category_title'] : '' );
                $results[]     = $data;
            }
        }

        return $results;
    }

    public function blogListCategoryAutocompleteRender( $query ) {
        $query = trim( $query['value'] ); // get value from requested
        if ( ! empty( $query ) ) {
            // get category
            $category = get_term_by( 'slug', $query, 'category' );
            if ( is_object( $category ) ) {

                $category_slug = $category->slug;
                $category_title = $category->name;

                $category_title_display = '';
                if ( ! empty( $category_title ) ) {
                    $category_title_display = esc_html__( 'Category', 'sahel' ) . ': ' . $category_title;
                }

                $data          = array();
                $data['value'] = $category_slug;
                $data['label'] = $category_title_display;

                return ! empty( $data ) ? $data : false;
            }

            return false;
        }

        return false;
    }

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorBlogSlider() );