<?php
class ElementorUncoveringSections extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_uncovering_sections'; 
	}

	public function get_title() {
		return esc_html__( 'Uncovering Sections', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-uncovering-sections';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'custom_class',
			[
				'label'     => esc_html__( 'Custom CSS Class', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'sahel-core' )
			]
		);

		$repeater->add_control(
			'background_color',
			[
				'label'     => esc_html__( 'Background Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$repeater->add_control(
			'background_image',
			[
				'label'     => esc_html__( 'Background Image', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'background_position',
			[
				'label'     => esc_html__( 'Background Image Position', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Please insert position in format horizontal vertical position, example - center center', 'sahel-core' ),
				'condition' => [
					'background_image!' => ''
				]
			]
		);

		$repeater->add_control(
			'background_size',
			[
				'label'     => esc_html__( 'Background Image Size', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'cover' => esc_html__( 'Cover', 'sahel-core'), 
					'contain' => esc_html__( 'Contain', 'sahel-core'), 
					'inherit' => esc_html__( 'Inherit', 'sahel-core')
				),
				'default' => 'cover',
				'condition' => [
					'background_image!' => ''
				]
			]
		);

		$repeater->add_control(
			'padding',
			[
				'label'     => esc_html__( 'Content Padding', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Please insert padding in format top right bottom left. You can use px or %', 'sahel-core' )
			]
		);

		$repeater->add_control(
			'vertical_alignment',
			[
				'label'     => esc_html__( 'Content Vertical Alignment', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'top' => esc_html__( 'Top', 'sahel-core'), 
					'middle' => esc_html__( 'Middle', 'sahel-core'), 
					'bottom' => esc_html__( 'Bottom', 'sahel-core')
				),
				'default' => ''
			]
		);

		$repeater->add_control(
			'horizontal_alignment',
			[
				'label'     => esc_html__( 'Content Horizontal Alignment', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'left' => esc_html__( 'Left', 'sahel-core'), 
					'center' => esc_html__( 'Center', 'sahel-core'), 
					'right' => esc_html__( 'Right', 'sahel-core')
				),
				'default' => ''
			]
		);

		$repeater->add_control(
			'link',
			[
				'label'     => esc_html__( 'Link', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Set custom link around item', 'sahel-core' )
			]
		);

		$repeater->add_control(
			'link_target',
			[
				'label'     => esc_html__( 'Custom Link Target', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Same Window', 'sahel-core'), 
					'_blank' => esc_html__( 'New Window', 'sahel-core')
				),
				'default' => '_self',
				'condition' => [
					'link!' => ''
				]
			]
		);

		$repeater->add_control(
			'header_skin',
			[
				'label'     => esc_html__( 'Header Skin', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Choose a predefined header style for header elements', 'sahel-core' ),
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'light' => esc_html__( 'Light', 'sahel-core'), 
					'dark' => esc_html__( 'Dark', 'sahel-core')
				),
				'default' => ''
			]
		);

		$repeater->add_control(
			'image_laptop',
			[
				'label'     => esc_html__( 'Background Image for Laptops', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'image_tablet',
			[
				'label'     => esc_html__( 'Background Image for Tablets - Landscape', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'image_tablet_portrait',
			[
				'label'     => esc_html__( 'Background Image for Tablets - Portrait', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'image_mobile',
			[
				'label'     => esc_html__( 'Background Image for Mobiles', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		sahel_core_generate_elementor_templates_control( $repeater );

		$this->add_control(
			'uncovering_sections_item',
			[
				'label'     => esc_html__( 'Uncovering Sections Item', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'sahel-core' )
			]
		);


		$this->end_controls_section();
	}

	public function render() {

		$params = $this->get_settings_for_display();

		?>

		<div class="eltdf-uncovering-sections">
			<ul class="eltdf-us-wrapper curtains" data-image-holder-name=".eltdf-uss-image-holder" data-fade-element-name=".eltdf-fss-shadow">
				<?php
				foreach ( $params['uncovering_sections_item'] as $item) {
					$rand_class = 'eltdf-uss-custom-' . mt_rand(100000,1000000);

					$params['background_image'] = !empty($params['background_image']) ? $params['background_image']['id'] : $params['background_image'];
					$params['image_laptop'] = !empty($params['image_laptop']) ? $params['image_laptop']['id'] : $params['image_laptop'];
					$params['image_tablet'] = !empty($params['image_tablet']) ? $params['image_tablet']['id'] : $params['image_tablet'];
					$params['image_tablet_portrait'] = !empty($params['image_tablet_portrait']) ? $params['image_tablet_portrait']['id'] : $params['image_tablet_portrait'];
					$params['image_mobile'] = !empty($params['image_mobile']) ? $params['image_mobile']['id'] : $params['image_mobile'];

					$item['holder_unique_class'] = $rand_class;
					$item['holder_classes']      = $this->getHolderClasses( $item );
					$item['holder_data']         = $this->getHolderData( $item );
					$item['image_data']          = $this->getImageData( $item );
					$item['holder_styles']       = $this->getHolderStyles( $item );
					$item['item_inner_styles']   = $this->getItemInnerStyles( $item );
					$item['link_target']         = !empty($item['link_target']) ? $item['link_target'] : '_self';

					var_dump($item['template_id']);

					$item['content'] = Elementor\Plugin::instance()->frontend->get_builder_content_for_display($item['template_id']);

					echo sahel_core_get_shortcode_module_template_part( 'templates/uncovering-sections-item', 'uncovering-sections', '', $item );
				}

				?>
			</ul>
			<div class="eltdf-fss-shadow"></div>
		</div>

	<?php
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();

		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['holder_unique_class'] ) ? $params['holder_unique_class'] : '';
		$holderClasses[] = ! empty( $params['vertical_alignment'] ) ? 'eltdf-uss-item-va-' . $params['vertical_alignment'] : '';
		$holderClasses[] = ! empty( $params['horizontal_alignment'] ) ? 'eltdf-uss-item-ha-' . $params['horizontal_alignment'] : '';
		$holderClasses[] = ! empty( $params['link'] ) ? 'eltdf-uss-item-has-link' : '';
		$holderClasses[] = ! empty( $params['header_skin'] ) ? 'eltdf-uss-item-has-style' : '';

		return implode( ' ', $holderClasses );
	}

	private function getHolderData( $params ) {
		$data                    = array();
		$data['data-item-class'] = $params['holder_unique_class'];

		if ( ! empty( $params['header_skin'] ) ) {
			$data['data-header-style'] = $params['header_skin'];
		}

		return $data;
	}

	private function getImageData( $params ) {
		$data                    = array();

		if ( ! empty( $params['image_laptop'] ) ) {
			$image                     = wp_get_attachment_image_src( $params['image_laptop'], 'full' );
			$data['data-laptop-image'] = $image[0];
		}

		if ( ! empty( $params['image_tablet'] ) ) {
			$image                     = wp_get_attachment_image_src( $params['image_tablet'], 'full' );
			$data['data-tablet-image'] = $image[0];
		}

		if ( ! empty( $params['image_tablet_portrait'] ) ) {
			$image                              = wp_get_attachment_image_src( $params['image_tablet_portrait'], 'full' );
			$data['data-tablet-portrait-image'] = $image[0];
		}

		if ( ! empty( $params['image_mobile'] ) ) {
			$image                     = wp_get_attachment_image_src( $params['image_mobile'], 'full' );
			$data['data-mobile-image'] = $image[0];
		}

		return $data;
	}

	private function getHolderStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['background_color'] ) ) {
			$styles[] = 'background-color: ' . $params['background_color'];
		}

		if ( ! empty( $params['background_image'] ) ) {
			$styles[] = 'background-image: url(' . wp_get_attachment_url( $params['background_image'] ) . ')';

			if ( ! empty( $params['background_position'] ) ) {
				$styles[] = 'background-position:' . $params['background_position'];
			}

			if ( ! empty( $params['background_size'] ) ) {
				$styles[] = 'background-size:' . $params['background_size'];
			}
		}

		return implode( ';', $styles );
	}

	private function getItemInnerStyles( $params ) {
		$styles = array();

		if ( $params['padding'] !== '' ) {
			$styles[] = 'padding: ' . $params['padding'];
		}

		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorUncoveringSections() );