<?php
class ElementorTeam extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_team'; 
	}

	public function get_title() {
		return esc_html__( 'Team', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-team';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'info-below-image' => esc_html__( 'Info Below Image', 'sahel-core'), 
					'info-on-image' => esc_html__( 'Info On Image Hover', 'sahel-core')
				),
				'default' => 'info-below-image'
			]
		);

		$this->add_control(
			'team_image',
			[
				'label'     => esc_html__( 'Image', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$this->add_control(
			'team_name',
			[
				'label'     => esc_html__( 'Name', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'team_name_tag',
			[
				'label'     => esc_html__( 'Name Tag', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'h1' => esc_html__( 'h1', 'sahel-core'), 
					'h2' => esc_html__( 'h2', 'sahel-core'), 
					'h3' => esc_html__( 'h3', 'sahel-core'), 
					'h4' => esc_html__( 'h4', 'sahel-core'), 
					'h5' => esc_html__( 'h5', 'sahel-core'), 
					'h6' => esc_html__( 'h6', 'sahel-core')
				),
				'default' => 'h4',
				'condition' => [
					'team_name!' => ''
				]
			]
		);

		$this->add_control(
			'team_name_color',
			[
				'label'     => esc_html__( 'Name Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'team_name!' => ''
				]
			]
		);

		$this->add_control(
			'team_position',
			[
				'label'     => esc_html__( 'Position', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'team_position_color',
			[
				'label'     => esc_html__( 'Position Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'team_position!' => ''
				]
			]
		);

		$this->add_control(
			'team_text',
			[
				'label'     => esc_html__( 'Text', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'team_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'team_text!' => ''
				]
			]
		);

		$this->add_control(
			'enable_loading_animation',
			[
				'label'     => esc_html__( 'Loading Animation', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'),
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		$repeater = new \Elementor\Repeater();

		sahel_elated_icon_collections()->getElementorParamsArray( $repeater, '', '' );

		$repeater->add_control(
			'team_social_icon_link',
			[
				'label' => esc_html__( 'Social Icon Link', 'sahel-core' ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'team_social_icon_target',
			[
				'label'   => esc_html__( 'Social Icon Target', 'sahel-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => sahel_elated_get_link_target_array(),
				'default' => '_self'
			]
		);

		$this->add_control(
			'social_icon_item',
			[
				'label'       => esc_html__( 'Social Icons', 'sahel-core' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => esc_html__( 'Social Icon', 'sahel-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['team_image']           = !empty($params['team_image']) ? $params['team_image']['id'] : $params['team_image'];

		$params['number_of_social_icons'] = 5;
		
		$params['type']                 = ! empty( $params['type'] ) ? $params['type'] : 'info-below-image';
		$params['holder_classes']       = $this->getHolderClasses( $params );
		$params['team_name_tag']        = ! empty( $params['team_name_tag'] ) ? $params['team_name_tag'] : 'h4';
		$params['team_social_icons']    = $this->getTeamSocialIcons( $params );
		$params['team_name_styles']     = $this->getTeamNameStyles( $params );
		$params['team_position_styles'] = $this->getTeamPositionStyles( $params );
		$params['team_text_styles']     = $this->getTeamTextStyles( $params );
		
		//Get HTML from template based on type of team
		echo sahel_core_get_shortcode_module_template_part( 'templates/' . $params['type'], 'team', '', $params );
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['type'] ) ? 'eltdf-team-' . $params['type'] : '';
		$holderClasses[] = $params['enable_loading_animation'] == 'yes' ? 'eltdf-team-with-loading-animation' : '';
		
		return implode( ' ', $holderClasses );
	}

		private function getTeamSocialIcons( $params ) {
        $team_social_icons = array();

        if ( !empty( $params['social_icon_item'] ) ) {

            foreach ( $params['social_icon_item'] as $icon ) {

                $iconPackName = sahel_elated_icon_collections()->getIconCollectionParamNameByKey( $icon['icon_pack'] );

                $team_icon_params                  = array();
                $team_icon_params['icon_pack']     = $icon['icon_pack'];
                $team_icon_params[ $iconPackName ] = $icon[ $iconPackName ];
                $team_icon_params['link']          = $icon['team_social_icon_link'];
                $team_icon_params['target']        = $icon['team_social_icon_target'];

                $team_social_icons[] = sahel_elated_execute_shortcode( 'eltdf_icon', $team_icon_params );
            }
        }
		
		return $team_social_icons;
	}

	private function getTeamNameStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['team_name_color'] ) ) {
			$styles[] = 'color: ' . $params['team_name_color'];
		}
		
		return implode( ';', $styles );
	}

	private function getTeamPositionStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['team_position_color'] ) ) {
			$styles[] = 'color: ' . $params['team_position_color'];
		}
		
		return implode( ';', $styles );
	}

	private function getTeamTextStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['team_text_color'] ) ) {
			$styles[] = 'color: ' . $params['team_text_color'];
		}
		
		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorTeam() );