<?php
class ElementorTeamCarousel extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_team_carousel'; 
	}

	public function get_title() {
		return esc_html__( 'Team Carousel', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-team-carousel';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number_of_visible_items',
			[
				'label'     => esc_html__( 'Number of Visible Items', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( 'One', 'sahel-core'), 
					'2' => esc_html__( 'Two', 'sahel-core'), 
					'3' => esc_html__( 'Three', 'sahel-core'), 
					'4' => esc_html__( 'Four', 'sahel-core'), 
					'5' => esc_html__( 'Five', 'sahel-core'), 
					'6' => esc_html__( 'Six', 'sahel-core')
				),
				'default' => '3'
			]
		);

		$this->add_control(
			'space_between_items',
			[
				'label'     => esc_html__( 'Space Between Items', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'huge' => esc_html__( 'Huge (80)', 'sahel-core'), 
					'large' => esc_html__( 'Large (40)', 'sahel-core'), 
					'medium' => esc_html__( 'Medium (20)', 'sahel-core'), 
					'normal' => esc_html__( 'Normal (15)', 'sahel-core'), 
					'small' => esc_html__( 'Small (10)', 'sahel-core'), 
					'tiny' => esc_html__( 'Tiny (5)', 'sahel-core'), 
					'no' => esc_html__( 'No (0)', 'sahel-core')
				),
				'default' => 'normal'
			]
		);

		$this->add_control(
			'slider_loop',
			[
				'label'     => esc_html__( 'Enable Slider Loop', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'), 
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'slider_autoplay',
			[
				'label'     => esc_html__( 'Enable Slider Autoplay', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'), 
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'slider_speed',
			[
				'label'     => esc_html__( 'Slide Duration', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Default value is 5000 (ms)', 'sahel-core' )
			]
		);

		$this->add_control(
			'slider_speed_animation',
			[
				'label'     => esc_html__( 'Slide Animation Duration', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Speed of slide animation in milliseconds. Default value is 600.', 'sahel-core' )
			]
		);

		$this->add_control(
			'slider_navigation',
			[
				'label'     => esc_html__( 'Enable Slider Navigation Arrows', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'), 
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'slider_pagination',
			[
				'label'     => esc_html__( 'Enable Slider Pagination', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'), 
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'info-below-image' => esc_html__( 'Info Below Image', 'sahel-core'), 
					'info-on-image' => esc_html__( 'Info On Image Hover', 'sahel-core')
				),
				'default' => 'info-below-image'
			]
		);

		$repeater->add_control(
			'team_image',
			[
				'label'     => esc_html__( 'Image', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'team_name',
			[
				'label'     => esc_html__( 'Name', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'team_name_tag',
			[
				'label'     => esc_html__( 'Name Tag', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'h1' => esc_html__( 'h1', 'sahel-core'), 
					'h2' => esc_html__( 'h2', 'sahel-core'), 
					'h3' => esc_html__( 'h3', 'sahel-core'), 
					'h4' => esc_html__( 'h4', 'sahel-core'), 
					'h5' => esc_html__( 'h5', 'sahel-core'), 
					'h6' => esc_html__( 'h6', 'sahel-core')
				),
				'default' => '',
				'condition' => [
					'team_name!' => ''
				]
			]
		);

		$repeater->add_control(
			'team_name_color',
			[
				'label'     => esc_html__( 'Name Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'team_name!' => ''
				]
			]
		);

		$repeater->add_control(
			'team_position',
			[
				'label'     => esc_html__( 'Position', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'team_position_color',
			[
				'label'     => esc_html__( 'Position Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'team_position!' => ''
				]
			]
		);

		$repeater->add_control(
			'team_text',
			[
				'label'     => esc_html__( 'Text', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'team_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'team_text!' => ''
				]
			]
		);

		$repeater->add_control(
			'team_social_icon_pack',
			[
				'label'     => esc_html__( 'Social Icon Pack', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'sahel-core'), 
					'dripicons' => esc_html__( 'Dripicons', 'sahel-core'), 
					'font_elegant' => esc_html__( 'Font Elegant', 'sahel-core'), 
					'font_awesome' => esc_html__( 'Font Awesome', 'sahel-core'), 
					'ion_icons' => esc_html__( 'Ion Icons', 'sahel-core'), 
					'linear_icons' => esc_html__( 'Linear Icons', 'sahel-core'), 
					'simple_line_icons' => esc_html__( 'Simple Line Icons', 'sahel-core')
				),
				'default' => ''
			]
		);

		$repeater->add_control(
			'enable_loading_animation',
			[
				'label'     => esc_html__( 'Loading Animation', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'sahel-core'), 
					'no' => esc_html__( 'No', 'sahel-core')
				),
				'default' => 'yes'
			]
		);

		for ( $x = 1; $x < 6; $x ++ ) {
			$teamIconCollections = sahel_elated_icon_collections()->getCollectionsWithSocialIcons();
			foreach ( $teamIconCollections as $collection_key => $collection ) {

				$repeater->add_control(
					'team_social_' . $collection->param . '_' . $x,
					[
						'label'     => esc_html__( 'Social Icon', 'sahel-core' ) . $x,
						'type'      => \Elementor\Controls_Manager::SELECT,
						'options' => array_flip( $collection->getSocialIconsArrayVC() ),
						'condition' => [
							'team_social_icon_pack' => array( $collection_key )
						]
					]
				);
			}

			$repeater->add_control(
				'team_social_icon_' . $x . '_link',
				[
					'label'     => esc_html__( 'Social Icon ', 'sahel-core' ) . $x . esc_html__( ' Link', 'sahel-core' ),
					'type'      => \Elementor\Controls_Manager::TEXT,
					'default'   => '',
					'condition' => [
						'team_social_icon_pack' => sahel_elated_icon_collections()->getIconCollectionsKeys()
					]
				]
			);

			$repeater->add_control(
				'team_social_icon_' . $x . '_target',
				[
					'label'     => esc_html__( 'Social Icon ', 'sahel-core' ) . $x . esc_html__( ' Target', 'sahel-core' ),
					'type'      => \Elementor\Controls_Manager::SELECT,
					'options'      => array(
						'_self'     => esc_html__( 'Same Window', 'sahel-core' ),
						'_blank'    => esc_html__( 'New Window', 'sahel-core' )
					),
					'condition' => [
						'team_social_icon_' . $x . '_link!' => ''
					]
				]
			);
		}


		$this->add_control(
			'team',
			[
				'label'     => esc_html__( 'Team', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'sahel-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();


		
		$holder_classes = $this->getHolderClasses( $params );
		$slider_data    = $this->getSliderData( $params );

		?>
		<div class="eltdf-team-carousel-holder <?php echo esc_attr( $holder_classes ); ?>">
			<div class="eltdf-tc-inner eltdf-owl-slider" <?php echo sahel_elated_get_inline_attrs( $slider_data ) ?>>
				<?php foreach ( $params['team'] as $team ) {
					if ( ! empty( $team['team_image'] ) ) {
						$team['team_image'] = $team['team_image']['id'];
					}
					$team['team_name_tag']        = ! empty( $team['team_name_tag'] ) ? $team['team_name_tag'] : 'h4';
					$team['type']                 = ! empty( $team['type'] ) ? $team['type'] : 'info-below-image';
					$team['number_of_social_icons'] = 5;
					$team['holder_classes']       = $this->getItemHolderClasses( $team );
					$team['team_social_icons']    = $this->getItemTeamSocialIcons( $team );
					$team['team_name_styles']     = $this->getItemTeamNameStyles( $team );
					$team['team_position_styles'] = $this->getItemTeamPositionStyles( $team );
					$team['team_text_styles']     = $this->getItemTeamTextStyles( $team );
					echo sahel_core_get_shortcode_module_template_part( 'templates/'. $team['type'], 'team', '', $team );
				} ?>
			</div>
		</div>
		<?php
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['space_between_items'] ) ? 'eltdf-' . $params['space_between_items'] . '-space' : 'eltdf-normal-space';
		
		return implode( ' ', $holderClasses );
	}

	private function getSliderData( $params ) {
		$slider_data = array();
		
		$slider_data['data-number-of-items']        = $params['number_of_visible_items'] !== '' ? $params['number_of_visible_items'] : '3';
		$slider_data['data-enable-loop']            = ! empty( $params['slider_loop'] ) ? $params['slider_loop'] : '';
		$slider_data['data-enable-autoplay']        = ! empty( $params['slider_autoplay'] ) ? $params['slider_autoplay'] : '';
		$slider_data['data-slider-speed']           = ! empty( $params['slider_speed'] ) ? $params['slider_speed'] : '5000';
		$slider_data['data-slider-speed-animation'] = ! empty( $params['slider_speed_animation'] ) ? $params['slider_speed_animation'] : '600';
		$slider_data['data-enable-navigation']      = ! empty( $params['slider_navigation'] ) ? $params['slider_navigation'] : '';
		$slider_data['data-enable-pagination']      = ! empty( $params['slider_pagination'] ) ? $params['slider_pagination'] : '';
		
		return $slider_data;
	}

	private function getItemHolderClasses( $params ) {
		$holderClasses = array();

		$holderClasses[] = ! empty( $params['type'] ) ? 'eltdf-team-' . $params['type'] : '';

		return implode( ' ', $holderClasses );
	}

	private function getItemTeamSocialIcons( $params ) {
		extract( $params );
		$social_icons = array();

		if ( $team_social_icon_pack !== '' ) {

			$icon_pack                    = sahel_elated_icon_collections()->getIconCollection( $team_social_icon_pack );
			$team_social_icon_type_label  = 'team_social_' . $icon_pack->param;
			$team_social_icon_param_label = $icon_pack->param;

			for ( $i = 1; $i <= $params['number_of_social_icons']; $i ++ ) {

				$team_social_icon   = ${$team_social_icon_type_label . '_' . $i};
				$team_social_link   = ${'team_social_icon_' . $i . '_link'};
				$team_social_target = ${'team_social_icon_' . $i . '_target'};

				if ( $team_social_icon !== '' ) {

					$team_icon_params                                  = array();
					$team_icon_params['icon_pack']                     = $team_social_icon_pack;
					$team_icon_params[ $team_social_icon_param_label ] = $team_social_icon;
					$team_icon_params['link']                          = ( $team_social_link !== '' ) ? $team_social_link : '';
					$team_icon_params['target']                        = ( $team_social_target !== '' ) ? $team_social_target : '';

					$social_icons[] = sahel_elated_execute_shortcode( 'eltdf_icon', $team_icon_params );
				}
			}
		}

		return $social_icons;
	}

	private function getItemTeamNameStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['team_name_color'] ) ) {
			$styles[] = 'color: ' . $params['team_name_color'];
		}

		return implode( ';', $styles );
	}

	private function getItemTeamPositionStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['team_position_color'] ) ) {
			$styles[] = 'color: ' . $params['team_position_color'];
		}

		return implode( ';', $styles );
	}

	private function getItemTeamTextStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['team_text_color'] ) ) {
			$styles[] = 'color: ' . $params['team_text_color'];
		}

		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorTeamCarousel() );