<?php
class ElementorTabs extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_tabs'; 
	}

	public function get_title() {
		return esc_html__( 'Tabs', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-tabs';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_class',
			[
				'label'     => esc_html__( 'Custom CSS Class', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'sahel-core' )
			]
		);

		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'standard' => esc_html__( 'Standard', 'sahel-core'), 
					'boxed' => esc_html__( 'Boxed', 'sahel-core'), 
					'simple' => esc_html__( 'Simple', 'sahel-core'), 
					'vertical' => esc_html__( 'Vertical', 'sahel-core')
				),
				'default' => 'standard'
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'tab_title',
			[
				'label'     => esc_html__( 'Title', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'text',
			[
				'label'       => esc_html__( 'Text', 'sahel-core' ),
				'type'        => \Elementor\Controls_Manager::WYSIWYG,
			]
		);

		sahel_core_generate_elementor_templates_control( $repeater );

		$this->add_control(
			'tabs_item',
			[
				'label'     => esc_html__( 'Tabs Item', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'sahel-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['holder_classes'] = $this->getHolderClasses( $params );
		?>

		<div class="eltdf-tabs <?php echo esc_attr( $params['holder_classes'] ); ?>">
			<ul class="eltdf-tabs-nav clearfix">
				<?php foreach ( $params['tabs_item'] as $tab ) { ?>
					<li>
						<?php if ( ! empty( $tab['tab_title'] ) ) { ?>
							<a href="#tab-<?php echo sanitize_title( $tab['tab_title'] ) ?>"><?php echo esc_html( $tab['tab_title'] ); ?></a>
						<?php } ?>
					</li>
				<?php } ?>
			</ul>

			<?php foreach ( $params['tabs_item'] as $tab ) {

				$rand_number        = rand( 0, 1000 );
				$tab['tab_title']   = $tab['tab_title'] . '-' . $rand_number;

				$tab['template_id'] = ! empty( $tab['template_id'] ) ? $tab['template_id'] : '';

				$tab_template = Elementor\Plugin::instance()->frontend->get_builder_content_for_display($tab['template_id']);

				if( !empty($tab_template) ) {
					$tab['content'] = $tab_template;

				} else {
					$tab['content'] = $tab['text'];
				}

				echo sahel_core_get_shortcode_module_template_part( 'templates/tab-content', 'tabs', '', $tab );
			} ?>

		</div>
		<?php
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['type'] ) ? 'eltdf-tabs-' . esc_attr( $params['type'] ) : 'eltdf-tabs-standard';
		
		return implode( ' ', $holderClasses );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorTabs() );