<?php
class ElementorSwappingImageGallery extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_swapping_image_gallery'; 
	}

	public function get_title() {
		return esc_html__( 'Swapping Image Gallery', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-swapping-image-gallery';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'description',
			[
				'label'     => esc_html__( 'Description', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'gallery_image',
			[
				'label'     => esc_html__( 'Main Image', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Select image from media library', 'sahel-core' )
			]
		);

		$repeater->add_control(
			'thumbnail',
			[
				'label'     => esc_html__( 'Thumbnail', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Select image from media library', 'sahel-core' )
			]
		);

		$this->add_control(
			'image_items',
			[
				'label'     => esc_html__( 'Image Items', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'sahel-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		foreach ($params['image_items'] as $key => $item ) {
			$gal_id = $params['image_items'][$key]['gallery_image'];
			$thumb_id = $params['image_items'][$key]['thumbnail'];
			$params['image_items'][$key]['gallery_image'] = !empty($gal_id) ? $gal_id['id'] : $gal_id;
			$params['image_items'][$key]['thumbnail'] = !empty($thumb_id) ? $thumb_id['id'] : $thumb_id;
		}

		$params['slider_data']			= $this->getSliderData( $params );

		echo sahel_core_get_shortcode_module_template_part( 'templates/swapping-image-gallery', 'swapping-image-gallery', '', $params );

	}

	private function getSliderData( $params ) {
		$slider_data = array();
		
		$slider_data['data-slider-animate-in'] 	= 'fadeIn';
		
		return $slider_data;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorSwappingImageGallery() );