<?php
class ElementorSectionTitle extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_section_title'; 
	}

	public function get_title() {
		return esc_html__( 'Section Title', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-section-title';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_class',
			[
				'label'     => esc_html__( 'Custom CSS Class', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'sahel-core' )
			]
		);

		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'standard' => esc_html__( 'Standard', 'sahel-core'), 
					'two-columns' => esc_html__( 'Two Columns', 'sahel-core')
				),
				'default' => 'standard'
			]
		);

		$this->add_control(
			'title_position',
			[
				'label'     => esc_html__( 'Title - Text Position', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'title-left' => esc_html__( 'Title Left - Text Right', 'sahel-core'), 
					'title-right' => esc_html__( 'Title Right - Text Left', 'sahel-core')
				),
				'default' => 'title-left',
				'condition' => [
					'type' => array( 'two-columns' )
				]
			]
		);

		$this->add_control(
			'columns_space',
			[
				'label'     => esc_html__( 'Space Between Columns', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'normal' => esc_html__( 'Normal', 'sahel-core'), 
					'small' => esc_html__( 'Small', 'sahel-core'), 
					'tiny' => esc_html__( 'Tiny', 'sahel-core')
				),
				'default' => 'normal',
				'condition' => [
					'type' => array( 'two-columns' )
				]
			]
		);

		$this->add_control(
			'position',
			[
				'label'     => esc_html__( 'Horizontal Position', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'left' => esc_html__( 'Left', 'sahel-core'), 
					'center' => esc_html__( 'Center', 'sahel-core'), 
					'right' => esc_html__( 'Right', 'sahel-core')
				),
				'default' => '',
				'condition' => [
					'type' => array( 'standard' )
				]
			]
		);

		$this->add_control(
			'holder_padding',
			[
				'label'     => esc_html__( 'Holder Side Padding (px or %)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'     => esc_html__( 'Subitle', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'text',
			[
				'label'     => esc_html__( 'Text', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__( 'Title Style', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'h1' => esc_html__( 'h1', 'sahel-core'), 
					'h2' => esc_html__( 'h2', 'sahel-core'), 
					'h3' => esc_html__( 'h3', 'sahel-core'), 
					'h4' => esc_html__( 'h4', 'sahel-core'), 
					'h5' => esc_html__( 'h5', 'sahel-core'), 
					'h6' => esc_html__( 'h6', 'sahel-core')
				),
				'default' => 'h1',
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'title_bold_words',
			[
				'label'     => esc_html__( 'Words with Bold Font Weight', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter the positions of the words you would like to display in a &quot;bold&quot; font weight. Separate the positions with commas (e.g. if you would like the first, second, and third word to have a light font weight, you would enter &quot;1,2,3&quot;)', 'sahel-core' ),
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'title_light_words',
			[
				'label'     => esc_html__( 'Words with Light Font Weight', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter the positions of the words you would like to display in a &quot;light&quot; font weight. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a light font weight, you would enter &quot;1,3,4&quot;)', 'sahel-core' ),
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'title_break_words',
			[
				'label'     => esc_html__( 'Position of Line Break', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter the position of the word after which you would like to create a line break (e.g. if you would like the line break after the 3rd word, you would enter &quot;3&quot;)', 'sahel-core' ),
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'disable_break_words',
			[
				'label'     => esc_html__( 'Disable Line Break for Smaller Screens', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'sahel-core'), 
					'yes' => esc_html__( 'Yes', 'sahel-core')
				),
				'default' => 'no',
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'subtitle_style',
			[
				'label' => esc_html__( 'Subtitle Style', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'subtitle_tag',
			[
				'label'     => esc_html__( 'Subtitle Tag', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'h1' => esc_html__( 'h1', 'sahel-core'), 
					'h2' => esc_html__( 'h2', 'sahel-core'), 
					'h3' => esc_html__( 'h3', 'sahel-core'), 
					'h4' => esc_html__( 'h4', 'sahel-core'), 
					'h5' => esc_html__( 'h5', 'sahel-core'), 
					'h6' => esc_html__( 'h6', 'sahel-core'), 
					'p' => esc_html__( 'p', 'sahel-core')
				),
				'default' => 'h6',
				'condition' => [
					'subtitle!' => ''
				]
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Subtitle Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'subtitle!' => ''
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'text_style',
			[
				'label' => esc_html__( 'Text Style', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'text_tag',
			[
				'label'     => esc_html__( 'Text Tag', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'h1' => esc_html__( 'h1', 'sahel-core'), 
					'h2' => esc_html__( 'h2', 'sahel-core'), 
					'h3' => esc_html__( 'h3', 'sahel-core'), 
					'h4' => esc_html__( 'h4', 'sahel-core'), 
					'h5' => esc_html__( 'h5', 'sahel-core'), 
					'h6' => esc_html__( 'h6', 'sahel-core'), 
					'p' => esc_html__( 'p', 'sahel-core')
				),
				'default' => 'p',
				'condition' => [
					'text!' => ''
				]
			]
		);

		$this->add_control(
			'text_color',
			[
				'label'     => esc_html__( 'Text Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'text!' => ''
				]
			]
		);

		$this->add_control(
			'text_font_size',
			[
				'label'     => esc_html__( 'Text Font Size (px)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'text!' => ''
				]
			]
		);

		$this->add_control(
			'text_line_height',
			[
				'label'     => esc_html__( 'Text Line Height (px)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'text!' => ''
				]
			]
		);

		$this->add_control(
			'text_font_weight',
			[
				'label'     => esc_html__( 'Text Font Weight', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'100' => esc_html__( '100 Thin', 'sahel-core'), 
					'200' => esc_html__( '200 Thin-Light', 'sahel-core'), 
					'300' => esc_html__( '300 Light', 'sahel-core'), 
					'400' => esc_html__( '400 Normal', 'sahel-core'), 
					'500' => esc_html__( '500 Medium', 'sahel-core'), 
					'600' => esc_html__( '600 Semi-Bold', 'sahel-core'), 
					'700' => esc_html__( '700 Bold', 'sahel-core'), 
					'800' => esc_html__( '800 Extra-Bold', 'sahel-core'), 
					'900' => esc_html__( '900 Ultra-Bold', 'sahel-core')
				),
				'default' => '',
				'condition' => [
					'text!' => ''
				]
			]
		);

		$this->add_control(
			'text_margin',
			[
				'label'     => esc_html__( 'Text Top Margin (px)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'text!' => ''
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		
		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['holder_styles']  = $this->getHolderStyles( $params );
		$params['title']          = $this->getModifiedTitle( $params );
		$params['subtitle']       = $this->getSubTitle( $params );
		$params['title_tag']      = ! empty( $params['title_tag'] ) ? $params['title_tag'] : 'h1';
		$params['title_styles']   = $this->getTitleStyles( $params );
		$params['subtitle_tag']      = ! empty( $params['subtitle_tag'] ) ? $params['subtitle_tag'] : 'h6';
		$params['subtitle_styles']   = $this->getSubTitleStyles( $params );
		$params['text_tag']       = ! empty( $params['text_tag'] ) ? $params['text_tag'] : 'p';
		$params['text_styles']    = $this->getTextStyles( $params );

		echo sahel_core_get_shortcode_module_template_part( 'templates/section-title', 'section-title', '', $params );
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['type'] ) ? 'eltdf-st-' . $params['type'] : 'eltdf-st-standard';
		$holderClasses[] = ! empty( $params['title_position'] ) ? 'eltdf-st-' . $params['title_position'] : 'eltdf-st-title-left';
		$holderClasses[] = ! empty( $params['columns_space'] ) ? 'eltdf-st-' . $params['columns_space'] . '-space' : 'eltdf-st-normal-space';
		$holderClasses[] = $params['disable_break_words'] === 'yes' ? 'eltdf-st-disable-title-break' : '';
		
		return implode( ' ', $holderClasses );
	}

	private function getHolderStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['holder_padding'] ) ) {
			$styles[] = 'padding: 0 ' . $params['holder_padding'];
		}
		
		if ( ! empty( $params['position'] ) ) {
			$styles[] = 'text-align: ' . $params['position'];
		}
		
		return implode( ';', $styles );
	}

	private function getModifiedTitle( $params ) {
		$title             = $params['title'];
		$title_bold_words  = str_replace( ' ', '', $params['title_bold_words'] );
		$title_light_words = str_replace( ' ', '', $params['title_light_words'] );
		$title_break_words = str_replace( ' ', '', $params['title_break_words'] );
		
		if ( ! empty( $title ) ) {
			$bold_words  = explode( ',', $title_bold_words );
			$light_words = explode( ',', $title_light_words );
			$split_title = explode( ' ', $title );
			
			if ( ! empty( $title_bold_words ) ) {
				foreach ( $bold_words as $value ) {
					if ( ! empty( $split_title[ $value - 1 ] ) ) {
						$split_title[ $value - 1 ] = '<span class="eltdf-st-title-bold">' . $split_title[ $value - 1 ] . '</span>';
					}
				}
			}
			
			if ( ! empty( $title_light_words ) ) {
				foreach ( $light_words as $value ) {
					if ( ! empty( $split_title[ $value - 1 ] ) ) {
						$split_title[ $value - 1 ] = '<span class="eltdf-st-title-light">' . $split_title[ $value - 1 ] . '</span>';
					}
				}
			}
			
			if ( ! empty( $title_break_words ) ) {

				$title_break_words = intval($title_break_words);

				if ( ! empty( $split_title[ $title_break_words - 1 ] ) ) {
					$split_title[ $title_break_words - 1 ] = $split_title[ $title_break_words - 1 ] . '<br />';
				}
			}
			
			$title = implode( ' ', $split_title );
		}
		
		return $title;
	}

	private function getSubTitle( $params ) {
		$subtitle             = $params['subtitle'];
		
		return $subtitle;
	}

	private function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_color'] ) ) {
			$styles[] = 'color: ' . $params['title_color'];
		}
		
		return implode( ';', $styles );
	}

	private function getSubTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['subtitle_color'] ) ) {
			$styles[] = 'color: ' . $params['subtitle_color'];
		}
		
		return implode( ';', $styles );
	}

	private function getTextStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['text_color'] ) ) {
			$styles[] = 'color: ' . $params['text_color'];
		}
		
		if ( ! empty( $params['text_font_size'] ) ) {
			$styles[] = 'font-size: ' . sahel_elated_filter_px( $params['text_font_size'] ) . 'px';
		}
		
		if ( ! empty( $params['text_line_height'] ) ) {
			$styles[] = 'line-height: ' . sahel_elated_filter_px( $params['text_line_height'] ) . 'px';
		}
		
		if ( ! empty( $params['text_font_weight'] ) ) {
			$styles[] = 'font-weight: ' . $params['text_font_weight'];
		}
		
		if ( $params['text_margin'] !== '' ) {
			$styles[] = 'margin-top: ' . sahel_elated_filter_px( $params['text_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorSectionTitle() );