<?php
class ElementorScrollingImage extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_scrolling_image'; 
	}

	public function get_title() {
		return esc_html__( 'Scrolling Image', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-scrolling-image';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'image',
			[
				'label'     => esc_html__( 'Image', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Select image from media library. Make sure the image is at least 700px wide.', 'sahel-core' )
			]
		);

		$this->add_control(
			'scrolling_direction',
			[
				'label'     => esc_html__( 'Scrolling Direction', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'vertical' => esc_html__( 'Vertical', 'sahel-core'), 
					'horizontal' => esc_html__( 'Horizontal', 'sahel-core')
				),
				'default' => 'vertical'
			]
		);

		$this->add_control(
			'enable_image_shadow',
			[
				'label'     => esc_html__( 'Enable Image Shadow', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'sahel-core'), 
					'yes' => esc_html__( 'Yes', 'sahel-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'custom_link',
			[
				'label'     => esc_html__( 'Custom Link', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'custom_link_target',
			[
				'label'     => esc_html__( 'Custom Link Target', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Same Window', 'sahel-core'), 
					'_blank' => esc_html__( 'New Window', 'sahel-core')
				),
				'default' => '_self',
				'condition' => [
					'custom_link!' => ''
				]
			]
		);

		$this->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'title_top_margin',
			[
				'label'     => esc_html__( 'Title Top Margin (px)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'bottom_buttons',
			[
				'label'     => esc_html__( 'Enable Bottom Double Custom Link Functionality', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => sahel_elated_get_yes_no_select_array( false, false ),
				'default'   => 'no',
				'label_block' => true
			]
		);

		$this->add_control(
			'bottom_button_one_link',
			[
				'label'     => esc_html__( 'First Bottom Link', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'bottom_buttons' => 'yes'
				],
			]
		);

		$this->add_control(
			'bottom_button_one_link_target',
			[
				'label'     => esc_html__( 'First Bottom Link Target', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => sahel_elated_get_link_target_array(),
				'condition' => [
					'bottom_button_one_link!' => '',
				],
				'default'	=> '_blank'
			]
		);

		$this->add_control(
			'bottom_button_one_label',
			[
				'label'     => esc_html__( 'First Bottom Link Label', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'bottom_buttons' => 'yes'
				],
			]
		);

		$this->add_control(
			'bottom_button_two_link',
			[
				'label'     => esc_html__( 'Second Bottom Link', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'bottom_buttons' => 'yes'
				],
			]
		);

		$this->add_control(
			'bottom_button_two_link_target',
			[
				'label'     => esc_html__( 'Second Bottom Link Target', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => sahel_elated_get_link_target_array(),
				'condition' => [
					'bottom_button_two_link!' => '',
				],
				'default'	=> '_blank'
			]
		);

		$this->add_control(
			'bottom_button_two_label',
			[
				'label'     => esc_html__( 'Second Bottom Link Label', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'bottom_buttons' => 'yes'
				],
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['image'] = !empty($params['image']) ? $params['image']['id'] : $params['image'];
		$params['bottom_button_one_link_target'] = !empty($params['bottom_button_one_link_target']) ? $params['bottom_button_one_link_target'] : '_blank';
		$params['bottom_button_two_link_target'] = !empty($params['bottom_button_two_link_target']) ? $params['bottom_button_two_link_target'] : '_blank';

		$params['holder_classes']     = $this->getHolderClasses( $params );
		$params['image']              = $this->getImage( $params );
		$params['title_styles']       = $this->getTitleStyles( $params );
		$params['bottom_styles'] 	  = $this->getBottomStyles($params);

		echo sahel_core_get_shortcode_module_template_part( 'templates/scrolling-image-template', 'scrolling-image', '', $params );
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = $params['enable_image_shadow'] === 'yes' ? 'eltdf-has-shadow' : '';
		$holderClasses[] = !empty($params['scrolling_direction']) ? 'eltdf-scrolling-'.$params['scrolling_direction'] : '';
		$holderClasses[] = $params['bottom_buttons'] === 'yes' ? 'eltdf-has-bottom-buttons' : '';
		
		return implode( ' ', $holderClasses );
	}

	private function getImage( $params ) {
		$image = array();
		
		if ( ! empty( $params['image'] ) ) {
			$id = $params['image'];
			
			$image['image_id'] = $id;
			$image_original    = wp_get_attachment_image_src( $id, 'full' );
			$image['url']      = $image_original[0];
			$image['alt']      = get_post_meta( $id, '_wp_attachment_image_alt', true );
		}
		
		return $image;
	}

	private function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_color'] ) ) {
			$styles[] = 'color: ' . $params['title_color'];
		}
		
		if ( $params['title_top_margin'] !== '' ) {
			$styles[] = 'margin-top: ' . sahel_elated_filter_px( $params['title_top_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}

	private function getBottomStyles($params) {
		$styles = array();
		if (!empty($params['title_color'])) {
			$styles[] = 'color: ' . $params['title_color'];
		}
		return implode(';', $styles);
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorScrollingImage() );