<?php
class ElementorProcess extends \Elementor\Widget_Base {

	public function get_name() {
		return 'eltdf_process'; 
	}

	public function get_title() {
		return esc_html__( 'Process', 'sahel-core' );
	}

	public function get_icon() {
		return 'sahel-elementor-custom-icon sahel-elementor-process';
	}

	public function get_categories() {
		return [ 'elated' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'sahel-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_class',
			[
				'label'     => esc_html__( 'Custom CSS Class', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'sahel-core' )
			]
		);

		$this->add_control(
			'number_of_columns',
			[
				'label'     => esc_html__( 'Number Of Columns', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'two' => esc_html__( 'Two', 'sahel-core'), 
					'three' => esc_html__( 'Three', 'sahel-core'), 
					'four' => esc_html__( 'Four', 'sahel-core')
				),
				'default' => 'three'
			]
		);

		$this->add_control(
			'switch_to_one_column',
			[
				'label'     => esc_html__( 'Switch to One Column', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Choose on which stage item will be in one column', 'sahel-core' ),
				'options' => array(
					'' => esc_html__( 'Default None', 'sahel-core'), 
					'1366' => esc_html__( 'Below 1366px', 'sahel-core'), 
					'1024' => esc_html__( 'Below 1024px', 'sahel-core'), 
					'768' => esc_html__( 'Below 768px', 'sahel-core'), 
					'680' => esc_html__( 'Below 680px', 'sahel-core'), 
					'480' => esc_html__( 'Below 480px', 'sahel-core')
				),
				'default' => ''
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'custom_class',
			[
				'label'     => esc_html__( 'Custom CSS Class', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'sahel-core' )
			]
		);

		$repeater->add_control(
			'process_image',
			[
				'label'     => esc_html__( 'Process Item Image', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'process_image_margin',
			[
				'label'     => esc_html__( 'Process Image Margin (px)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Set margin in this format - 10px 5px 10px 5px', 'sahel-core' ),
				'condition' => [
					'process_image!' => ''
				]
			]
		);

		$repeater->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'sahel-core'), 
					'h1' => esc_html__( 'h1', 'sahel-core'), 
					'h2' => esc_html__( 'h2', 'sahel-core'), 
					'h3' => esc_html__( 'h3', 'sahel-core'), 
					'h4' => esc_html__( 'h4', 'sahel-core'), 
					'h5' => esc_html__( 'h5', 'sahel-core'), 
					'h6' => esc_html__( 'h6', 'sahel-core')
				),
				'default' => '',
				'condition' => [
					'title!' => ''
				]
			]
		);

		$repeater->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'title!' => ''
				]
			]
		);

		$repeater->add_control(
			'text',
			[
				'label'     => esc_html__( 'Text', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA
			]
		);

		$repeater->add_control(
			'text_color',
			[
				'label'     => esc_html__( 'Text Color', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'text!' => ''
				]
			]
		);

		$repeater->add_control(
			'text_top_margin',
			[
				'label'     => esc_html__( 'Text Top Margin (px)', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'text!' => ''
				]
			]
		);

		$this->add_control(
			'process_item',
			[
				'label'     => esc_html__( 'Process Item', 'sahel-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'sahel-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['holder_classes'] = $this->getHolderClasses($params);
		$params['number_of_items'] = $this->getNumberOfItems( $params['number_of_columns'] );

		?>
		<div <?php echo sahel_elated_get_class_attribute($params['holder_classes']); ?>>
			<div class="eltdf-process-inner ">

				<?php
				$i = 1;

				foreach ( $params['process_item'] as $pitem ) {

					$pitem['text_top_margin'] = !empty($pitem['text_top_margin']) ? $pitem['text_top_margin'] : '';
					$pitem['process_image_margin'] = !empty($pitem['process_image_margin']) ? $pitem['process_image_margin'] : '';
					$pitem['title_tag'] = !empty($pitem['title_tag']) ? $pitem['title_tag'] : 'h5';

					$pitem['holder_classes'] = $this->getItemClasses( $pitem );
					$pitem['process_image']  = $this->getProcessImage( $pitem );
					$pitem['title_styles']   = $this->getTitleStyles( $pitem );
					$pitem['text_styles']    = $this->getTextStyles( $pitem );
					$pitem['image_styles']    = $this->getImageStyles( $pitem );

					echo sahel_core_get_shortcode_module_template_part('templates/process-item-template', 'process', '', $pitem);
				} ?>
			</div>
		</div>

		<?php
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		$holderClasses[] = 'eltdf-process-holder';
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['number_of_columns'] ) ? 'eltdf-' . $params['number_of_columns'] . '-columns' : 'eltdf-three-columns';
		$holderClasses[] = ! empty( $params['switch_to_one_column'] ) ? 'eltdf-responsive-' . $params['switch_to_one_column'] : '';
		
		return implode( ' ', $holderClasses );
	}

	private function getNumberOfItems( $params ) {
		$number = 3;
		
		switch ($params) {
			case 'two':
				$number = 2;
				break;
			case 'three':
				$number = 3;
				break;
			case 'four':
				$number = 4;
				break;
		}
		
		return $number;
	}

	private function getItemClasses( $params ) {
		$holderClasses = array();

		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';

		return implode( ' ', $holderClasses );
	}

	private function getProcessImage( $params ){

		if(!empty($params['process_image'])){
			$id = $params['process_image']['id'];
			$image = wp_get_attachment_image_src($id, 'full');

			return $image[0];
		}
	}

	private function getTitleStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['title_color'] ) ) {
			$styles[] = 'color: ' . $params['title_color'];
		}

		return implode( ';', $styles );
	}

	private function getTextStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['text_color'] ) ) {
			$styles[] = 'color: ' . $params['text_color'];
		}

		if ( $params['text_top_margin'] !== '' ) {
			$styles[] = 'margin-top: ' . sahel_elated_filter_px( $params['text_top_margin'] ) . 'px';
		}

		return implode( ';', $styles );
	}

	private function getImageStyles( $params ) {
		$styles = array();

		if ( $params['process_image_margin'] !== '' ) {
			$styles[] = 'margin: ' . $params['process_image_margin'];
		}

		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ElementorProcess() );